/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.runtime.exceptions.NoImplicitConversionException;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class ToStringNode
extends PackNode {
    protected final boolean convertNumbersToStrings;
    private final String conversionMethod;
    private final boolean inspectOnConversionFailure;
    private final Object valueOnNil;
    @Node.Child
    private CallDispatchHeadNode toStrNode;
    @Node.Child
    private CallDispatchHeadNode toSNode;
    @Node.Child
    private KernelNodes.ToSNode inspectNode;
    @Node.Child
    private IsTaintedNode isTaintedNode;
    private final ConditionProfile taintedProfile = ConditionProfile.createBinaryProfile();

    public ToStringNode(RubyContext context, boolean convertNumbersToStrings, String conversionMethod, boolean inspectOnConversionFailure, Object valueOnNil) {
        super(context);
        this.convertNumbersToStrings = convertNumbersToStrings;
        this.conversionMethod = conversionMethod;
        this.inspectOnConversionFailure = inspectOnConversionFailure;
        this.valueOnNil = valueOnNil;
        this.isTaintedNode = IsTaintedNodeGen.create(context, this.getEncapsulatingSourceSection(), null);
    }

    public abstract Object executeToString(VirtualFrame var1, Object var2);

    @Specialization(guards={"isNil(nil)"})
    public Object toStringNil(VirtualFrame frame, Object nil) {
        return this.valueOnNil;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"convertNumbersToStrings"})
    public ByteList toString(int value) {
        return new ByteList(Integer.toString(value).getBytes(StandardCharsets.US_ASCII));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"convertNumbersToStrings"})
    public ByteList toString(long value) {
        return new ByteList(Long.toString(value).getBytes(StandardCharsets.US_ASCII));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"convertNumbersToStrings"})
    public ByteList toString(double value) {
        return new ByteList(Double.toString(value).getBytes(StandardCharsets.US_ASCII));
    }

    @Specialization(guards={"isRubyString(string)"})
    public ByteList toStringString(VirtualFrame frame, DynamicObject string) {
        if (this.taintedProfile.profile(this.isTaintedNode.executeIsTainted(string))) {
            this.setTainted(frame);
        }
        return StringOperations.getByteList(string);
    }

    @Specialization(guards={"isRubyArray(array)"})
    public ByteList toString(VirtualFrame frame, DynamicObject array) {
        Object value;
        if (this.toSNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toSNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true, MissingBehavior.RETURN_MISSING));
        }
        if (RubyGuards.isRubyString(value = this.toSNode.call(frame, array, "to_s", null, new Object[0]))) {
            if (this.taintedProfile.profile(this.isTaintedNode.executeIsTainted(value))) {
                this.setTainted(frame);
            }
            return StringOperations.getByteList((DynamicObject)value);
        }
        CompilerDirectives.transferToInterpreter();
        if (value == DispatchNode.MISSING) {
            throw new NoImplicitConversionException(array, "String");
        }
        throw new NoImplicitConversionException(array, "String");
    }

    @Specialization(guards={"!isRubyString(object)", "!isRubyArray(object)"})
    public ByteList toString(VirtualFrame frame, Object object) {
        Object value;
        if (this.toStrNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toStrNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true, MissingBehavior.RETURN_MISSING));
        }
        if (RubyGuards.isRubyString(value = this.toStrNode.call(frame, object, this.conversionMethod, null, new Object[0]))) {
            if (this.taintedProfile.profile(this.isTaintedNode.executeIsTainted(value))) {
                this.setTainted(frame);
            }
            return StringOperations.getByteList((DynamicObject)value);
        }
        if (this.inspectOnConversionFailure) {
            if (this.inspectNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.inspectNode = (KernelNodes.ToSNode)this.insert(KernelNodesFactory.ToSNodeFactory.create(this.getContext(), this.getEncapsulatingSourceSection(), new RubyNode[]{null}));
            }
            return StringOperations.getByteList(this.inspectNode.toS(frame, object));
        }
        CompilerDirectives.transferToInterpreter();
        if (value == DispatchNode.MISSING) {
            throw new NoImplicitConversionException(object, "String");
        }
        throw new NoImplicitConversionException(object, "String");
    }
}

