/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class AtExitManager {
    private final RubyContext context;
    private final Deque<DynamicObject> runOnExit = new ConcurrentLinkedDeque<DynamicObject>();
    private final Deque<DynamicObject> runOnExitAlways = new ConcurrentLinkedDeque<DynamicObject>();

    public AtExitManager(RubyContext context) {
        this.context = context;
    }

    public void add(DynamicObject block, boolean always) {
        assert (RubyGuards.isRubyProc(block));
        if (always) {
            this.runOnExitAlways.push(block);
        } else {
            this.runOnExit.push(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean normalExit) {
        try {
            if (normalExit) {
                this.runExitHooks(this.runOnExit);
            }
        }
        finally {
            this.runExitHooks(this.runOnExitAlways);
        }
    }

    private void runExitHooks(Deque<DynamicObject> stack) {
        while (true) {
            DynamicObject block;
            try {
                block = stack.pop();
            }
            catch (NoSuchElementException e) {
                break;
            }
            try {
                ProcNodes.rootCall(block, new Object[0]);
            }
            catch (RaiseException e) {
                Object rubyException = e.getRubyException();
                BacktraceFormatter.createDefaultFormatter(this.context).printBacktrace((DynamicObject)rubyException, Layouts.EXCEPTION.getBacktrace((DynamicObject)rubyException));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<DynamicObject> getHandlers() {
        ArrayList<DynamicObject> handlers = new ArrayList<DynamicObject>();
        handlers.addAll(this.runOnExit);
        handlers.addAll(this.runOnExitAlways);
        return handlers;
    }
}

