/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.object;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import java.util.HashSet;
import java.util.Set;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.ModuleFields;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.object.ObjectGraphVisitor;
import org.jruby.truffle.runtime.object.StopVisitingObjectsException;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

public class ObjectGraph {
    private final RubyContext context;

    public ObjectGraph(RubyContext context) {
        this.context = context;
    }

    public Set<DynamicObject> getObjects() {
        return this.visitObjects(new ObjectGraphVisitor(){

            @Override
            public boolean visit(DynamicObject object) throws StopVisitingObjectsException {
                return true;
            }
        });
    }

    public Set<DynamicObject> visitObjects(final ObjectGraphVisitor visitor) {
        final HashSet<DynamicObject> objects = new HashSet<DynamicObject>();
        this.visitRoots(new ObjectGraphVisitor(){

            @Override
            public boolean visit(DynamicObject object) throws StopVisitingObjectsException {
                if (objects.add(object)) {
                    visitor.visit(object);
                    return true;
                }
                return false;
            }
        });
        return objects;
    }

    private void visitRoots(final ObjectGraphVisitor visitor) {
        final Thread mainThread = Thread.currentThread();
        this.context.getSafepointManager().pauseAllThreadsAndExecute(null, false, new SafepointAction(){
            boolean keepVisiting = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(DynamicObject thread, Node currentNode) {
                3 var3_3 = this;
                synchronized (var3_3) {
                    if (!this.keepVisiting) {
                        return;
                    }
                    try {
                        if (Thread.currentThread() == mainThread) {
                            ObjectGraph.this.visitObject(ObjectGraph.this.context.getCoreLibrary().getGlobalVariablesObject(), visitor);
                            for (DynamicObject handler : ObjectGraph.this.context.getAtExitManager().getHandlers()) {
                                ObjectGraph.this.visitObject(handler, visitor);
                            }
                            for (DynamicObject handler : ObjectGraph.this.context.getObjectSpaceManager().getFinalizerHandlers()) {
                                ObjectGraph.this.visitObject(handler, visitor);
                            }
                        }
                        ObjectGraph.this.visitObject(thread, visitor);
                        if (Truffle.getRuntime().getCurrentFrame() != null) {
                            ObjectGraph.this.visitFrameInstance(Truffle.getRuntime().getCurrentFrame(), visitor);
                        }
                        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){

                            public Object visitFrame(FrameInstance frameInstance) {
                                try {
                                    ObjectGraph.this.visitFrameInstance(frameInstance, visitor);
                                }
                                catch (StopVisitingObjectsException e) {
                                    return new Object();
                                }
                                return null;
                            }
                        });
                    }
                    catch (StopVisitingObjectsException e) {
                        this.keepVisiting = false;
                    }
                }
            }
        });
    }

    private void visitObject(DynamicObject object, ObjectGraphVisitor visitor) throws StopVisitingObjectsException {
        if (visitor.visit(object)) {
            this.visitObject(Layouts.BASIC_OBJECT.getMetaClass(object), visitor);
            for (Property property : object.getShape().getPropertyListInternal(false)) {
                this.visitObject(property.get(object, object.getShape()), visitor);
            }
            if (RubyGuards.isRubyModule(object)) {
                this.visitModule(object, visitor);
            }
        }
    }

    private void visitModule(DynamicObject module, ObjectGraphVisitor visitor) {
        ModuleFields fields = Layouts.MODULE.getFields(module);
        for (DynamicObject ancestor : fields.ancestors()) {
            this.visitObject(ancestor, visitor);
        }
        for (RubyConstant constant : fields.getConstants().values()) {
            this.visitObject(constant.getValue(), visitor);
        }
    }

    private void visitObject(Object object, ObjectGraphVisitor visitor) throws StopVisitingObjectsException {
        if (object instanceof DynamicObject) {
            this.visitObject((DynamicObject)object, visitor);
        } else if (object instanceof Object[]) {
            for (Object child : (Object[])object) {
                this.visitObject(child, visitor);
            }
        } else if (object instanceof Entry) {
            Entry entry = (Entry)object;
            this.visitObject(entry.getKey(), visitor);
            this.visitObject(entry.getValue(), visitor);
            this.visitObject(entry.getNextInLookup(), visitor);
        } else if (object instanceof Frame) {
            this.visitFrame((Frame)object, visitor);
        } else if (object instanceof InternalMethod) {
            InternalMethod method = (InternalMethod)object;
            this.visitObject(method.getDeclarationFrame(), visitor);
        }
    }

    private void visitFrameInstance(FrameInstance frameInstance, ObjectGraphVisitor visitor) throws StopVisitingObjectsException {
        this.visitFrame(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true), visitor);
    }

    private void visitFrame(Frame frame, ObjectGraphVisitor visitor) throws StopVisitingObjectsException {
        MaterializedFrame declarationFrame;
        for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
            this.visitObject(frame.getValue(slot), visitor);
        }
        try {
            declarationFrame = RubyArguments.getDeclarationFrame(frame.getArguments());
        }
        catch (Exception e) {
            declarationFrame = null;
        }
        if (declarationFrame != null) {
            this.visitFrame((Frame)declarationFrame, visitor);
        }
    }
}

