/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.joda.time.DateTime;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.TimeLayout;

public class TimeLayoutImpl
extends BasicObjectLayoutImpl
implements TimeLayout {
    public static final TimeLayout INSTANCE = new TimeLayoutImpl();
    protected static final Shape.Allocator TIME_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey DATE_TIME_IDENTIFIER = new HiddenKey("dateTime");
    protected static final Property DATE_TIME_PROPERTY = Property.create((Object)DATE_TIME_IDENTIFIER, (Location)TIME_ALLOCATOR.locationForType(DateTime.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey OFFSET_IDENTIFIER = new HiddenKey("offset");
    protected static final Property OFFSET_PROPERTY = Property.create((Object)OFFSET_IDENTIFIER, (Location)TIME_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected TimeLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createTimeShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new TimeType(logicalClass, metaClass)).addProperty(DATE_TIME_PROPERTY).addProperty(OFFSET_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createTime(DynamicObjectFactory factory, DateTime dateTime, Object offset) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsTime(factory));
        assert (factory.getShape().hasProperty((Object)DATE_TIME_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)OFFSET_IDENTIFIER));
        assert (dateTime != null);
        assert (offset != null);
        return factory.newInstance(new Object[]{dateTime, offset});
    }

    @Override
    public boolean isTime(DynamicObject object) {
        return this.isTime(object.getShape().getObjectType());
    }

    private boolean isTime(ObjectType objectType) {
        return objectType instanceof TimeType;
    }

    private boolean createsTime(DynamicObjectFactory factory) {
        return this.isTime(factory.getShape().getObjectType());
    }

    @Override
    public DateTime getDateTime(DynamicObject object) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty((Object)DATE_TIME_IDENTIFIER));
        return (DateTime)DATE_TIME_PROPERTY.get(object, true);
    }

    @Override
    public void setDateTime(DynamicObject object, DateTime value) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty((Object)DATE_TIME_IDENTIFIER));
        assert (value != null);
        try {
            DATE_TIME_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Object getOffset(DynamicObject object) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty((Object)OFFSET_IDENTIFIER));
        return OFFSET_PROPERTY.get(object, true);
    }

    @Override
    public void setOffset(DynamicObject object, Object value) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty((Object)OFFSET_IDENTIFIER));
        assert (value != null);
        try {
            OFFSET_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class TimeType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public TimeType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public TimeType setLogicalClass(DynamicObject logicalClass) {
            return new TimeType(logicalClass, this.metaClass);
        }

        @Override
        public TimeType setMetaClass(DynamicObject metaClass) {
            return new TimeType(this.logicalClass, metaClass);
        }
    }
}

