/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ClassNodes;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.runtime.ModuleChain;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.AncestorIterator;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.core.IncludedModule;
import org.jruby.truffle.runtime.core.IncludedModulesIterator;
import org.jruby.truffle.runtime.core.MethodFilter;
import org.jruby.truffle.runtime.core.PrependMarker;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.object.ObjectIDOperations;

public class ModuleFields
implements ModuleChain {
    public DynamicObject rubyModuleObject;
    private final RubyContext context;
    public final ModuleChain start;
    @CompilerDirectives.CompilationFinal
    public ModuleChain parentModule;
    public final DynamicObject lexicalParent;
    public final String givenBaseName;
    public String name;
    private final Map<String, InternalMethod> methods = new ConcurrentHashMap<String, InternalMethod>();
    private final Map<String, RubyConstant> constants = new ConcurrentHashMap<String, RubyConstant>();
    private final Map<String, Object> classVariables = new ConcurrentHashMap<String, Object>();
    private final CyclicAssumption unmodifiedAssumption;
    private final Set<DynamicObject> dependents = Collections.newSetFromMap(new WeakHashMap());
    private final Set<DynamicObject> lexicalDependents = Collections.newSetFromMap(new WeakHashMap());

    public static void debugModuleChain(DynamicObject module) {
        assert (RubyGuards.isRubyModule(module));
        for (ModuleChain chain = Layouts.MODULE.getFields(module); chain != null; chain = chain.getParentModule()) {
            System.err.print(chain.getClass());
            if (!(chain instanceof PrependMarker)) {
                DynamicObject real = chain.getActualModule();
                System.err.print(" " + Layouts.MODULE.getFields(real).getName());
            }
            System.err.println();
        }
    }

    public ModuleFields(RubyContext context, DynamicObject lexicalParent, String givenBaseName) {
        assert (lexicalParent == null || RubyGuards.isRubyModule(lexicalParent));
        this.context = context;
        this.lexicalParent = lexicalParent;
        this.givenBaseName = givenBaseName;
        this.unmodifiedAssumption = new CyclicAssumption(String.valueOf(givenBaseName) + " is unmodified");
        this.start = new PrependMarker(this);
    }

    public void getAdoptedByLexicalParent(DynamicObject lexicalParent, String name, Node currentNode) {
        assert (RubyGuards.isRubyModule(lexicalParent));
        Layouts.MODULE.getFields(lexicalParent).setConstantInternal(currentNode, name, this.rubyModuleObject, false);
        Layouts.MODULE.getFields(lexicalParent).addLexicalDependent(this.rubyModuleObject);
        if (this.name == null) {
            DynamicObject classClass = Layouts.BASIC_OBJECT.getLogicalClass(this.getLogicalClass());
            DynamicObject objectClass = ClassNodes.getSuperClass(ClassNodes.getSuperClass(classClass));
            if (lexicalParent == objectClass) {
                this.name = name;
                this.updateAnonymousChildrenModules();
            } else if (Layouts.MODULE.getFields(lexicalParent).hasName()) {
                this.name = Layouts.MODULE.getFields(lexicalParent).getName() + "::" + name;
                this.updateAnonymousChildrenModules();
            }
        }
    }

    public void updateAnonymousChildrenModules() {
        for (Map.Entry<String, RubyConstant> entry : this.constants.entrySet()) {
            DynamicObject module;
            RubyConstant constant = entry.getValue();
            if (!RubyGuards.isRubyModule(constant.getValue()) || Layouts.MODULE.getFields(module = (DynamicObject)constant.getValue()).hasName()) continue;
            Layouts.MODULE.getFields(module).getAdoptedByLexicalParent(this.rubyModuleObject, entry.getKey(), null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void initCopy(DynamicObject from) {
        assert (RubyGuards.isRubyModule(from));
        this.methods.putAll(Layouts.MODULE.getFields((DynamicObject)from).methods);
        this.constants.putAll(Layouts.MODULE.getFields((DynamicObject)from).constants);
        this.classVariables.putAll(Layouts.MODULE.getFields((DynamicObject)from).classVariables);
        this.parentModule = Layouts.MODULE.getFields((DynamicObject)from).start.getParentModule() != Layouts.MODULE.getFields(from) ? Layouts.MODULE.getFields((DynamicObject)from).start.getParentModule() : Layouts.MODULE.getFields((DynamicObject)from).parentModule;
        for (DynamicObject ancestor : Layouts.MODULE.getFields(from).ancestors()) {
            Layouts.MODULE.getFields(ancestor).addDependent(this.rubyModuleObject);
        }
    }

    public void checkFrozen(Node currentNode) {
        if (this.getContext().getCoreLibrary() != null && ModuleFields.verySlowIsFrozen(this.getContext(), this.rubyModuleObject)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(this.getLogicalClass()).getName(), currentNode));
        }
    }

    public static boolean verySlowIsFrozen(RubyContext context, Object object) {
        final IsFrozenNode node = IsFrozenNodeGen.create(context, null, new LiteralNode(context, null, object));
        new Node(){
            @Node.Child
            RubyNode child;
            {
                this.child = node;
            }
        }.adoptChildren();
        return (Boolean)node.execute(null);
    }

    @Override
    public void insertAfter(DynamicObject module) {
        this.parentModule = new IncludedModule(module, this.parentModule);
    }

    @CompilerDirectives.TruffleBoundary
    public void include(Node currentNode, DynamicObject module) {
        assert (RubyGuards.isRubyModule(module));
        this.checkFrozen(currentNode);
        if (ModuleOperations.includesModule(module, this.rubyModuleObject)) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("cyclic include detected", currentNode));
        }
        ModuleChain inclusionPoint = this;
        ArrayDeque<DynamicObject> modulesToInclude = new ArrayDeque<DynamicObject>();
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).ancestors()) {
            if (ModuleOperations.includesModule(this.rubyModuleObject, ancestor)) {
                if (!this.isIncludedModuleBeforeSuperClass(ancestor)) continue;
                this.performIncludes(inclusionPoint, modulesToInclude);
                assert (modulesToInclude.isEmpty());
                inclusionPoint = this.parentModule;
                while (inclusionPoint.getActualModule() != ancestor) {
                    inclusionPoint = inclusionPoint.getParentModule();
                }
                continue;
            }
            modulesToInclude.push(ancestor);
        }
        this.performIncludes(inclusionPoint, modulesToInclude);
        this.newVersion();
    }

    public void performIncludes(ModuleChain inclusionPoint, Deque<DynamicObject> moduleAncestors) {
        while (!moduleAncestors.isEmpty()) {
            DynamicObject mod = moduleAncestors.pop();
            assert (RubyGuards.isRubyModule(mod));
            inclusionPoint.insertAfter(mod);
            Layouts.MODULE.getFields(mod).addDependent(this.rubyModuleObject);
        }
    }

    public boolean isIncludedModuleBeforeSuperClass(DynamicObject module) {
        assert (RubyGuards.isRubyModule(module));
        ModuleChain included = this.parentModule;
        while (included instanceof IncludedModule) {
            if (included.getActualModule() == module) {
                return true;
            }
            included = included.getParentModule();
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public void prepend(Node currentNode, DynamicObject module) {
        assert (RubyGuards.isRubyModule(module));
        this.checkFrozen(currentNode);
        if (ModuleOperations.includesModule(module, this.rubyModuleObject)) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("cyclic prepend detected", currentNode));
        }
        ModuleChain cur = this.start;
        for (ModuleChain mod = Layouts.MODULE.getFields((DynamicObject)module).start; !(mod == null || RubyGuards.isRubyModule(mod) && RubyGuards.isRubyClass(((ModuleFields)mod).rubyModuleObject)); mod = mod.getParentModule()) {
            if (mod instanceof PrependMarker || ModuleOperations.includesModule(this.rubyModuleObject, mod.getActualModule())) continue;
            cur.insertAfter(mod.getActualModule());
            Layouts.MODULE.getFields(mod.getActualModule()).addDependent(this.rubyModuleObject);
            cur = cur.getParentModule();
        }
        this.newVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public void setConstant(Node currentNode, String name, Object value) {
        RubyConstant currentConstant;
        if (this.getContext().getCoreLibrary().isLoadingRubyCore() && (currentConstant = this.constants.get(name)) != null) {
            return;
        }
        if (RubyGuards.isRubyModule(value)) {
            Layouts.MODULE.getFields((DynamicObject)value).getAdoptedByLexicalParent(this.rubyModuleObject, name, currentNode);
        } else {
            this.setConstantInternal(currentNode, name, value, false);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setAutoloadConstant(Node currentNode, String name, DynamicObject filename) {
        assert (RubyGuards.isRubyString(filename));
        this.setConstantInternal(currentNode, name, filename, true);
    }

    public void setConstantInternal(Node currentNode, String name, Object value, boolean autoload) {
        this.checkFrozen(currentNode);
        RubyConstant previous = this.constants.get(name);
        if (previous == null) {
            this.constants.put(name, new RubyConstant(this.rubyModuleObject, value, false, autoload));
        } else {
            this.constants.put(name, new RubyConstant(this.rubyModuleObject, value, previous.isPrivate(), autoload));
        }
        this.newLexicalVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public RubyConstant removeConstant(Node currentNode, String name) {
        this.checkFrozen(currentNode);
        RubyConstant oldConstant = this.constants.remove(name);
        this.newLexicalVersion();
        return oldConstant;
    }

    @CompilerDirectives.TruffleBoundary
    public void setClassVariable(Node currentNode, String variableName, Object value) {
        this.checkFrozen(currentNode);
        this.classVariables.put(variableName, value);
    }

    @CompilerDirectives.TruffleBoundary
    public Object removeClassVariable(Node currentNode, String name) {
        this.checkFrozen(currentNode);
        Object found = this.classVariables.remove(name);
        if (found == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.context.getCoreLibrary().nameErrorClassVariableNotDefined(name, this.rubyModuleObject, currentNode));
        }
        return found;
    }

    @CompilerDirectives.TruffleBoundary
    public void addMethod(Node currentNode, InternalMethod method) {
        InternalMethod currentMethod;
        assert (method != null);
        if (this.getContext().getCoreLibrary().isLoadingRubyCore() && (currentMethod = this.methods.get(method.getName())) != null && currentMethod.getSharedMethodInfo().getSourceSection() instanceof CoreSourceSection) {
            return;
        }
        this.checkFrozen(currentNode);
        this.methods.put(method.getName(), method.withDeclaringModule(this.rubyModuleObject));
        this.newVersion();
        if (this.context.getCoreLibrary().isLoaded() && !method.isUndefined()) {
            this.context.send(this.rubyModuleObject, "method_added", null, this.context.getSymbolTable().getSymbol(method.getName()));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void removeMethod(String methodName) {
        this.methods.remove(methodName);
        this.newVersion();
    }

    @CompilerDirectives.TruffleBoundary
    public void undefMethod(Node currentNode, String methodName) {
        InternalMethod method = ModuleOperations.lookupMethod(this.rubyModuleObject, methodName);
        if (method == null) {
            throw new UnsupportedOperationException();
        }
        this.undefMethod(currentNode, method);
    }

    @CompilerDirectives.TruffleBoundary
    public void undefMethod(Node currentNode, InternalMethod method) {
        this.addMethod(currentNode, method.undefined());
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod deepMethodSearch(String name) {
        InternalMethod method = ModuleOperations.lookupMethod(this.rubyModuleObject, name);
        if (method != null && !method.isUndefined()) {
            return method;
        }
        if (RubyGuards.isRubyModule(this.rubyModuleObject) && !RubyGuards.isRubyClass(this.rubyModuleObject) && (method = ModuleOperations.lookupMethod(this.context.getCoreLibrary().getObjectClass(), name)) != null && !method.isUndefined()) {
            return method;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void alias(Node currentNode, String newName, String oldName) {
        InternalMethod method = this.deepMethodSearch(oldName);
        if (method == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodErrorOnModule(oldName, this.rubyModuleObject, currentNode));
        }
        InternalMethod aliasMethod = method.withName(newName);
        if (ModuleOperations.isMethodPrivateFromName(newName)) {
            aliasMethod = aliasMethod.withVisibility(Visibility.PRIVATE);
        }
        this.addMethod(currentNode, aliasMethod);
    }

    @CompilerDirectives.TruffleBoundary
    public void changeConstantVisibility(Node currentNode, String name, boolean isPrivate) {
        this.checkFrozen(currentNode);
        RubyConstant rubyConstant = this.constants.get(name);
        if (rubyConstant == null) {
            throw new RaiseException(this.context.getCoreLibrary().nameErrorUninitializedConstant(this.rubyModuleObject, name, currentNode));
        }
        rubyConstant.setPrivate(isPrivate);
        this.newLexicalVersion();
    }

    public RubyContext getContext() {
        return this.context;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        CompilerDirectives.transferToInterpreter();
        if (this.givenBaseName != null) {
            return Layouts.MODULE.getFields(this.lexicalParent).getName() + "::" + this.givenBaseName;
        }
        if (this.getLogicalClass() == this.rubyModuleObject) {
            return "#<cyclic>";
        }
        return "#<" + Layouts.MODULE.getFields(this.getLogicalClass()).getName() + ":0x" + Long.toHexString(ObjectIDOperations.verySlowGetObjectID(this.rubyModuleObject)) + ">";
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasPartialName() {
        return this.hasName() || this.givenBaseName != null;
    }

    public String toString() {
        return super.toString() + "(" + this.getName() + ")";
    }

    public void newVersion() {
        this.newVersion(new HashSet<DynamicObject>(), false);
    }

    public void newLexicalVersion() {
        this.newVersion(new HashSet<DynamicObject>(), true);
    }

    public void newVersion(Set<DynamicObject> alreadyInvalidated, boolean considerLexicalDependents) {
        if (alreadyInvalidated.contains(this.rubyModuleObject)) {
            return;
        }
        this.unmodifiedAssumption.invalidate();
        alreadyInvalidated.add(this.rubyModuleObject);
        for (DynamicObject dependent : this.dependents) {
            Layouts.MODULE.getFields(dependent).newVersion(alreadyInvalidated, considerLexicalDependents);
        }
        if (considerLexicalDependents) {
            for (DynamicObject dependent : this.lexicalDependents) {
                Layouts.MODULE.getFields(dependent).newVersion(alreadyInvalidated, considerLexicalDependents);
            }
        }
    }

    public void addDependent(DynamicObject dependent) {
        RubyGuards.isRubyModule(dependent);
        this.dependents.add(dependent);
    }

    public void addLexicalDependent(DynamicObject lexicalChild) {
        assert (RubyGuards.isRubyModule(lexicalChild));
        if (lexicalChild != this.rubyModuleObject) {
            this.lexicalDependents.add(lexicalChild);
        }
    }

    public Assumption getUnmodifiedAssumption() {
        return this.unmodifiedAssumption.getAssumption();
    }

    public Map<String, RubyConstant> getConstants() {
        return this.constants;
    }

    public Map<String, InternalMethod> getMethods() {
        return this.methods;
    }

    public Map<String, Object> getClassVariables() {
        return this.classVariables;
    }

    @Override
    public ModuleChain getParentModule() {
        return this.parentModule;
    }

    @Override
    public DynamicObject getActualModule() {
        return this.rubyModuleObject;
    }

    public Iterable<DynamicObject> ancestors() {
        final ModuleChain top = this.start;
        return new Iterable<DynamicObject>(){

            @Override
            public Iterator<DynamicObject> iterator() {
                return new AncestorIterator(top);
            }
        };
    }

    public Iterable<DynamicObject> parentAncestors() {
        final ModuleChain top = this.start;
        return new Iterable<DynamicObject>(){

            @Override
            public Iterator<DynamicObject> iterator() {
                AncestorIterator iterator = new AncestorIterator(top);
                if (iterator.hasNext()) {
                    iterator.next();
                }
                return iterator;
            }
        };
    }

    public Iterable<DynamicObject> prependedAndIncludedModules() {
        final ModuleChain top = this.start;
        final ModuleFields currentModule = this;
        return new Iterable<DynamicObject>(){

            @Override
            public Iterator<DynamicObject> iterator() {
                return new IncludedModulesIterator(top, currentModule);
            }
        };
    }

    public Collection<DynamicObject> filterMethods(boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getAllMethods(this.rubyModuleObject) : this.getMethods();
        return this.filterMethods(allMethods, filter);
    }

    public Collection<DynamicObject> filterMethodsOnObject(boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getAllMethods(this.rubyModuleObject) : ModuleOperations.getMethodsUntilLogicalClass(this.rubyModuleObject);
        return this.filterMethods(allMethods, filter);
    }

    public Collection<DynamicObject> filterSingletonMethods(boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getMethodsBeforeLogicalClass(this.rubyModuleObject) : this.getMethods();
        return this.filterMethods(allMethods, filter);
    }

    public Collection<DynamicObject> filterMethods(Map<String, InternalMethod> allMethods, MethodFilter filter) {
        Map<String, InternalMethod> methods = ModuleOperations.withoutUndefinedMethods(allMethods);
        HashSet<DynamicObject> filtered = new HashSet<DynamicObject>();
        for (InternalMethod method : methods.values()) {
            if (!filter.filter(method)) continue;
            filtered.add(this.getContext().getSymbolTable().getSymbol(method.getName()));
        }
        return filtered;
    }

    public DynamicObject getLogicalClass() {
        return Layouts.BASIC_OBJECT.getLogicalClass(this.rubyModuleObject);
    }
}

