/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.time;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTimeZone;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.constants.ReadLiteralConstantNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadTimeZoneNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode hashNode;
    @Node.Child
    private ReadLiteralConstantNode envNode;
    private final DynamicObject TZ;

    public ReadTimeZoneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.envNode = new ReadLiteralConstantNode(context, sourceSection, new LiteralNode(context, sourceSection, this.getContext().getCoreLibrary().getObjectClass()), "ENV");
        this.TZ = Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"TZ", (Encoding)UTF8Encoding.INSTANCE), 16, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object tz = this.hashNode.call(frame, this.envNode.execute(frame), "[]", null, this.TZ);
        if (tz == this.nil()) {
            String zone = DateTimeZone.getDefault().toString();
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)zone, (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
        if (RubyGuards.isRubyString(tz)) {
            return tz;
        }
        throw new UnsupportedOperationException();
    }
}

