/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.rubinius.PointerNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.sockets.FDSet;
import org.jruby.truffle.runtime.sockets.FDSetFactory;
import org.jruby.truffle.runtime.sockets.FDSetFactoryFactory;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.unsafe.UnsafeHolder;

public abstract class IOPrimitiveNodes {
    private static int STDOUT = 1;

    @RubiniusPrimitive(name="io_select", needsSelf=false)
    public static abstract class IOSelectPrimitiveNode
    extends RubiniusPrimitiveNode {
        private static final FDSetFactory fdSetFactory = FDSetFactoryFactory.create();

        public IOSelectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyArray(readables)", "isNil(writables)", "isNil(errorables)"})
        public Object select(DynamicObject readables, DynamicObject writables, DynamicObject errorables, int timeout) {
            Object[] readableObjects = ArrayOperations.toObjectArray(readables);
            final int[] readableFds = this.getFileDescriptors(readables);
            final FDSet readableSet = fdSetFactory.create();
            for (int fd : readableFds) {
                readableSet.set(fd);
            }
            int result = this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return IOSelectPrimitiveNode.this.nativeSockets().select(IOSelectPrimitiveNode.max(readableFds) + 1, readableSet.getPointer(), PointerNodes.NULL_POINTER, PointerNodes.NULL_POINTER, PointerNodes.NULL_POINTER);
                }
            });
            if (result == -1) {
                return this.nil();
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{this.getSetObjects(readableObjects, readableFds, readableSet), Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0), Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0)}, 3);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(readables)", "isRubyArray(writables)", "isNil(errorables)"})
        public Object selectNilReadables(DynamicObject readables, DynamicObject writables, DynamicObject errorables, int timeout) {
            Object[] writableObjects = ArrayOperations.toObjectArray(writables);
            final int[] writableFds = this.getFileDescriptors(writables);
            final FDSet writableSet = fdSetFactory.create();
            for (int fd : writableFds) {
                writableSet.set(fd);
            }
            int result = this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return IOSelectPrimitiveNode.this.nativeSockets().select(IOSelectPrimitiveNode.max(writableFds) + 1, PointerNodes.NULL_POINTER, writableSet.getPointer(), PointerNodes.NULL_POINTER, PointerNodes.NULL_POINTER);
                }
            });
            if (result == -1) {
                return this.nil();
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0), this.getSetObjects(writableObjects, writableFds, writableSet), Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0)}, 3);
        }

        private int[] getFileDescriptors(DynamicObject fileDescriptorArray) {
            assert (RubyGuards.isRubyArray(fileDescriptorArray));
            Object[] objects = ArrayOperations.toObjectArray(fileDescriptorArray);
            int[] fileDescriptors = new int[objects.length];
            for (int n = 0; n < objects.length; ++n) {
                if (!(objects[n] instanceof DynamicObject)) {
                    throw new UnsupportedOperationException();
                }
                fileDescriptors[n] = Layouts.IO.getDescriptor((DynamicObject)objects[n]);
            }
            return fileDescriptors;
        }

        private static int max(int[] values) {
            assert (values.length > 0);
            int max = Integer.MIN_VALUE;
            for (int n = 0; n < values.length; ++n) {
                max = Math.max(max, values[n]);
            }
            return max;
        }

        private DynamicObject getSetObjects(Object[] objects, int[] fds, FDSet set) {
            Object[] setObjects = new Object[objects.length];
            int setFdsCount = 0;
            for (int n = 0; n < objects.length; ++n) {
                if (!set.isSet(fds[n])) continue;
                setObjects[setFdsCount] = objects[n];
                ++setFdsCount;
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), setObjects, setFdsCount);
        }
    }

    @RubiniusPrimitive(name="io_sysread")
    public static abstract class IOSysReadPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOSysReadPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject sysread(VirtualFrame frame, DynamicObject file, int length) {
            int readIteration;
            int fd = Layouts.IO.getDescriptor(file);
            ByteBuffer buffer = ByteBuffer.allocate(length);
            for (int toRead = length; toRead > 0; toRead -= readIteration) {
                this.getContext().getSafepointManager().poll(this);
                readIteration = this.posix().read(fd, buffer, toRead);
                buffer.position(readIteration);
            }
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(buffer.array()), 0, null);
        }
    }

    @RubiniusPrimitive(name="io_accept")
    public static abstract class AcceptNode
    extends RubiniusPrimitiveNode {
        public AcceptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int accept(DynamicObject io) {
            int newFd;
            int fd = Layouts.IO.getDescriptor(io);
            int[] addressLength = new int[]{16};
            long address = UnsafeHolder.U.allocateMemory(addressLength[0]);
            try {
                newFd = this.nativeSockets().accept(fd, this.getMemoryManager().newPointer(address), addressLength);
            }
            finally {
                UnsafeHolder.U.freeMemory(address);
            }
            if (newFd == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return newFd;
        }
    }

    @RubiniusPrimitive(name="io_seek", lowerFixnumParameters={0, 1})
    public static abstract class IOSeekPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOSeekPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int seek(VirtualFrame frame, DynamicObject io, int amount, int whence) {
            int fd = Layouts.IO.getDescriptor(io);
            return this.posix().lseek(fd, (long)amount, whence);
        }
    }

    @RubiniusPrimitive(name="io_close")
    public static abstract class IOClosePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode ensureOpenNode;

        public IOClosePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.ensureOpenNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public int close(VirtualFrame frame, DynamicObject io) {
            this.ensureOpenNode.call(frame, io, "ensure_open", null, new Object[0]);
            int fd = Layouts.IO.getDescriptor(io);
            if (fd == -1) {
                return 0;
            }
            int newDescriptor = -1;
            Layouts.IO.setDescriptor(io, newDescriptor);
            if (fd < 3) {
                return 0;
            }
            int result = this.posix().close(fd);
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return 0;
        }
    }

    @RubiniusPrimitive(name="io_write")
    public static abstract class IOWritePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOWritePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public int write(DynamicObject file, DynamicObject string) {
            int fd = Layouts.IO.getDescriptor(file);
            ByteList byteList = Layouts.STRING.getByteList(string);
            if (this.getContext().getDebugStandardOut() != null && fd == STDOUT) {
                this.getContext().getDebugStandardOut().write(byteList.unsafeBytes(), byteList.begin(), byteList.length());
                return byteList.length();
            }
            ByteBuffer buffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length());
            int total = 0;
            while (buffer.hasRemaining()) {
                this.getContext().getSafepointManager().poll(this);
                int written = this.posix().write(fd, buffer, buffer.remaining());
                if (written == -1) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
                buffer.position(buffer.position() + written);
                total += written;
            }
            return total;
        }
    }

    @RubiniusPrimitive(name="io_reopen_path")
    public static abstract class IOReopenPathPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode resetBufferingNode;

        public IOReopenPathPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.resetBufferingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        /*
         * Enabled aggressive block sorting
         */
        @CompilerDirectives.TruffleBoundary
        public void performReopenPath(DynamicObject file, DynamicObject path, int mode) {
            int fd;
            block6: {
                fd = Layouts.IO.getDescriptor(file);
                String pathString = StringOperations.getString(path);
                int otherFd = this.posix().open((CharSequence)pathString, mode, 666);
                if (otherFd < 0) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
                int result = this.posix().dup2(otherFd, fd);
                if (result == -1) {
                    int errno = this.posix().errno();
                    if (errno == Errno.EBADF.intValue()) {
                        Layouts.IO.setDescriptor(file, otherFd);
                        fd = otherFd;
                        break block6;
                    } else {
                        if (otherFd > 0) {
                            this.posix().close(otherFd);
                        }
                        CompilerDirectives.transferToInterpreter();
                        throw new RaiseException(this.getContext().getCoreLibrary().errnoError(errno, this));
                    }
                }
                this.posix().close(otherFd);
            }
            int newMode = this.posix().fcntl(fd, Fcntl.F_GETFL);
            if (newMode < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            Layouts.IO.setMode(file, newMode);
        }

        @Specialization(guards={"isRubyString(path)"})
        public Object reopenPath(VirtualFrame frame, DynamicObject file, DynamicObject path, int mode) {
            this.performReopenPath(file, path, mode);
            this.resetBufferingNode.call(frame, file, "reset_buffering", null, new Object[0]);
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_reopen")
    public static abstract class IOReopenPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode resetBufferingNode;

        public IOReopenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.resetBufferingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @CompilerDirectives.TruffleBoundary
        private void performReopen(DynamicObject file, DynamicObject io) {
            int fd = Layouts.IO.getDescriptor(file);
            int fdOther = Layouts.IO.getDescriptor(io);
            int result = this.posix().dup2(fd, fdOther);
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            int mode = this.posix().fcntl(fd, Fcntl.F_GETFL);
            if (mode < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            Layouts.IO.setMode(file, mode);
        }

        @Specialization
        public Object reopen(VirtualFrame frame, DynamicObject file, DynamicObject io) {
            this.performReopen(file, io);
            this.resetBufferingNode.call(frame, io, "reset_buffering", null, new Object[0]);
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_read_if_available")
    public static abstract class IOReadIfAvailableNode
    extends RubiniusPrimitiveNode {
        private static final FDSetFactory fdSetFactory = FDSetFactoryFactory.create();

        public IOReadIfAvailableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object readIfAvailable(DynamicObject file, int numberOfBytes) {
            if (numberOfBytes == 0) {
                return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(), 0, null);
            }
            int fd = Layouts.IO.getDescriptor(file);
            FDSet fdSet = fdSetFactory.create();
            fdSet.set(fd);
            Pointer timeout = Runtime.getSystemRuntime().getMemoryManager().allocateDirect(16);
            timeout.putLong(0L, 0L);
            timeout.putLong(8L, 0L);
            int res = this.nativeSockets().select(fd + 1, fdSet.getPointer(), PointerNodes.NULL_POINTER, PointerNodes.NULL_POINTER, timeout);
            if (res == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(Errno.EAGAIN.intValue(), this));
            }
            if (res < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.getContext().getPosix().errno(), this));
            }
            byte[] bytes = new byte[numberOfBytes];
            int bytesRead = this.getContext().getPosix().read(fd, bytes, numberOfBytes);
            if (bytesRead == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.getContext().getPosix().errno(), this));
            }
            if (bytesRead == 0) {
                return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(), 0, null);
            }
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(bytes), 0, null);
        }
    }

    @RubiniusPrimitive(name="io_ensure_open")
    public static abstract class IOEnsureOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOEnsureOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject ensureOpen(VirtualFrame frame, DynamicObject file) {
            int fd = Layouts.IO.getDescriptor(file);
            if (fd == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().ioError("closed stream", this));
            }
            if (fd == -2) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().ioError("shutdown stream", this));
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_fnmatch", needsSelf=false)
    public static abstract class IOFNMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOFNMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)", "isRubyString(path)"})
        public boolean fnmatch(DynamicObject pattern, DynamicObject path, int flags) {
            ByteList patternBytes = Layouts.STRING.getByteList(pattern);
            ByteList pathBytes = Layouts.STRING.getByteList(path);
            return Dir.fnmatch((byte[])patternBytes.getUnsafeBytes(), (int)patternBytes.getBegin(), (int)(patternBytes.getBegin() + patternBytes.getRealSize()), (byte[])pathBytes.getUnsafeBytes(), (int)pathBytes.getBegin(), (int)(pathBytes.getBegin() + pathBytes.getRealSize()), (int)flags) != 1;
        }
    }

    @RubiniusPrimitive(name="io_ftruncate")
    public static abstract class IOFTruncatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOFTruncatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int ftruncate(VirtualFrame frame, DynamicObject io, int length) {
            return this.ftruncate(frame, io, (long)length);
        }

        @Specialization
        public int ftruncate(VirtualFrame frame, DynamicObject io, long length) {
            int fd = Layouts.IO.getDescriptor(io);
            return this.posix().ftruncate(fd, length);
        }
    }

    @RubiniusPrimitive(name="io_truncate", needsSelf=false)
    public static abstract class IOTruncatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOTruncatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(path)"})
        public int truncate(DynamicObject path, int length) {
            return this.truncate(path, (long)length);
        }

        @Specialization(guards={"isRubyString(path)"})
        public int truncate(DynamicObject path, long length) {
            int result = this.posix().truncate((CharSequence)StringOperations.getString(path), length);
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @RubiniusPrimitive(name="io_open", needsSelf=false)
    public static abstract class IOOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(path)"})
        public int open(DynamicObject path, int mode, int permission) {
            return this.posix().open((CharSequence)StringOperations.getString(path), mode, permission);
        }
    }

    @RubiniusPrimitive(name="io_connect_pipe", needsSelf=false)
    public static abstract class IOConnectPipeNode
    extends RubiniusPrimitiveNode {
        private final int RDONLY;
        private final int WRONLY;

        public IOConnectPipeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.RDONLY = (Integer)context.getRubiniusConfiguration().get("rbx.platform.file.O_RDONLY");
            this.WRONLY = (Integer)context.getRubiniusConfiguration().get("rbx.platform.file.O_WRONLY");
        }

        @Specialization
        public boolean connectPipe(VirtualFrame frame, DynamicObject lhs, DynamicObject rhs) {
            int[] fds = new int[2];
            if (this.posix().pipe(fds) == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            this.newOpenFd(fds[0]);
            this.newOpenFd(fds[1]);
            Layouts.IO.setDescriptor(lhs, fds[0]);
            Layouts.IO.setMode(lhs, this.RDONLY);
            Layouts.IO.setDescriptor(rhs, fds[1]);
            Layouts.IO.setMode(rhs, this.WRONLY);
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private void newOpenFd(int newFd) {
            boolean FD_CLOEXEC = true;
            if (newFd > 2) {
                int flags = this.posix().fcntl(newFd, Fcntl.F_GETFD);
                if (flags == -1) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
                flags = this.posix().fcntlInt(newFd, Fcntl.F_SETFD, flags | 1);
                if (flags == -1) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
            }
        }
    }

    @RubiniusPrimitive(name="io_allocate")
    public static abstract class IOAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode newBufferNode;

        public IOAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.newBufferNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public DynamicObject allocate(VirtualFrame frame, DynamicObject classToAllocate) {
            DynamicObject buffer = (DynamicObject)this.newBufferNode.call(frame, this.getContext().getCoreLibrary().getInternalBufferClass(), "new", null, new Object[0]);
            return Layouts.IO.createIO(Layouts.CLASS.getInstanceFactory(classToAllocate), buffer, 0, 0, 0);
        }
    }
}

