/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.math.BigInteger;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class FixnumPrimitiveNodes {

    @RubiniusPrimitive(name="fixnum_pow")
    public static abstract class FixnumPowPrimitiveNode
    extends BignumNodes.BignumCoreMethodNode {
        private final ConditionProfile negativeProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile complexProfile = ConditionProfile.createBinaryProfile();

        public FixnumPowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"canShiftIntoInt(a, b)"})
        public int powTwo(int a, int b) {
            return 1 << b;
        }

        @Specialization(guards={"canShiftIntoInt(a, b)"})
        public int powTwo(int a, long b) {
            return 1 << (int)b;
        }

        @Specialization
        public Object pow(int a, int b) {
            return this.pow(a, (long)b);
        }

        @Specialization
        public Object pow(int a, long b) {
            return this.pow((long)a, b);
        }

        @Specialization
        public Object pow(int a, double b) {
            return this.pow((long)a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object powBignum(int a, DynamicObject b) {
            return this.powBignum((long)a, b);
        }

        @Specialization(guards={"canShiftIntoLong(a, b)"})
        public long powTwo(long a, int b) {
            return 1 << b;
        }

        @Specialization(guards={"canShiftIntoLong(a, b)"})
        public long powTwo(long a, long b) {
            return 1 << (int)b;
        }

        @Specialization
        public Object pow(long a, int b) {
            return this.pow(a, (long)b);
        }

        @Specialization
        public Object pow(long a, long b) {
            if (this.negativeProfile.profile(b < 0L)) {
                return null;
            }
            return this.fixnumOrBignum(this.bigPow(a, (int)b));
        }

        @CompilerDirectives.TruffleBoundary
        public BigInteger bigPow(long a, int b) {
            return BigInteger.valueOf(a).pow(b);
        }

        @Specialization
        public Object pow(long a, double b) {
            if (this.complexProfile.profile(a < 0L)) {
                return null;
            }
            return Math.pow(a, b);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBignum(b)"})
        public Object powBignum(long a, DynamicObject b) {
            if (a == 0L) {
                return 0;
            }
            if (a == 1L) {
                return 1;
            }
            if (a == -1L) {
                if (Layouts.BIGNUM.getValue(b).testBit(0)) {
                    return -1;
                }
                return 1;
            }
            if (Layouts.BIGNUM.getValue(b).compareTo(BigInteger.ZERO) < 0) {
                return null;
            }
            this.getContext().getRuntime().getWarnings().warn("in a**b, b may be too big");
            return Double.POSITIVE_INFINITY;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object pow(int a, DynamicObject b) {
            return null;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object pow(long a, DynamicObject b) {
            return null;
        }

        protected static boolean canShiftIntoInt(int a, int b) {
            return FixnumPowPrimitiveNode.canShiftIntoInt(a, (long)b);
        }

        protected static boolean canShiftIntoInt(int a, long b) {
            return a == 2 && b >= 0L && b <= 30L;
        }

        protected static boolean canShiftIntoLong(long a, int b) {
            return FixnumPowPrimitiveNode.canShiftIntoLong(a, (long)b);
        }

        protected static boolean canShiftIntoLong(long a, long b) {
            return a == 2L && b >= 0L && b <= 62L;
        }
    }

    @RubiniusPrimitive(name="fixnum_coerce")
    public static abstract class FixnumCoercePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private DoesRespondDispatchHeadNode toFRespond;
        @Node.Child
        private CallDispatchHeadNode toF;

        public FixnumCoercePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toFRespond = new DoesRespondDispatchHeadNode(context, false, false, MissingBehavior.RETURN_MISSING, null);
            this.toF = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public DynamicObject coerce(int a, int b) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new int[]{b, a}, 2);
        }

        @Specialization
        public DynamicObject coerce(long a, int b) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new long[]{b, a}, 2);
        }

        @Specialization(guards={"!isInteger(b)"})
        public DynamicObject coerce(int a, Object b) {
            return null;
        }
    }
}

