/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class BignumPrimitiveNodes {

    @RubiniusPrimitive(name="bignum_pow")
    public static abstract class BignumPowPrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile negativeProfile = ConditionProfile.createBinaryProfile();

        public BignumPowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject pow(DynamicObject a, int b) {
            return this.pow(a, (long)b);
        }

        @Specialization
        public DynamicObject pow(DynamicObject a, long b) {
            if (this.negativeProfile.profile(b < 0L)) {
                return null;
            }
            return Layouts.BIGNUM.createBignum(this.getContext().getCoreLibrary().getBignumFactory(), Layouts.BIGNUM.getValue(a).pow((int)b));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public double pow(DynamicObject a, double b) {
            return Math.pow(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Void pow(DynamicObject a, DynamicObject b) {
            throw new UnsupportedOperationException();
        }
    }
}

