/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.ReadBooleanObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadDoubleObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadIntegerObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadLongObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadMissingObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadObjectObjectFieldNode;

@NodeInfo(cost=NodeCost.UNINITIALIZED)
public class UninitializedReadObjectFieldNode
extends ReadObjectFieldNode {
    private final Object name;

    public UninitializedReadObjectFieldNode(Object name) {
        this.name = name;
    }

    @Override
    public Object execute(DynamicObject object) {
        return this.rewrite(object).execute(object);
    }

    @Override
    public boolean isSet(DynamicObject object) {
        return this.rewrite(object).isSet(object);
    }

    private ReadObjectFieldNode rewrite(DynamicObject object) {
        ReadObjectFieldChainNode newNode;
        ReadObjectFieldNode topNode;
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (object.updateShape() && (topNode = this.getTopNode()) != this) {
            return topNode;
        }
        Shape layout = object.getShape();
        Property property = layout.getProperty(this.name);
        if (property == null) {
            newNode = new ReadMissingObjectFieldNode(layout, this);
        } else {
            Location storageLocation = property.getLocation();
            assert (storageLocation != null);
            newNode = storageLocation instanceof BooleanLocation ? new ReadBooleanObjectFieldNode(layout, (BooleanLocation)storageLocation, this) : (storageLocation instanceof IntLocation ? new ReadIntegerObjectFieldNode(layout, (IntLocation)storageLocation, this) : (storageLocation instanceof LongLocation ? new ReadLongObjectFieldNode(layout, (LongLocation)storageLocation, this) : (storageLocation instanceof DoubleLocation ? new ReadDoubleObjectFieldNode(layout, (DoubleLocation)storageLocation, this) : new ReadObjectObjectFieldNode(layout, storageLocation, this))));
        }
        this.replace(newNode, "adding new read object field node to chain");
        return newNode;
    }

    private ReadObjectFieldNode getTopNode() {
        ReadObjectFieldNode topNode = this;
        while (topNode.getParent() instanceof ReadObjectFieldNode) {
            topNode = (ReadObjectFieldNode)topNode.getParent();
        }
        return topNode;
    }
}

