/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ClassNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.DefineOrGetModuleNode;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class DefineOrGetClassNode
extends DefineOrGetModuleNode {
    @Node.Child
    private RubyNode superClass;
    @Node.Child
    private CallDispatchHeadNode inheritedNode;

    public DefineOrGetClassNode(RubyContext context, SourceSection sourceSection, String name, RubyNode lexicalParent, RubyNode superClass) {
        super(context, sourceSection, name, lexicalParent);
        this.superClass = superClass;
    }

    private void callInherited(VirtualFrame frame, DynamicObject superClass, DynamicObject subClass) {
        assert (RubyGuards.isRubyClass(superClass));
        assert (RubyGuards.isRubyClass(subClass));
        if (this.inheritedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.inheritedNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
        }
        this.inheritedNode.call(frame, superClass, "inherited", null, subClass);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject definingClass;
        CompilerDirectives.transferToInterpreter();
        RubyContext context = this.getContext();
        DynamicObject lexicalParent = this.getLexicalParentModule(frame);
        RubyConstant constant = this.lookupForExistingModule(lexicalParent);
        DynamicObject superClassObject = this.getRubySuperClass(frame, context);
        if (constant == null) {
            definingClass = ClassNodes.createRubyClass(context, lexicalParent, superClassObject, this.name);
            this.callInherited(frame, superClassObject, definingClass);
        } else if (RubyGuards.isRubyClass(constant.getValue())) {
            definingClass = (DynamicObject)constant.getValue();
            this.checkSuperClassCompatibility(context, superClassObject, definingClass);
        } else {
            throw new RaiseException(context.getCoreLibrary().typeErrorIsNotA(constant.getValue().toString(), "class", this));
        }
        return definingClass;
    }

    private DynamicObject getRubySuperClass(VirtualFrame frame, RubyContext context) {
        Object superClassObj = this.superClass.execute(frame);
        if (RubyGuards.isRubyClass(superClassObj)) {
            if (Layouts.CLASS.getIsSingleton((DynamicObject)superClassObj)) {
                throw new RaiseException(context.getCoreLibrary().typeError("can't make subclass of virtual class", this));
            }
            return (DynamicObject)superClassObj;
        }
        throw new RaiseException(context.getCoreLibrary().typeError("superclass must be a Class", this));
    }

    private boolean isBlankOrRootClass(DynamicObject rubyClass) {
        assert (RubyGuards.isRubyClass(rubyClass));
        return rubyClass == this.getContext().getCoreLibrary().getBasicObjectClass() || rubyClass == this.getContext().getCoreLibrary().getObjectClass();
    }

    private void checkSuperClassCompatibility(RubyContext context, DynamicObject superClassObject, DynamicObject definingClass) {
        assert (RubyGuards.isRubyClass(superClassObject));
        assert (RubyGuards.isRubyClass(definingClass));
        if (!this.isBlankOrRootClass(superClassObject) && !this.isBlankOrRootClass(definingClass) && ClassNodes.getSuperClass(definingClass) != superClassObject) {
            throw new RaiseException(context.getCoreLibrary().typeError("superclass mismatch for class " + Layouts.MODULE.getFields(definingClass).getName(), this));
        }
    }
}

