/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class UndefNode
extends RubyNode {
    @Node.Child
    private RubyNode module;
    final String name;

    public UndefNode(RubyContext context, SourceSection sourceSection, RubyNode module, String name) {
        super(context, sourceSection);
        this.module = module;
        this.name = name;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        DynamicObject moduleObject;
        CompilerDirectives.transferToInterpreter();
        try {
            moduleObject = this.module.executeDynamicObject(frame);
        }
        catch (UnexpectedResultException e) {
            throw new RuntimeException(e);
        }
        Layouts.MODULE.getFields(moduleObject).undefMethod((Node)this, this.name);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.executeVoid(frame);
        return this.nil();
    }
}

