/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.locals;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.locals.ReadLocalVariableNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.translator.WriteNode;

public class WriteLocalVariableNode
extends RubyNode
implements WriteNode {
    @Node.Child
    private RubyNode valueNode;
    @Node.Child
    private WriteFrameSlotNode writeFrameSlotNode;

    public WriteLocalVariableNode(RubyContext context, SourceSection sourceSection, RubyNode valueNode, FrameSlot frameSlot) {
        super(context, sourceSection);
        this.valueNode = valueNode;
        this.writeFrameSlotNode = WriteFrameSlotNodeGen.create(frameSlot);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.writeFrameSlotNode.executeWrite((Frame)frame, this.valueNode.execute(frame));
    }

    @Override
    public RubyNode makeReadNode() {
        return new ReadLocalVariableNode(this.getContext(), this.getSourceSection(), this.writeFrameSlotNode.getFrameSlot());
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"assignment", (Encoding)UTF8Encoding.INSTANCE), 16, null);
    }
}

