/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.ext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jruby.ext.digest.BubbleBabble;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.layouts.ext.DigestLayoutImpl;
import org.jruby.util.ByteList;

@CoreClass(name="Truffle::Digest")
public abstract class DigestNodes {
    private static DynamicObject createDigest(RubyContext context, Algorithm algorithm) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm.getName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        DynamicObject rubyClass = context.getCoreLibrary().getDigestClass();
        return DigestLayoutImpl.INSTANCE.createDigest(Layouts.CLASS.getInstanceFactory(rubyClass), digest);
    }

    @CoreMethod(names={"bubblebabble"}, onSingleton=true, required=1)
    public static abstract class BubbleBabbleNode
    extends CoreMethodArrayArgumentsNode {
        public BubbleBabbleNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public DynamicObject bubblebabble(DynamicObject message) {
            ByteList byteList = Layouts.STRING.getByteList(message);
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), BubbleBabble.bubblebabble((byte[])byteList.unsafeBytes(), (int)byteList.begin(), (int)byteList.length()), 0, null);
        }
    }

    @CoreMethod(names={"digest_length"}, onSingleton=true, required=1)
    public static abstract class DigestLengthNode
    extends CoreMethodArrayArgumentsNode {
        public DigestLengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int digestLength(DynamicObject digestObject) {
            return DigestLayoutImpl.INSTANCE.getDigest(digestObject).getDigestLength();
        }
    }

    @CoreMethod(names={"digest"}, onSingleton=true, required=1)
    public static abstract class DigestNode
    extends CoreMethodArrayArgumentsNode {
        public DigestNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject digest(DynamicObject digestObject) {
            MessageDigest clonedDigest;
            MessageDigest digest = DigestLayoutImpl.INSTANCE.getDigest(digestObject);
            try {
                clonedDigest = (MessageDigest)digest.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(clonedDigest.digest()), 0, null);
        }
    }

    @CoreMethod(names={"reset"}, onSingleton=true, required=1)
    public static abstract class ResetNode
    extends CoreMethodArrayArgumentsNode {
        public ResetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject reset(DynamicObject digestObject) {
            DigestLayoutImpl.INSTANCE.getDigest(digestObject).reset();
            return digestObject;
        }
    }

    @CoreMethod(names={"update"}, onSingleton=true, required=2)
    public static abstract class UpdateNode
    extends CoreMethodArrayArgumentsNode {
        public UpdateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public DynamicObject update(DynamicObject digestObject, DynamicObject message) {
            ByteList bytes = Layouts.STRING.getByteList(message);
            DigestLayoutImpl.INSTANCE.getDigest(digestObject).update(bytes.getUnsafeBytes(), bytes.begin(), bytes.length());
            return digestObject;
        }
    }

    @CoreMethod(names={"sha512"}, onSingleton=true)
    public static abstract class SHA512Node
    extends CoreMethodArrayArgumentsNode {
        public SHA512Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject sha512() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.SHA512);
        }
    }

    @CoreMethod(names={"sha384"}, onSingleton=true)
    public static abstract class SHA384Node
    extends CoreMethodArrayArgumentsNode {
        public SHA384Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject sha384() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.SHA384);
        }
    }

    @CoreMethod(names={"sha256"}, onSingleton=true)
    public static abstract class SHA256Node
    extends CoreMethodArrayArgumentsNode {
        public SHA256Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject sha256() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.SHA256);
        }
    }

    @CoreMethod(names={"sha1"}, onSingleton=true)
    public static abstract class SHA1Node
    extends CoreMethodArrayArgumentsNode {
        public SHA1Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject sha1() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.SHA1);
        }
    }

    @CoreMethod(names={"md5"}, onSingleton=true)
    public static abstract class MD5Node
    extends CoreMethodArrayArgumentsNode {
        public MD5Node(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject md5() {
            return DigestNodes.createDigest(this.getContext(), Algorithm.MD5);
        }
    }

    private static enum Algorithm {
        MD5("MD5"),
        SHA1("SHA1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private final String name;

        private Algorithm(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

