/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.interop.messages.Argument;
import com.oracle.truffle.interop.messages.Execute;
import com.oracle.truffle.interop.messages.Read;
import com.oracle.truffle.interop.messages.Receiver;
import com.oracle.truffle.interop.node.ForeignObjectAccessNode;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;

public final class CachedForeignGlobalDispatchNode
extends CachedDispatchNode {
    private final Object cachedName;
    private final TruffleObject language;
    private final int numberOfArguments;
    @Node.Child
    private ForeignObjectAccessNode access;

    public CachedForeignGlobalDispatchNode(RubyContext context, DispatchNode next, Object cachedName, TruffleObject language, int numberOfArguments) {
        super(context, cachedName, next, false, DispatchAction.CALL_METHOD);
        this.cachedName = cachedName;
        this.language = language;
        this.numberOfArguments = numberOfArguments;
        this.access = this.create();
    }

    private ForeignObjectAccessNode create() {
        return ForeignObjectAccessNode.getAccess((Message)Execute.create((Message)Read.create((Receiver)Receiver.create(), (Argument)Argument.create()), (int)(this.numberOfArguments + 1)));
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (receiverObject instanceof DynamicObject) {
            Object[] arguments = (Object[])argumentsObjects;
            if (arguments.length == this.numberOfArguments) {
                Object[] args = new Object[arguments.length + 2];
                ArrayUtils.arraycopy(arguments, 0, args, 2, arguments.length);
                args[0] = this.cachedName;
                args[1] = this.language;
                return this.access.executeForeign(frame, this.language, args);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Varargs are not supported");
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException("Should not happen");
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return true;
    }
}

