/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class TraceNode
extends RubyNode {
    private final RubyContext context;
    @CompilerDirectives.CompilationFinal
    private Assumption traceAssumption;
    @CompilerDirectives.CompilationFinal
    private DynamicObject traceFunc;
    @Node.Child
    private DirectCallNode callNode;
    private final DynamicObject event;
    private final DynamicObject file;
    private final int line;

    public TraceNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.context = context;
        this.traceAssumption = context.getTraceManager().getTraceAssumption();
        this.traceFunc = null;
        this.callNode = null;
        this.event = Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"line", (Encoding)UTF8Encoding.INSTANCE), 16, null);
        this.file = Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)sourceSection.getSource().getName(), (Encoding)UTF8Encoding.INSTANCE), 0, null);
        this.line = sourceSection.getStartLine();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.trace(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(VirtualFrame frame) {
        try {
            this.traceAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            this.traceAssumption = this.context.getTraceManager().getTraceAssumption();
            this.traceFunc = this.context.getTraceManager().getTraceFunc();
            this.callNode = this.traceFunc != null ? (DirectCallNode)this.insert((Node)Truffle.getRuntime().createDirectCallNode(Layouts.PROC.getCallTargetForType(this.traceFunc))) : null;
        }
        if (this.traceFunc != null && !this.context.getTraceManager().isInTraceFunc()) {
            this.context.getTraceManager().setInTraceFunc(true);
            Object[] args = new Object[]{this.event, this.file, this.line, this.context.getCoreLibrary().getNilObject(), Layouts.BINDING.createBinding(this.getContext().getCoreLibrary().getBindingFactory(), RubyArguments.getSelf(frame.getArguments()), frame.materialize()), this.context.getCoreLibrary().getNilObject()};
            try {
                this.callNode.call(frame, RubyArguments.pack(Layouts.PROC.getMethod(this.traceFunc), Layouts.PROC.getDeclarationFrame(this.traceFunc), Layouts.PROC.getSelf(this.traceFunc), Layouts.PROC.getBlock(this.traceFunc), args));
            }
            finally {
                this.context.getTraceManager().setInTraceFunc(false);
            }
        }
    }
}

