/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayDupNode;
import org.jruby.truffle.nodes.core.array.ArrayDupNodeGen;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child")
public abstract class SplatCastNode
extends RubyNode {
    private final NilBehavior nilBehavior;
    private final boolean useToAry;
    @Node.Child
    private ArrayDupNode dup;
    @Node.Child
    private CallDispatchHeadNode respondToToA;
    @Node.Child
    private BooleanCastNode respondToCast;
    @Node.Child
    private CallDispatchHeadNode toA;

    public SplatCastNode(RubyContext context, SourceSection sourceSection, NilBehavior nilBehavior, boolean useToAry) {
        super(context, sourceSection);
        this.nilBehavior = nilBehavior;
        this.dup = ArrayDupNodeGen.create(context, sourceSection, null);
        this.respondToToA = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.respondToCast = BooleanCastNodeGen.create(context, sourceSection, null);
        this.toA = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.useToAry = useToAry;
    }

    protected abstract RubyNode getChild();

    @Specialization(guards={"isNil(nil)"})
    public DynamicObject splat(Object nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
            }
            case ARRAY_WITH_NIL: {
                return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{this.nil()}, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Specialization(guards={"isRubyArray(array)"})
    public DynamicObject splat(VirtualFrame frame, DynamicObject array) {
        return this.dup.executeDup(frame, array);
    }

    @Specialization(guards={"!isNil(object)", "!isRubyArray(object)"})
    public DynamicObject splat(VirtualFrame frame, Object object) {
        String method = this.useToAry ? "to_ary" : "to_a";
        Object respondToResult = this.respondToToA.call(frame, object, "respond_to?", null, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)method, (Encoding)UTF8Encoding.INSTANCE), 0, null), true);
        if (respondToResult != DispatchNode.MISSING && this.respondToCast.executeBoolean(frame, respondToResult)) {
            Object array = this.toA.call(frame, object, method, null, new Object[0]);
            if (RubyGuards.isRubyArray(array)) {
                return (DynamicObject)array;
            }
            if (array == this.nil() || array == DispatchNode.MISSING) {
                CompilerDirectives.transferToInterpreter();
                return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{object}, 1);
            }
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertTo(object, this.getContext().getCoreLibrary().getArrayClass(), method, array, this));
        }
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{object}, 1);
    }

    public static enum NilBehavior {
        EMPTY_ARRAY,
        ARRAY_WITH_NIL,
        NIL;

    }
}

