/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.visitor.AbstractNodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InvalidSourcePosition;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.cli.Options;

public abstract class Translator
extends AbstractNodeVisitor<RubyNode> {
    protected static final boolean YIELDS = (Boolean)Options.TRUFFLE_YIELDS.load();
    public static final Set<String> PRINT_AST_METHOD_NAMES = new HashSet<String>(Arrays.asList(((String)Options.TRUFFLE_TRANSLATOR_PRINT_AST.load()).split(",")));
    public static final Set<String> PRINT_FULL_AST_METHOD_NAMES = new HashSet<String>(Arrays.asList(((String)Options.TRUFFLE_TRANSLATOR_PRINT_FULL_AST.load()).split(",")));
    public static final Set<String> PRINT_PARSE_TREE_METHOD_NAMES = new HashSet<String>(Arrays.asList(((String)Options.TRUFFLE_TRANSLATOR_PRINT_PARSE_TREE.load()).split(",")));
    public static final Set<String> ALWAYS_DEFINED_GLOBALS = new HashSet<String>(Arrays.asList("$~"));
    public static final Set<String> FRAME_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$_", "$+", "$&", "$`", "$'"));
    protected final Node currentNode;
    protected final RubyContext context;
    protected final Source source;
    protected Deque<SourceSection> parentSourceSection = new ArrayDeque<SourceSection>();

    public Translator(Node currentNode, RubyContext context, Source source) {
        this.currentNode = currentNode;
        this.context = context;
        this.source = source;
    }

    protected SourceSection translate(ISourcePosition sourcePosition) {
        return this.translate(this.source, sourcePosition, this.getIdentifier());
    }

    protected SourceSection translate(ISourcePosition sourcePosition, String identifier) {
        return this.translate(this.source, sourcePosition, identifier);
    }

    private SourceSection translate(Source source, ISourcePosition sourcePosition, String identifier) {
        if (sourcePosition == InvalidSourcePosition.INSTANCE) {
            if (this.parentSourceSection.peek() == null) {
                throw new UnsupportedOperationException("Truffle doesn't want invalid positions - find a way to give me a real position!");
            }
            return this.parentSourceSection.peek();
        }
        return source.createSection(identifier, sourcePosition.getLine() + 1);
    }

    protected abstract String getIdentifier();
}

