/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.locals.ReadLocalVariableNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.Translator;

public class ReloadArgumentsTranslator
extends Translator {
    private final BodyTranslator methodBodyTranslator;
    private boolean isSplatted = false;
    private int originalArgumentIndex = 0;

    public ReloadArgumentsTranslator(Node currentNode, RubyContext context, Source source, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.methodBodyTranslator = methodBodyTranslator;
    }

    public RubyNode visitArgsNode(ArgsNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        if (node.getPreCount() > 0 || node.getOptArgs() != null) {
            if (node.getPre() != null) {
                for (org.jruby.ast.Node arg : node.getPre().children()) {
                    sequence.add((RubyNode)((Object)arg.accept((NodeVisitor)this)));
                    ++this.originalArgumentIndex;
                }
            }
            if (node.getOptArgs() != null) {
                for (org.jruby.ast.Node arg : node.getOptArgs().children()) {
                    sequence.add((RubyNode)((Object)arg.accept((NodeVisitor)this)));
                }
            }
            if (node.hasRestArg()) {
                // empty if block
            }
        } else if (node.hasRestArg()) {
            sequence.add(this.visitArgumentNode(node.getRestArgNode()));
            this.isSplatted = true;
        }
        return SequenceNode.sequenceNoFlatten(this.context, sourceSection, sequence);
    }

    public RubyNode visitArgumentNode(ArgumentNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return new ReadLocalVariableNode(this.context, sourceSection, slot);
    }

    public RubyNode visitOptArgNode(OptArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return new ReadLocalVariableNode(this.context, sourceSection, slot);
    }

    public RubyNode visitMultipleAsgnNode(MultipleAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new ReadPreArgumentNode(this.context, sourceSection, this.originalArgumentIndex, MissingArgumentBehaviour.NIL);
    }

    protected RubyNode defaultVisit(org.jruby.ast.Node node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
    }

    @Override
    protected String getIdentifier() {
        return this.methodBodyTranslator.getIdentifier();
    }

    public boolean isSplatted() {
        return this.isSplatted;
    }
}

