/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.RubyThread;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

public class ThreadManager {
    private final RubyContext context;
    private final ReentrantLock globalLock = new ReentrantLock();
    private final RubyThread rootThread;
    private RubyThread currentThread;
    private final Set<RubyThread> runningRubyThreads = Collections.newSetFromMap(new ConcurrentHashMap());

    public ThreadManager(RubyContext context) {
        this.context = context;
        this.rootThread = new RubyThread(context.getCoreLibrary().getThreadClass(), this);
        this.rootThread.setName("main");
    }

    public void initialize() {
        this.registerThread(this.rootThread);
        this.rootThread.start();
        this.rootThread.getRootFiber().start();
    }

    public RubyThread getRootThread() {
        return this.rootThread;
    }

    @CompilerDirectives.TruffleBoundary
    public void enterGlobalLock(RubyThread thread) {
        this.globalLock.lock();
        this.currentThread = thread;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyThread leaveGlobalLock() {
        if (!this.globalLock.isHeldByCurrentThread()) {
            throw new RuntimeException("You don't own this lock!");
        }
        RubyThread result = this.currentThread;
        this.globalLock.unlock();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public <T> T runUntilResult(BlockingActionWithoutGlobalLock<T> action) {
        T result = null;
        do {
            RubyThread runningThread = this.leaveGlobalLock();
            runningThread.setStatus(RubyThread.Status.SLEEP);
            try {
                try {
                    result = action.block();
                }
                finally {
                    runningThread.setStatus(RubyThread.Status.RUN);
                    this.enterGlobalLock(runningThread);
                }
            }
            catch (InterruptedException e) {
                this.context.getSafepointManager().pollFromBlockingCall(null);
            }
        } while (result == null);
        return result;
    }

    public RubyThread getCurrentThread() {
        assert (this.globalLock.isHeldByCurrentThread()) : "getCurrentThread() is only correct if holding the global lock";
        return this.currentThread;
    }

    public synchronized void registerThread(RubyThread thread) {
        this.runningRubyThreads.add(thread);
    }

    public synchronized void unregisterThread(RubyThread thread) {
        this.runningRubyThreads.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.killOtherThreads();
        }
        finally {
            this.rootThread.getFiberManager().shutdown();
            this.rootThread.getRootFiber().cleanup();
            this.rootThread.cleanup();
        }
    }

    private void killOtherThreads() {
        block2: while (true) {
            try {
                this.context.getSafepointManager().pauseAllThreadsAndExecute(null, false, new SafepointAction(){

                    @Override
                    public synchronized void run(RubyThread thread, Node currentNode) {
                        if (thread != ThreadManager.this.rootThread && Thread.currentThread() == thread.getRootFiberJavaThread()) {
                            thread.shutdown();
                        }
                    }
                });
            }
            catch (RaiseException e) {
                RubyException rubyException = e.getRubyException();
                String[] arr$ = Backtrace.DISPLAY_FORMATTER.format(e.getRubyException().getContext(), rubyException, rubyException.getBacktrace());
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block2;
                    String line = arr$[i$];
                    System.err.println(line);
                    ++i$;
                }
            }
            break;
        }
    }

    public static interface BlockingActionWithoutGlobalLock<T> {
        public static final boolean SUCCESS = true;

        public T block() throws InterruptedException;
    }
}

