/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.core.RubyException;

public class MRIBacktraceFormatter
implements BacktraceFormatter {
    @Override
    public String[] format(RubyContext context, RubyException exception, Backtrace backtrace) {
        try {
            List<Activation> activations = backtrace.getActivations();
            ArrayList<String> lines = new ArrayList<String>();
            if (activations.isEmpty()) {
                if (exception != null) {
                    lines.add(String.format("%s (%s)", exception.getMessage(), exception.getLogicalClass().getName()));
                }
            } else {
                lines.add(MRIBacktraceFormatter.formatInLine(context, activations, exception));
                for (int n = 1; n < activations.size(); ++n) {
                    lines.add(MRIBacktraceFormatter.formatFromLine(activations, n));
                }
            }
            return lines.toArray(new String[lines.size()]);
        }
        catch (Exception e) {
            throw new TruffleFatalException("Exception while trying to format a Ruby call stack", e);
        }
    }

    private static String formatInLine(RubyContext context, List<Activation> activations, RubyException exception) {
        String reportedName;
        SourceSection reportedSourceSection;
        StringBuilder builder = new StringBuilder();
        Activation activation = activations.get(0);
        SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
        if (sourceSection instanceof CoreSourceSection) {
            reportedSourceSection = MRIBacktraceFormatter.nextUserSourceSection(activations, 1);
            reportedName = RubyArguments.getMethod(activation.getMaterializedFrame().getArguments()).getName();
        } else {
            reportedSourceSection = sourceSection;
            reportedName = reportedSourceSection.getIdentifier();
        }
        if (reportedSourceSection == null || reportedSourceSection.getSource() == null) {
            builder.append("???");
        } else {
            builder.append(reportedSourceSection.getSource().getName());
            builder.append(":");
            builder.append(reportedSourceSection.getStartLine());
            builder.append(":in `");
            builder.append(reportedName);
            builder.append("'");
        }
        if (exception != null) {
            String message;
            try {
                Object messageObject = DebugOperations.send(context, exception, "message", null, new Object[0]);
                message = RubyGuards.isRubyString(messageObject) ? messageObject.toString() : exception.getMessage().toString();
            }
            catch (RaiseException e) {
                message = exception.getMessage().toString();
            }
            builder.append(": ");
            builder.append(message);
            builder.append(" (");
            builder.append(exception.getLogicalClass().getName());
            builder.append(")");
        }
        return builder.toString();
    }

    private static String formatFromLine(List<Activation> activations, int n) {
        return "\tfrom " + MRIBacktraceFormatter.formatCallerLine(activations, n);
    }

    public static String formatCallerLine(List<Activation> activations, int n) {
        String reportedName;
        SourceSection reportedSourceSection;
        Activation activation = activations.get(n);
        SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
        if (sourceSection instanceof CoreSourceSection) {
            reportedSourceSection = activations.get(n + 1).getCallNode().getEncapsulatingSourceSection();
            reportedName = RubyArguments.getMethod(activation.getMaterializedFrame().getArguments()).getName();
        } else {
            reportedSourceSection = sourceSection;
            reportedName = sourceSection.getIdentifier();
        }
        StringBuilder builder = new StringBuilder();
        if (reportedSourceSection instanceof NullSourceSection) {
            builder.append("???");
        } else {
            builder.append(reportedSourceSection.getSource().getName());
            builder.append(":");
            builder.append(reportedSourceSection.getStartLine());
        }
        builder.append(":in `");
        builder.append(reportedName);
        builder.append("'");
        return builder.toString();
    }

    private static SourceSection nextUserSourceSection(List<Activation> activations, int n) {
        while (n < activations.size()) {
            SourceSection sourceSection = activations.get(n).getCallNode().getEncapsulatingSourceSection();
            if (!(sourceSection instanceof CoreSourceSection)) {
                return sourceSection;
            }
            ++n;
        }
        return null;
    }
}

