/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import jnr.constants.platform.Errno;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodes;
import org.jruby.truffle.nodes.rubinius.IOPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.util.ByteList;

public abstract class IOBufferPrimitiveNodes {
    private static final int IOBUFFER_SIZE = 32768;
    private static final int STACK_BUF_SZ = 8192;
    private static final String WRITE_SYNCED_IDENTIFIER = "@write_synced";
    private static final Property WRITE_SYNCED_PROPERTY;
    private static final String STORAGE_IDENTIFIER = "@storage";
    private static final Property STORAGE_PROPERTY;
    private static final String USED_IDENTIFIER = "@used";
    private static final Property USED_PROPERTY;
    private static final String START_IDENTIFIER = "@start";
    private static final Property START_PROPERTY;
    private static final String TOTAL_IDENTIFIER = "@total";
    private static final Property TOTAL_PROPERTY;
    private static final DynamicObjectFactory IO_BUFFER_FACTORY;

    public static void setWriteSynced(RubyBasicObject io, boolean writeSynced) {
        assert (io.getDynamicObject().getShape().hasProperty((Object)WRITE_SYNCED_IDENTIFIER));
        try {
            WRITE_SYNCED_PROPERTY.set(io.getDynamicObject(), (Object)writeSynced, io.getDynamicObject().getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static RubyBasicObject getStorage(RubyBasicObject io) {
        assert (io.getDynamicObject().getShape().hasProperty((Object)STORAGE_IDENTIFIER));
        return (RubyBasicObject)STORAGE_PROPERTY.get(io.getDynamicObject(), true);
    }

    private static int getUsed(RubyBasicObject io) {
        assert (io.getDynamicObject().getShape().hasProperty((Object)USED_IDENTIFIER));
        return (Integer)USED_PROPERTY.get(io.getDynamicObject(), true);
    }

    public static void setUsed(RubyBasicObject io, int used) {
        assert (io.getDynamicObject().getShape().hasProperty((Object)USED_IDENTIFIER));
        try {
            USED_PROPERTY.set(io.getDynamicObject(), (Object)used, io.getDynamicObject().getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static int getTotal(RubyBasicObject io) {
        assert (io.getDynamicObject().getShape().hasProperty((Object)TOTAL_IDENTIFIER));
        return (Integer)TOTAL_PROPERTY.get(io.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        WRITE_SYNCED_PROPERTY = Property.create((Object)WRITE_SYNCED_IDENTIFIER, (Location)allocator.locationForType(Boolean.TYPE), (int)0);
        STORAGE_PROPERTY = Property.create((Object)STORAGE_IDENTIFIER, (Location)allocator.locationForType(RubyBasicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
        USED_PROPERTY = Property.create((Object)USED_IDENTIFIER, (Location)allocator.locationForType(Integer.TYPE), (int)0);
        START_PROPERTY = Property.create((Object)START_IDENTIFIER, (Location)allocator.locationForType(Integer.TYPE), (int)0);
        TOTAL_PROPERTY = Property.create((Object)TOTAL_IDENTIFIER, (Location)allocator.locationForType(Integer.TYPE), (int)0);
        IO_BUFFER_FACTORY = RubyBasicObject.EMPTY_SHAPE.addProperty(WRITE_SYNCED_PROPERTY).addProperty(STORAGE_PROPERTY).addProperty(USED_PROPERTY).addProperty(START_PROPERTY).addProperty(TOTAL_PROPERTY).createFactory();
    }

    @RubiniusPrimitive(name="iobuffer_fill")
    public static abstract class IOBufferFillPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferFillPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int fill(VirtualFrame frame, RubyBasicObject ioBuffer, RubyBasicObject io) {
            int bytesRead;
            int fd = IOPrimitiveNodes.getDescriptor(io);
            byte[] readBuffer = new byte[8192];
            int count = 8192;
            if (this.left(frame, ioBuffer) < count) {
                count = this.left(frame, ioBuffer);
            }
            while ((bytesRead = this.posix().read(fd, readBuffer, count)) == -1) {
                int errno = this.posix().errno();
                if (errno == Errno.ECONNRESET.intValue() || errno == Errno.ETIMEDOUT.intValue()) {
                    bytesRead = 0;
                    break;
                }
                if (errno == Errno.EAGAIN.intValue() || errno == Errno.EINTR.intValue()) {
                    this.getContext().getSafepointManager().poll(this);
                    continue;
                }
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(new RubyException(this.getContext().getCoreLibrary().getErrnoClass(Errno.valueOf((long)errno))));
            }
            if (bytesRead > 0) {
                if (bytesRead > this.left(frame, ioBuffer)) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().internalError("IO buffer overrun", this));
                }
                int used = IOBufferPrimitiveNodes.getUsed(ioBuffer);
                ByteList storage = ByteArrayNodes.getBytes(IOBufferPrimitiveNodes.getStorage(ioBuffer));
                System.arraycopy(readBuffer, 0, storage.getUnsafeBytes(), storage.getBegin() + used, bytesRead);
                storage.setRealSize(used + bytesRead);
                IOBufferPrimitiveNodes.setUsed(ioBuffer, used + bytesRead);
            }
            return bytesRead;
        }

        private int left(VirtualFrame frame, RubyBasicObject ioBuffer) {
            int total = IOBufferPrimitiveNodes.getTotal(ioBuffer);
            int used = IOBufferPrimitiveNodes.getUsed(ioBuffer);
            return total - used;
        }
    }

    @RubiniusPrimitive(name="iobuffer_unshift", lowerFixnumParameters={1})
    public static abstract class IOBufferUnshiftPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferUnshiftPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public int unshift(VirtualFrame frame, RubyBasicObject ioBuffer, RubyBasicObject string, int startPosition) {
            IOBufferPrimitiveNodes.setWriteSynced(ioBuffer, false);
            ByteList byteList = StringNodes.getByteList(string);
            int stringSize = byteList.realSize() - startPosition;
            int usedSpace = IOBufferPrimitiveNodes.getUsed(ioBuffer);
            int availableSpace = 32768 - usedSpace;
            if (stringSize > availableSpace) {
                stringSize = availableSpace;
            }
            ByteList storage = ByteArrayNodes.getBytes(IOBufferPrimitiveNodes.getStorage(ioBuffer));
            System.arraycopy(byteList.unsafeBytes(), byteList.begin() + startPosition, storage.getUnsafeBytes(), storage.begin() + usedSpace, stringSize);
            IOBufferPrimitiveNodes.setUsed(ioBuffer, usedSpace + stringSize);
            return stringSize;
        }
    }

    @RubiniusPrimitive(name="iobuffer_allocate")
    public static abstract class IOBufferAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject allocate(VirtualFrame frame, RubyClass classToAllocate) {
            return new RubyBasicObject(classToAllocate, IO_BUFFER_FACTORY.newInstance(new Object[]{true, ByteArrayNodes.createByteArray(this.getContext().getCoreLibrary().getByteArrayClass(), new ByteList(32768)), 0, 0, 32768}));
        }
    }
}

