/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.rubinius.FixnumPrimitiveNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=FixnumPrimitiveNodes.class)
public final class FixnumPrimitiveNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(FixnumCoercePrimitiveNodeFactory.getInstance(), FixnumPowPrimitiveNodeFactory.getInstance());
    }

    @GeneratedBy(value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
    public static final class FixnumPowPrimitiveNodeFactory
    extends NodeFactoryBase<FixnumPrimitiveNodes.FixnumPowPrimitiveNode> {
        private static FixnumPowPrimitiveNodeFactory fixnumPowPrimitiveNodeFactoryInstance;

        private FixnumPowPrimitiveNodeFactory() {
            super(FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumPrimitiveNodes.FixnumPowPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FixnumPowPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumPrimitiveNodes.FixnumPowPrimitiveNode> getInstance() {
            if (fixnumPowPrimitiveNodeFactoryInstance == null) {
                fixnumPowPrimitiveNodeFactoryInstance = new FixnumPowPrimitiveNodeFactory();
            }
            return fixnumPowPrimitiveNodeFactoryInstance;
        }

        public static FixnumPrimitiveNodes.FixnumPowPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new FixnumPowPrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
        public static final class FixnumPowPrimitiveNodeGen
        extends FixnumPrimitiveNodes.FixnumPowPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FixnumPowPrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="pow(long, RubyBasicObject)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class Pow7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Pow7Node_(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 14);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Pow7Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.pow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.pow(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    return new Pow7Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="pow(int, RubyBasicObject)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class Pow6Node_
            extends BaseNode_ {
                Pow6Node_(FixnumPowPrimitiveNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.pow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.pow(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root) {
                    return new Pow6Node_(root);
                }
            }

            @GeneratedBy(methodName="powBignum(long, RubyBasicObject)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class PowBignum1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                PowBignum1Node_(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 12);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((PowBignum1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.powBignum(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.powBignum(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    return new PowBignum1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="pow(long, double)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class Pow5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Pow5Node_(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 11);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Pow5Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.pow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.pow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    return new Pow5Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="pow(long, long)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class Pow4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Pow4Node_(FixnumPowPrimitiveNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 10);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Pow4Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Pow4Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.pow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.pow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Pow4Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="pow(long, int)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class Pow3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Pow3Node_(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 9);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Pow3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.pow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.pow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    return new Pow3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="powTwo(long, long)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class PowTwo3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                PowTwo3Node_(FixnumPowPrimitiveNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((PowTwo3Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((PowTwo3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return FixnumPowPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return FixnumPowPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoLong(arguments0Value_, arguments1Value_)) {
                        return this.root.powTwo(arguments0Value_, arguments1Value_);
                    }
                    return FixnumPowPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    long arguments1Value_;
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoLong(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType), arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType))) {
                        return this.root.powTwo(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new PowTwo3Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="powTwo(long, int)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class PowTwo2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                PowTwo2Node_(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((PowTwo2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return FixnumPowPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return FixnumPowPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoLong(arguments0Value_, arguments1Value_)) {
                        return this.root.powTwo(arguments0Value_, arguments1Value_);
                    }
                    return FixnumPowPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer && FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoLong(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType), arguments1Value_ = ((Integer)arguments1Value).intValue())) {
                        return this.root.powTwo(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments0Value) {
                    return new PowTwo2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="powBignum(int, RubyBasicObject)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class PowBignum0Node_
            extends BaseNode_ {
                PowBignum0Node_(FixnumPowPrimitiveNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.powBignum(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.powBignum(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root) {
                    return new PowBignum0Node_(root);
                }
            }

            @GeneratedBy(methodName="pow(int, double)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class Pow2Node_
            extends BaseNode_ {
                Pow2Node_(FixnumPowPrimitiveNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.pow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Double) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.pow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root) {
                    return new Pow2Node_(root);
                }
            }

            @GeneratedBy(methodName="pow(int, long)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class Pow1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Pow1Node_(FixnumPowPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Pow1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.pow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.pow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments1Value) {
                    return new Pow1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="pow(int, int)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class Pow0Node_
            extends BaseNode_ {
                Pow0Node_(FixnumPowPrimitiveNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.pow(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.pow(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root) {
                    return new Pow0Node_(root);
                }
            }

            @GeneratedBy(methodName="powTwo(int, long)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class PowTwo1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                PowTwo1Node_(FixnumPowPrimitiveNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((PowTwo1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return FixnumPowPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return FixnumPowPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoInt(arguments0Value_, arguments1Value_)) {
                        return this.root.powTwo(arguments0Value_, arguments1Value_);
                    }
                    return FixnumPowPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    long arguments1Value_;
                    int arguments0Value_;
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoInt(arguments0Value_ = ((Integer)arguments0Value).intValue(), arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType))) {
                        return this.root.powTwo(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root, Object arguments1Value) {
                    return new PowTwo1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="powTwo(int, int)", value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class PowTwo0Node_
            extends BaseNode_ {
                PowTwo0Node_(FixnumPowPrimitiveNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return FixnumPowPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return FixnumPowPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoInt(arguments0Value_, arguments1Value_)) {
                        return this.root.powTwo(arguments0Value_, arguments1Value_);
                    }
                    return FixnumPowPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    int arguments0Value_;
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer && FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoInt(arguments0Value_ = ((Integer)arguments0Value).intValue(), arguments1Value_ = ((Integer)arguments1Value).intValue())) {
                        return this.root.powTwo(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root) {
                    return new PowTwo0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FixnumPowPrimitiveNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FixnumPowPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumPowPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumPrimitiveNodes.FixnumPowPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final FixnumPowPrimitiveNodeGen root;

                BaseNode_(FixnumPowPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FixnumPowPrimitiveNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FixnumPowPrimitiveNodeGen.expectLong(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments1Value_;
                        int arguments0Value_ = (Integer)arguments0Value;
                        if (arguments1Value instanceof Integer && FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoInt(arguments0Value_, arguments1Value_ = ((Integer)arguments1Value).intValue())) {
                            return PowTwo0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoInt(arguments0Value_, arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value))) {
                            return PowTwo1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Integer) {
                            return Pow0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Pow1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Pow2Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return PowBignum0Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        int arguments1Value_;
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (arguments1Value instanceof Integer && FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoLong(arguments0Value_, arguments1Value_ = ((Integer)arguments1Value).intValue())) {
                            return PowTwo2Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && FixnumPrimitiveNodes.FixnumPowPrimitiveNode.canShiftIntoLong(arguments0Value_, arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value))) {
                            return PowTwo3Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Integer) {
                            return Pow3Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Pow4Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Pow5Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return PowBignum1Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (arguments0Value instanceof Integer && !RubyGuards.isRubyBignum(arguments1Value_)) {
                            return Pow6Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments0Value) && !RubyGuards.isRubyBignum(arguments1Value_)) {
                            return Pow7Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class)
    public static final class FixnumCoercePrimitiveNodeFactory
    extends NodeFactoryBase<FixnumPrimitiveNodes.FixnumCoercePrimitiveNode> {
        private static FixnumCoercePrimitiveNodeFactory fixnumCoercePrimitiveNodeFactoryInstance;

        private FixnumCoercePrimitiveNodeFactory() {
            super(FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumPrimitiveNodes.FixnumCoercePrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FixnumCoercePrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FixnumPrimitiveNodes.FixnumCoercePrimitiveNode> getInstance() {
            if (fixnumCoercePrimitiveNodeFactoryInstance == null) {
                fixnumCoercePrimitiveNodeFactoryInstance = new FixnumCoercePrimitiveNodeFactory();
            }
            return fixnumCoercePrimitiveNodeFactoryInstance;
        }

        public static FixnumPrimitiveNodes.FixnumCoercePrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new FixnumCoercePrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class)
        public static final class FixnumCoercePrimitiveNodeGen
        extends FixnumPrimitiveNodes.FixnumCoercePrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FixnumCoercePrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="coerce(int, Object)", value=FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class)
            private static final class Coerce2Node_
            extends BaseNode_ {
                Coerce2Node_(FixnumCoercePrimitiveNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    if (!RubyGuards.isInteger(arguments1Value_)) {
                        return this.root.coerce(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        if (!RubyGuards.isInteger(arguments1Value)) {
                            return this.root.coerce(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumCoercePrimitiveNodeGen root) {
                    return new Coerce2Node_(root);
                }
            }

            @GeneratedBy(methodName="coerce(long, int)", value=FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class)
            private static final class Coerce1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Coerce1Node_(FixnumCoercePrimitiveNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Coerce1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    block6: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                            return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                        }
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.coerce(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.coerce(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumCoercePrimitiveNodeGen root, Object arguments0Value) {
                    return new Coerce1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="coerce(int, int)", value=FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class)
            private static final class Coerce0Node_
            extends BaseNode_ {
                Coerce0Node_(FixnumCoercePrimitiveNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.coerce(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.coerce(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumCoercePrimitiveNodeGen root) {
                    return new Coerce0Node_(root);
                }
            }

            @GeneratedBy(value=FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FixnumCoercePrimitiveNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumCoercePrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FixnumCoercePrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(FixnumCoercePrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=FixnumPrimitiveNodes.FixnumCoercePrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final FixnumCoercePrimitiveNodeGen root;

                BaseNode_(FixnumCoercePrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof Integer) {
                        if (arguments0Value instanceof Integer) {
                            return Coerce0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                            return Coerce1Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (arguments0Value instanceof Integer && !RubyGuards.isInteger(arguments1Value)) {
                        return Coerce2Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }
}

