/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class CachedBooleanDispatchNode
extends CachedDispatchNode {
    private final Assumption falseUnmodifiedAssumption;
    private final InternalMethod falseMethod;
    private final BranchProfile falseProfile = BranchProfile.create();
    @Node.Child
    private DirectCallNode falseCallDirect;
    private final Assumption trueUnmodifiedAssumption;
    private final InternalMethod trueMethod;
    private final BranchProfile trueProfile = BranchProfile.create();
    @Node.Child
    private DirectCallNode trueCallDirect;
    @Node.Child
    private IndirectCallNode indirectCallNode;

    public CachedBooleanDispatchNode(RubyContext context, Object cachedName, DispatchNode next, Assumption falseUnmodifiedAssumption, Object falseValue, InternalMethod falseMethod, Assumption trueUnmodifiedAssumption, Object trueValue, InternalMethod trueMethod, boolean indirect, DispatchAction dispatchAction) {
        super(context, cachedName, next, indirect, dispatchAction);
        this.falseUnmodifiedAssumption = falseUnmodifiedAssumption;
        this.falseMethod = falseMethod;
        if (falseMethod != null && !indirect) {
            this.falseCallDirect = Truffle.getRuntime().createDirectCallNode(falseMethod.getCallTarget());
            if (this.falseCallDirect.isCallTargetCloningAllowed() && falseMethod.getSharedMethodInfo().shouldAlwaysSplit()) {
                this.insert((Node)this.falseCallDirect);
                this.falseCallDirect.cloneCallTarget();
            }
        }
        this.trueUnmodifiedAssumption = trueUnmodifiedAssumption;
        this.trueMethod = trueMethod;
        if (trueMethod != null && !indirect) {
            this.trueCallDirect = Truffle.getRuntime().createDirectCallNode(trueMethod.getCallTarget());
            if (this.trueCallDirect.isCallTargetCloningAllowed() && trueMethod.getSharedMethodInfo().shouldAlwaysSplit()) {
                this.insert((Node)this.trueCallDirect);
                this.trueCallDirect.cloneCallTarget();
            }
        }
        if (indirect) {
            this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
        }
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver instanceof Boolean;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        if (((Boolean)receiverObject).booleanValue()) {
            this.trueProfile.enter();
            try {
                this.trueUnmodifiedAssumption.check();
            }
            catch (InvalidAssumptionException e) {
                return this.resetAndDispatch(frame, receiverObject, methodName, (RubyBasicObject)blockObject, argumentsObjects, "class modified");
            }
            switch (this.getDispatchAction()) {
                case CALL_METHOD: {
                    if (this.isIndirect()) {
                        return this.indirectCallNode.call(frame, this.trueMethod.getCallTarget(), RubyArguments.pack(this.trueMethod, this.trueMethod.getDeclarationFrame(), receiverObject, (RubyBasicObject)blockObject, (Object[])argumentsObjects));
                    }
                    return this.trueCallDirect.call(frame, RubyArguments.pack(this.trueMethod, this.trueMethod.getDeclarationFrame(), receiverObject, (RubyBasicObject)blockObject, (Object[])argumentsObjects));
                }
                case RESPOND_TO_METHOD: {
                    return true;
                }
            }
            throw new UnsupportedOperationException();
        }
        this.falseProfile.enter();
        try {
            this.falseUnmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, (RubyBasicObject)blockObject, argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                if (this.isIndirect()) {
                    return this.indirectCallNode.call(frame, this.falseMethod.getCallTarget(), RubyArguments.pack(this.falseMethod, this.falseMethod.getDeclarationFrame(), receiverObject, (RubyBasicObject)blockObject, (Object[])argumentsObjects));
                }
                return this.falseCallDirect.call(frame, RubyArguments.pack(this.falseMethod, this.falseMethod.getDeclarationFrame(), receiverObject, (RubyBasicObject)blockObject, (Object[])argumentsObjects));
            }
            case RESPOND_TO_METHOD: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }
}

