/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayDupNode
extends RubyNode {
    public ArrayDupNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract RubyBasicObject executeDup(VirtualFrame var1, RubyBasicObject var2);

    @Specialization(guards={"isRubyArray(from)", "isNullArray(from)"})
    public RubyBasicObject dupNull(RubyBasicObject from) {
        return this.createEmptyArray();
    }

    @Specialization(guards={"isRubyArray(from)", "isIntArray(from)"})
    public RubyBasicObject dupIntegerFixnum(RubyBasicObject from) {
        return this.createArray(Arrays.copyOf((int[])ArrayNodes.getStore(from), ArrayNodes.getSize(from)), ArrayNodes.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isLongArray(from)"})
    public RubyBasicObject dupLongFixnum(RubyBasicObject from) {
        return this.createArray(Arrays.copyOf((long[])ArrayNodes.getStore(from), ArrayNodes.getSize(from)), ArrayNodes.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isDoubleArray(from)"})
    public RubyBasicObject dupFloat(RubyBasicObject from) {
        return this.createArray(Arrays.copyOf((double[])ArrayNodes.getStore(from), ArrayNodes.getSize(from)), ArrayNodes.getSize(from));
    }

    @Specialization(guards={"isRubyArray(from)", "isObjectArray(from)"})
    public RubyBasicObject dupObject(RubyBasicObject from) {
        return this.createArray(Arrays.copyOf((Object[])ArrayNodes.getStore(from), ArrayNodes.getSize(from)), ArrayNodes.getSize(from));
    }
}

