/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RegexpSupport;
import org.jruby.util.StringSupport;

@CoreClass(name="Regexp")
public abstract class RegexpNodes {
    public static RubyBasicObject makeString(RubyBasicObject source, int start, int length) {
        assert (RubyGuards.isRubyString(source));
        ByteList bytes = new ByteList(StringNodes.getByteList(source), start, length);
        RubyBasicObject ret = StringNodes.createString(source.getLogicalClass(), bytes);
        StringNodes.setCodeRange(ret, StringNodes.getCodeRange(source));
        return ret;
    }

    public static void setFrame(Frame frame, String name, Object value) {
        assert (value != null);
        while (frame != null) {
            FrameSlot slot = frame.getFrameDescriptor().findFrameSlot((Object)name);
            if (slot != null) {
                frame.setObject(slot, value);
                break;
            }
            frame = RubyArguments.getDeclarationFrame(frame.getArguments());
        }
    }

    public static Regex getRegex(RubyBasicObject regexp) {
        assert (RubyGuards.isRubyRegexp(regexp));
        return ((org.jruby.truffle.runtime.core.RubyRegexp)regexp).regex;
    }

    public static ByteList getSource(RubyBasicObject regexp) {
        assert (RubyGuards.isRubyRegexp(regexp));
        return ((org.jruby.truffle.runtime.core.RubyRegexp)regexp).source;
    }

    public static RegexpOptions getOptions(RubyBasicObject regexp) {
        assert (RubyGuards.isRubyRegexp(regexp));
        return ((org.jruby.truffle.runtime.core.RubyRegexp)regexp).options;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(RubyBasicObject regexp, RubyBasicObject source, boolean operator, boolean setNamedCaptures) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(source));
        return RegexpNodes.matchCommon(regexp, source, operator, setNamedCaptures, 0);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(RubyBasicObject regexp, RubyBasicObject source, boolean operator, boolean setNamedCaptures, int startPos) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(source));
        byte[] stringBytes = StringNodes.getByteList(source).bytes();
        ByteList bl = RegexpNodes.getSource(regexp);
        Encoding enc = RegexpNodes.checkEncoding(regexp, StringNodes.getCodeRangeable(source), true);
        ByteList preprocessed = RegexpSupport.preprocess((Ruby)regexp.getContext().getRuntime(), (ByteList)bl, (Encoding)enc, (Encoding[])new Encoding[]{null}, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
        Regex r = new Regex(preprocessed.getUnsafeBytes(), preprocessed.getBegin(), preprocessed.getBegin() + preprocessed.getRealSize(), RegexpNodes.getOptions(regexp).toJoniOptions(), RegexpNodes.checkEncoding(regexp, StringNodes.getCodeRangeable(source), true));
        Matcher matcher = r.matcher(stringBytes);
        int range = stringBytes.length;
        return RegexpNodes.matchCommon(regexp, source, operator, setNamedCaptures, matcher, startPos, range);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(RubyBasicObject regexp, RubyBasicObject source, boolean operator, boolean setNamedCaptures, Matcher matcher, int startPos, int range) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(source));
        ByteList bytes = StringNodes.getByteList(source);
        RubyContext context = regexp.getContext();
        Frame frame = RubyCallStack.getCallerFrame(regexp.getContext()).getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
        int match = matcher.search(startPos, range, 0);
        RubyBasicObject nil = regexp.getContext().getCoreLibrary().getNilObject();
        if (match == -1) {
            RegexpNodes.setThread(regexp, "$~", nil);
            if (setNamedCaptures && RegexpNodes.getRegex(regexp).numberOfNames() > 0) {
                Iterator i = RegexpNodes.getRegex(regexp).namedBackrefIterator();
                while (i.hasNext()) {
                    NameEntry e = (NameEntry)i.next();
                    String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                    RegexpNodes.setFrame(frame, name, regexp.getContext().getCoreLibrary().getNilObject());
                }
            }
            return regexp.getContext().getCoreLibrary().getNilObject();
        }
        Region region = matcher.getEagerRegion();
        Object[] values = new Object[region.numRegs];
        for (int n = 0; n < region.numRegs; ++n) {
            int start = region.beg[n];
            int end = region.end[n];
            if (operator) {
                RubyBasicObject groupString = start > -1 && end > -1 ? RegexpNodes.makeString(source, start, end - start) : regexp.getContext().getCoreLibrary().getNilObject();
                values[n] = groupString;
                continue;
            }
            values[n] = start == -1 || end == -1 ? regexp.getContext().getCoreLibrary().getNilObject() : RegexpNodes.makeString(source, start, end - start);
        }
        RubyBasicObject pre = RegexpNodes.makeString(source, 0, region.beg[0]);
        RubyBasicObject post = RegexpNodes.makeString(source, region.end[0], bytes.length() - region.end[0]);
        RubyBasicObject global = RegexpNodes.makeString(source, region.beg[0], region.end[0] - region.beg[0]);
        RubyMatchData matchObject = new RubyMatchData(context.getCoreLibrary().getMatchDataClass(), source, regexp, region, values, pre, post, global, matcher.getBegin(), matcher.getEnd());
        if (operator && values.length > 0) {
            int nonNil = values.length - 1;
            while (values[nonNil] == regexp.getContext().getCoreLibrary().getNilObject()) {
                --nonNil;
            }
        }
        RegexpNodes.setThread(regexp, "$~", matchObject);
        if (setNamedCaptures && RegexpNodes.getRegex(regexp).numberOfNames() > 0) {
            Iterator i = RegexpNodes.getRegex(regexp).namedBackrefIterator();
            while (i.hasNext()) {
                RubyBasicObject value;
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                int nth = RegexpNodes.getRegex(regexp).nameToBackrefNumber(e.name, e.nameP, e.nameEnd, region);
                if (nth >= region.numRegs || nth < 0 && (nth += region.numRegs) <= 0) {
                    value = regexp.getContext().getCoreLibrary().getNilObject();
                } else {
                    int start = region.beg[nth];
                    int end = region.end[nth];
                    value = start != -1 ? RegexpNodes.makeString(source, start, end - start) : regexp.getContext().getCoreLibrary().getNilObject();
                }
                RegexpNodes.setFrame(frame, name, value);
            }
        }
        if (operator) {
            return matcher.getBegin();
        }
        return matchObject;
    }

    public static void setThread(RubyBasicObject regexp, String name, Object value) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (value != null);
        RubyBasicObject.setInstanceVariable(regexp.getContext().getThreadManager().getCurrentThread().getThreadLocals(), name, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyBasicObject gsub(RubyBasicObject regexp, RubyBasicObject string, String replacement) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(string));
        RubyContext context = regexp.getContext();
        byte[] stringBytes = StringNodes.getByteList(string).bytes();
        Encoding encoding = StringNodes.getByteList(string).getEncoding();
        Matcher matcher = RegexpNodes.getRegex(regexp).matcher(stringBytes);
        int p = StringNodes.getByteList(string).getBegin();
        int end = 0;
        int range = p + StringNodes.getByteList(string).getRealSize();
        int lastMatchEnd = 0;
        int matchedStringIndex = 0;
        StringBuilder builder = new StringBuilder();
        while (true) {
            Object matchData;
            if ((matchData = RegexpNodes.matchCommon(regexp, string, false, false, matcher, p + end, range)) == context.getCoreLibrary().getNilObject()) break;
            Region region = matcher.getEagerRegion();
            int regionStart = region.beg[matchedStringIndex];
            int regionEnd = region.end[matchedStringIndex];
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, regionStart - lastMatchEnd)));
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(replacement.getBytes(StandardCharsets.UTF_8))));
            lastMatchEnd = regionEnd;
            end = StringSupport.positionEndForScan((ByteList)StringNodes.getByteList(string), (Matcher)matcher, (Encoding)encoding, (int)p, (int)range);
        }
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, range - lastMatchEnd)));
        return StringNodes.createString(context.getCoreLibrary().getStringClass(), builder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    @CompilerDirectives.TruffleBoundary
    public static RubyBasicObject[] split(RubyBasicObject regexp, RubyBasicObject string, boolean useLimit, int limit) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(string));
        RubyContext context = regexp.getContext();
        ByteList bytes = StringNodes.getByteList(string);
        byte[] byteArray = bytes.bytes();
        int begin = bytes.getBegin();
        int len = bytes.getRealSize();
        int range = begin + len;
        Encoding encoding = StringNodes.getByteList(string).getEncoding();
        Matcher matcher = RegexpNodes.getRegex(regexp).matcher(byteArray);
        ArrayList<RubyBasicObject> strings = new ArrayList<RubyBasicObject>();
        int beg = 0;
        int i = 1;
        boolean lastNull = false;
        int start = begin;
        if (useLimit && limit == 1) {
            strings.add(string);
        } else {
            int end;
            while ((end = matcher.search(start, range, 0)) >= 0) {
                block12: {
                    if (start == end + begin && matcher.getBegin() == matcher.getEnd()) {
                        if (len == 0) {
                            strings.add(StringNodes.createString(context.getCoreLibrary().getStringClass(), ""));
                            break;
                        }
                        if (lastNull) {
                            int substringLength = StringSupport.length((Encoding)encoding, (byte[])byteArray, (int)(begin + beg), (int)range);
                            strings.add(StringNodes.createString(context.getCoreLibrary().getStringClass(), bytes.makeShared(beg, substringLength).dup()));
                            beg = start - begin;
                            break block12;
                        } else {
                            start += start == range ? 1 : StringSupport.length((Encoding)encoding, (byte[])byteArray, (int)start, (int)range);
                            lastNull = true;
                            continue;
                        }
                    }
                    strings.add(StringNodes.createString(context.getCoreLibrary().getStringClass(), bytes.makeShared(beg, end - beg).dup()));
                    beg = matcher.getEnd();
                    start = begin + beg;
                }
                lastNull = false;
                if (!useLimit || limit > ++i) continue;
            }
            if (len > 0 && (useLimit || len > beg || limit < 0)) {
                strings.add(StringNodes.createString(context.getCoreLibrary().getStringClass(), bytes.makeShared(beg, len - beg).dup()));
            }
        }
        if (!useLimit && limit == 0) {
            while (!strings.isEmpty() && StringNodes.length((RubyBasicObject)strings.get(strings.size() - 1)) == 0) {
                strings.remove(strings.size() - 1);
            }
        }
        return strings.toArray(new org.jruby.truffle.runtime.core.RubyString[strings.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    public static Regex compile(Node currentNode, RubyContext context, ByteList bytes, RegexpOptions options) {
        try {
            Encoding enc = bytes.getEncoding();
            Encoding[] fixedEnc = new Encoding[]{null};
            ByteList unescaped = RegexpSupport.preprocess((Ruby)context.getRuntime(), (ByteList)bytes, (Encoding)enc, (Encoding[])fixedEnc, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            if (fixedEnc[0] != null) {
                if (fixedEnc[0] != enc && options.isFixed() || fixedEnc[0] != ASCIIEncoding.INSTANCE && options.isEncodingNone()) {
                    RegexpSupport.raiseRegexpError19((Ruby)context.getRuntime(), (ByteList)bytes, (Encoding)enc, (RegexpOptions)options, (String)"incompatible character encoding");
                }
                if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                    options.setFixed(true);
                    enc = fixedEnc[0];
                }
            } else if (!options.isFixed()) {
                enc = USASCIIEncoding.INSTANCE;
            }
            if (fixedEnc[0] != null) {
                options.setFixed(true);
            }
            bytes.setEncoding(enc);
            Regex ret = new Regex(unescaped.getUnsafeBytes(), unescaped.getBegin(), unescaped.getBegin() + unescaped.getRealSize(), options.toJoniOptions(), enc, Syntax.RUBY);
            ret.setUserObject((Object)bytes);
            return ret;
        }
        catch (ValueException e) {
            throw new RaiseException(context.getCoreLibrary().runtimeError("error compiling regex", currentNode));
        }
        catch (SyntaxException e) {
            throw new RaiseException(context.getCoreLibrary().regexpError(e.getMessage(), currentNode));
        }
    }

    public static Object getCachedNames(RubyBasicObject regexp) {
        assert (RubyGuards.isRubyRegexp(regexp));
        return ((org.jruby.truffle.runtime.core.RubyRegexp)regexp).cachedNames;
    }

    public static void setCachedNames(RubyBasicObject regexp, Object cachedNames) {
        assert (RubyGuards.isRubyRegexp(regexp));
        ((org.jruby.truffle.runtime.core.RubyRegexp)regexp).cachedNames = cachedNames;
    }

    public static void setRegex(RubyBasicObject regexp, Regex regex) {
        assert (RubyGuards.isRubyRegexp(regexp));
        ((org.jruby.truffle.runtime.core.RubyRegexp)regexp).regex = regex;
    }

    public static void setSource(RubyBasicObject regexp, ByteList source) {
        assert (RubyGuards.isRubyRegexp(regexp));
        ((org.jruby.truffle.runtime.core.RubyRegexp)regexp).source = source;
    }

    public static void setOptions(RubyBasicObject regexp, RegexpOptions options) {
        assert (RubyGuards.isRubyRegexp(regexp));
        ((org.jruby.truffle.runtime.core.RubyRegexp)regexp).options = options;
    }

    public static Encoding checkEncoding(RubyBasicObject regexp, CodeRangeable str, boolean warn) {
        assert (RubyGuards.isRubyRegexp(regexp));
        Regex pattern = RegexpNodes.getRegex(regexp);
        Encoding enc = str.getByteList().getEncoding();
        if (!enc.isAsciiCompatible()) {
            if (enc != pattern.getEncoding()) {
                // empty if block
            }
        } else if (RegexpNodes.getOptions(regexp).isFixed()) {
            enc = pattern.getEncoding();
        }
        return enc;
    }

    public static void initialize(RubyBasicObject regexp, Node currentNode, ByteList setSource, int options) {
        assert (RubyGuards.isRubyRegexp(regexp));
        RegexpNodes.setSource(regexp, setSource);
        RegexpNodes.setOptions(regexp, RegexpOptions.fromEmbeddedOptions((int)options));
        RegexpNodes.setRegex(regexp, RegexpNodes.compile(currentNode, regexp.getContext(), setSource, RegexpNodes.getOptions(regexp)));
    }

    public static void initialize(RubyBasicObject regexp, Regex setRegex, ByteList setSource) {
        assert (RubyGuards.isRubyRegexp(regexp));
        RegexpNodes.setRegex(regexp, setRegex);
        RegexpNodes.setSource(regexp, setSource);
    }

    public static RubyBasicObject createRubyRegexp(Node currentNode, RubyClass regexpClass, ByteList regex, RegexpOptions options) {
        org.jruby.truffle.runtime.core.RubyRegexp regexp = new org.jruby.truffle.runtime.core.RubyRegexp(regexpClass);
        RegexpNodes.setOptions(regexp, options);
        RegexpNodes.initialize(regexp, RegexpNodes.compile(currentNode, regexpClass.getContext(), regex, options), regex);
        return regexp;
    }

    public static RubyBasicObject createRubyRegexp(Node currentNode, RubyClass regexpClass, ByteList regex, int options) {
        org.jruby.truffle.runtime.core.RubyRegexp regexp = new org.jruby.truffle.runtime.core.RubyRegexp(regexpClass);
        RegexpNodes.setOptions(regexp, RegexpOptions.fromEmbeddedOptions((int)options));
        RegexpNodes.initialize(regexp, RegexpNodes.compile(currentNode, regexpClass.getContext(), regex, RegexpNodes.getOptions(regexp)), regex);
        return regexp;
    }

    public static RubyBasicObject createRubyRegexp(RubyClass regexpClass, Regex regex, ByteList source, RegexpOptions options) {
        org.jruby.truffle.runtime.core.RubyRegexp regexp = new org.jruby.truffle.runtime.core.RubyRegexp(regexpClass);
        RegexpNodes.setOptions(regexp, options);
        RegexpNodes.initialize(regexp, regex, source);
        return regexp;
    }

    public static RubyBasicObject createRubyRegexp(RubyClass regexpClass, Regex regex, ByteList source) {
        org.jruby.truffle.runtime.core.RubyRegexp regexp = new org.jruby.truffle.runtime.core.RubyRegexp(regexpClass);
        RegexpNodes.initialize(regexp, regex, source);
        return regexp;
    }

    public static class RegexpAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new org.jruby.truffle.runtime.core.RubyRegexp(rubyClass);
        }
    }

    @NodeChild(value="self")
    public static abstract class RubiniusNamesNode
    extends RubyNode {
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;

        public RubiniusNamesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!anyNames(regexp)"})
        public RubyBasicObject rubiniusNamesNoCaptures(RubyBasicObject regexp) {
            return this.nil();
        }

        @Specialization(guards={"anyNames(regexp)"})
        public Object rubiniusNames(VirtualFrame frame, RubyBasicObject regexp) {
            if (RegexpNodes.getCachedNames(regexp) != null) {
                return RegexpNodes.getCachedNames(regexp);
            }
            if (this.newLookupTableNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.newLookupTableNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (this.lookupTableWriteNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.lookupTableWriteNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object namesLookupTable = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            Iterator i = RegexpNodes.getRegex(regexp).namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                RubyBasicObject name = this.getSymbol(new ByteList(e.name, e.nameP, e.nameEnd - e.nameP, false));
                int[] backrefs = e.getBackRefs();
                RubyBasicObject backrefsRubyArray = ArrayNodes.createArray(this.getContext().getCoreLibrary().getArrayClass(), backrefs, backrefs.length);
                this.lookupTableWriteNode.call(frame, namesLookupTable, "[]=", null, name, backrefsRubyArray);
            }
            RegexpNodes.setCachedNames(regexp, namesLookupTable);
            return namesLookupTable;
        }

        public static boolean anyNames(RubyBasicObject regexp) {
            return RegexpNodes.getRegex(regexp).numberOfNames() > 0;
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toS(RubyBasicObject regexp) {
            return this.createString(((RubyString)RubyRegexp.newRegexp((Ruby)this.getContext().getRuntime(), (ByteList)RegexpNodes.getSource(regexp), (int)RegexpNodes.getRegex(regexp).getOptions()).to_s()).getByteList());
        }
    }

    @CoreMethod(names={"source"})
    public static abstract class SourceNode
    extends CoreMethodArrayArgumentsNode {
        public SourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject source(RubyBasicObject regexp) {
            return this.createString(RegexpNodes.getSource(regexp).dup());
        }
    }

    @CoreMethod(names={"search_from"}, required=2)
    public static abstract class SearchFromNode
    extends CoreMethodArrayArgumentsNode {
        public SearchFromNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object searchFrom(RubyBasicObject regexp, RubyBasicObject string, int startPos) {
            return RegexpNodes.matchCommon(regexp, string, false, false, startPos);
        }
    }

    @CoreMethod(names={"quote", "escape"}, needsSelf=false, onSingleton=true, required=1)
    public static abstract class QuoteNode
    extends CoreMethodArrayArgumentsNode {
        public QuoteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(raw)"})
        public RubyBasicObject quoteString(RubyBasicObject raw) {
            boolean isAsciiOnly = StringNodes.getByteList(raw).getEncoding().isAsciiCompatible() && StringNodes.scanForCodeRange(raw) == 16;
            return this.createString(RubyRegexp.quote19((ByteList)StringNodes.getByteList(raw), (boolean)isAsciiOnly));
        }

        @Specialization(guards={"isRubySymbol(raw)"})
        public RubyBasicObject quoteSymbol(RubyBasicObject raw) {
            return this.quoteString(StringNodes.createString(raw.getContext().getCoreLibrary().getStringClass(), SymbolNodes.getString(raw)));
        }
    }

    @CoreMethod(names={"match_start"}, required=2)
    public static abstract class MatchStartNode
    extends CoreMethodArrayArgumentsNode {
        public MatchStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object matchStart(RubyBasicObject regexp, RubyBasicObject string, int startPos) {
            Object matchResult = RegexpNodes.matchCommon(regexp, string, false, false, startPos);
            if (matchResult instanceof RubyMatchData && ((RubyMatchData)matchResult).getNumberOfRegions() > 0 && ((RubyMatchData)matchResult).getRegion().beg[0] == startPos) {
                return matchResult;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(RubyBasicObject regexp) {
            int options = RegexpNodes.getRegex(regexp).getOptions() & 0xFFFFFFDF;
            return options ^ RegexpNodes.getSource(regexp).hashCode();
        }
    }

    @CoreMethod(names={"escape"}, onSingleton=true, required=1)
    public static abstract class EscapeNode
    extends CoreMethodArrayArgumentsNode {
        public EscapeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)"})
        public RubyBasicObject escape(RubyBasicObject pattern) {
            return this.createString(RubyRegexp.quote19((ByteList)new ByteList(StringNodes.getByteList(pattern)), (boolean)true).toString());
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toSNode;
        @Node.Child
        private ToStrNode toStrNode;

        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object match(RubyBasicObject regexp, RubyBasicObject string) {
            return RegexpNodes.matchCommon(regexp, string, true, true);
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public Object match(VirtualFrame frame, RubyBasicObject regexp, RubyBasicObject symbol) {
            if (this.toSNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toSNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.match(regexp, (RubyBasicObject)this.toSNode.call(frame, symbol, "to_s", null, new Object[0]));
        }

        @Specialization(guards={"isNil(nil)"})
        public Object match(RubyBasicObject regexp, Object nil) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyString(other)", "!isRubySymbol(other)", "!isNil(other)"})
        public Object matchGeneric(VirtualFrame frame, RubyBasicObject regexp, RubyBasicObject other) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.match(regexp, this.toStrNode.executeToStr(frame, other));
        }
    }
}

