/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.DefaultValueNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.signal.SignalOperations;
import sun.misc.Signal;

@CoreClass(name="Process")
public abstract class ProcessNodes {
    public static final int CLOCK_MONOTONIC = 1;
    public static final int CLOCK_REALTIME = 2;
    public static final int CLOCK_THREAD_CPUTIME_ID = 3;

    @CoreMethod(names={"pid"}, onSingleton=true)
    public static abstract class PidNode
    extends CoreMethodArrayArgumentsNode {
        public PidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int pid() {
            return this.posix().getpid();
        }
    }

    @CoreMethod(names={"kill"}, onSingleton=true, required=2)
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        public KillNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(signalName)"})
        public int kill(RubyBasicObject signalName, int pid) {
            int self = this.posix().getpid();
            if (self == pid) {
                Signal signal = new Signal(SymbolNodes.getString(signalName));
                SignalOperations.raise(signal);
                return 1;
            }
            throw new UnsupportedOperationException();
        }
    }

    @CoreMethod(names={"clock_gettime"}, onSingleton=true, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="clock_id"), @NodeChild(type=RubyNode.class, value="unit")})
    public static abstract class ClockGetTimeNode
    extends CoreMethodNode {
        private final RubyBasicObject floatSecondSymbol = this.getContext().getSymbol("float_second");
        private final RubyBasicObject nanosecondSymbol = this.getContext().getSymbol("nanosecond");

        public ClockGetTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"unit"})
        public RubyNode coerceUnit(RubyNode unit) {
            return DefaultValueNodeGen.create(this.getContext(), this.getSourceSection(), this.floatSecondSymbol, unit);
        }

        @Specialization(guards={"isMonotonic(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_monotonic(int clock_id, RubyBasicObject unit) {
            long time = System.nanoTime();
            return this.timeToUnit(time, unit);
        }

        @Specialization(guards={"isRealtime(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_realtime(int clock_id, RubyBasicObject unit) {
            long time = System.currentTimeMillis() * 1000000L;
            return this.timeToUnit(time, unit);
        }

        @Specialization(guards={"isThreadCPUTime(clock_id)", "isRubySymbol(unit)"})
        protected Object clock_gettime_thread_cputime(int clock_id, RubyBasicObject unit, @Cached(value="getLibCClockGetTime()") LibCClockGetTime libCClockGetTime) {
            TimeSpec timeSpec = new TimeSpec(Runtime.getRuntime((Object)libCClockGetTime));
            int r = libCClockGetTime.clock_gettime(3, timeSpec);
            if (r != 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().systemCallError("clock_gettime failed: " + r, this));
            }
            long nanos = timeSpec.getTVsec() * 1000000000L + timeSpec.getTVnsec();
            return this.timeToUnit(nanos, unit);
        }

        private Object timeToUnit(long time, RubyBasicObject unit) {
            assert (RubyGuards.isRubySymbol(unit));
            if (unit == this.nanosecondSymbol) {
                return time;
            }
            if (unit == this.floatSecondSymbol) {
                return (double)time / 1.0E9;
            }
            throw new UnsupportedOperationException(SymbolNodes.getString(unit));
        }

        protected static boolean isMonotonic(int clock_id) {
            return clock_id == 1;
        }

        protected static boolean isRealtime(int clock_id) {
            return clock_id == 2;
        }

        protected static boolean isThreadCPUTime(int clock_id) {
            return clock_id == 3;
        }

        protected static LibCClockGetTime getLibCClockGetTime() {
            return (LibCClockGetTime)LibraryLoader.create(LibCClockGetTime.class).library("c").load();
        }
    }

    public static interface LibCClockGetTime {
        public int clock_gettime(int var1, TimeSpec var2);
    }

    public static final class TimeSpec
    extends Struct {
        public final Struct.time_t tv_sec = new Struct.time_t((Struct)this);
        public final Struct.SignedLong tv_nsec = new Struct.SignedLong((Struct)this);

        public TimeSpec(Runtime runtime) {
            super(runtime);
        }

        public long getTVsec() {
            return this.tv_sec.get();
        }

        public long getTVnsec() {
            return this.tv_nsec.get();
        }
    }
}

