/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.util.Memo;

@CoreClass(name="Proc")
public abstract class ProcNodes {
    public static Type getType(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).type;
    }

    public static SharedMethodInfo getSharedMethodInfo(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).sharedMethodInfo;
    }

    public static CallTarget getCallTargetForBlocks(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).callTargetForBlocks;
    }

    public static CallTarget getCallTargetForProcs(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).callTargetForProcs;
    }

    public static CallTarget getCallTargetForLambdas(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).callTargetForLambdas;
    }

    public static MaterializedFrame getDeclarationFrame(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).declarationFrame;
    }

    public static InternalMethod getMethod(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).method;
    }

    public static Object getSelfCapturedInScope(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).self;
    }

    public static RubyBasicObject getBlockCapturedInScope(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        return ((RubyProc)proc).block;
    }

    public static CallTarget getCallTargetForType(RubyBasicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        switch (((RubyProc)proc).type) {
            case BLOCK: {
                return ((RubyProc)proc).callTargetForBlocks;
            }
            case PROC: {
                return ((RubyProc)proc).callTargetForProcs;
            }
            case LAMBDA: {
                return ((RubyProc)proc).callTargetForLambdas;
            }
        }
        throw new UnsupportedOperationException(((RubyProc)proc).type.toString());
    }

    public static Object rootCall(RubyBasicObject proc, Object ... args) {
        assert (RubyGuards.isRubyProc(proc));
        return ProcNodes.getCallTargetForType(proc).call(RubyArguments.pack(ProcNodes.getMethod(proc), ProcNodes.getDeclarationFrame(proc), ProcNodes.getSelfCapturedInScope(proc), ProcNodes.getBlockCapturedInScope(proc), args));
    }

    public static void initialize(RubyBasicObject proc, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForBlocks, CallTarget callTargetForProcs, CallTarget callTargetForLambdas, MaterializedFrame declarationFrame, InternalMethod method, Object self, RubyBasicObject block) {
        assert (RubyGuards.isRubyProc(proc));
        ((RubyProc)proc).sharedMethodInfo = sharedMethodInfo;
        ((RubyProc)proc).callTargetForBlocks = callTargetForBlocks;
        ((RubyProc)proc).callTargetForProcs = callTargetForProcs;
        ((RubyProc)proc).callTargetForLambdas = callTargetForLambdas;
        ((RubyProc)proc).declarationFrame = declarationFrame;
        ((RubyProc)proc).method = method;
        ((RubyProc)proc).self = self;
        assert (block == null || RubyGuards.isRubyProc(block));
        ((RubyProc)proc).block = block;
    }

    public static RubyBasicObject createRubyProc(RubyClass procClass, Type type) {
        return ProcNodes.createRubyProc(procClass, type, null, null, null, null, null, null, null, null);
    }

    public static RubyBasicObject createRubyProc(RubyClass procClass, Type type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForBlocks, CallTarget callTargetForProcs, CallTarget callTargetForLambdas, MaterializedFrame declarationFrame, InternalMethod method, Object self, RubyBasicObject block) {
        return new RubyProc(procClass, type, sharedMethodInfo, callTargetForBlocks, callTargetForProcs, callTargetForLambdas, declarationFrame, method, self, block);
    }

    public static class ProcAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return ProcNodes.createRubyProc(rubyClass, Type.PROC);
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        public SourceLocationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object sourceLocation(RubyBasicObject proc) {
            SourceSection sourceSection = ProcNodes.getSharedMethodInfo(proc).getSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.nil();
            }
            RubyBasicObject file = this.createString(sourceSection.getSource().getName());
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), file, sourceSection.getStartLine());
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        public ParametersNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject parameters(RubyBasicObject proc) {
            ArgsNode argsNode = (ArgsNode)ProcNodes.getSharedMethodInfo(proc).getParseTree().findFirstChild(ArgsNode.class);
            ArgumentDescriptor[] argsDesc = Helpers.argsNodeToArgumentDescriptors((ArgsNode)argsNode);
            return this.getContext().toTruffle(Helpers.argumentDescriptorsToParameters((Ruby)this.getContext().getRuntime(), (ArgumentDescriptor[])argsDesc, (ProcNodes.getType(proc) == Type.LAMBDA ? 1 : 0) != 0));
        }
    }

    @CoreMethod(names={"lambda?"})
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean lambda(RubyBasicObject proc) {
            return ProcNodes.getType(proc) == Type.LAMBDA;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public RubyBasicObject initialize(RubyBasicObject proc, RubyBasicObject block) {
            ProcNodes.initialize(proc, ProcNodes.getSharedMethodInfo(block), ProcNodes.getCallTargetForProcs(block), ProcNodes.getCallTargetForProcs(block), ProcNodes.getCallTargetForLambdas(block), ProcNodes.getDeclarationFrame(block), ProcNodes.getMethod(block), ProcNodes.getSelfCapturedInScope(block), ProcNodes.getBlockCapturedInScope(block));
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject initialize(RubyBasicObject proc, NotProvided block) {
            final Memo frameCount = new Memo((Object)0);
            MaterializedFrame grandparentFrame = (MaterializedFrame)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<MaterializedFrame>(){

                public MaterializedFrame visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            RubyBasicObject grandparentBlock = RubyArguments.getBlock(grandparentFrame.getArguments());
            if (grandparentBlock == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("tried to create Proc object without a block", this));
            }
            return this.initialize(proc, grandparentBlock);
        }
    }

    @CoreMethod(names={"call", "[]", "yield"}, argumentsAsArray=true, needsBlock=true)
    public static abstract class CallNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyBasicObject proc, Object[] args, NotProvided block) {
            return this.yieldNode.dispatch(frame, proc, args);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object call(VirtualFrame frame, RubyBasicObject proc, Object[] args, RubyBasicObject block) {
            return this.yieldNode.dispatchWithModifiedBlock(frame, proc, block, args);
        }
    }

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object binding(RubyBasicObject proc) {
            MaterializedFrame frame = ProcNodes.getDeclarationFrame(proc);
            return BindingNodes.createRubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(frame.getArguments()), frame);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int arity(RubyBasicObject proc) {
            return ProcNodes.getSharedMethodInfo(proc).getArity().getArityNumber();
        }
    }

    public static enum Type {
        BLOCK,
        PROC,
        LAMBDA;

    }
}

