/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.MathNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=MathNodes.class)
public final class MathNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(ACosNodeFactory.getInstance(), ACosHNodeFactory.getInstance(), ASinNodeFactory.getInstance(), ASinHNodeFactory.getInstance(), ATanNodeFactory.getInstance(), ATan2NodeFactory.getInstance(), ATanHNodeFactory.getInstance(), CbRtNodeFactory.getInstance(), CosNodeFactory.getInstance(), CosHNodeFactory.getInstance(), ErfNodeFactory.getInstance(), ErfcNodeFactory.getInstance(), ExpNodeFactory.getInstance(), FrExpNodeFactory.getInstance(), GammaNodeFactory.getInstance(), HypotNodeFactory.getInstance(), LdexpNodeFactory.getInstance(), LGammaNodeFactory.getInstance(), LogNodeFactory.getInstance(), Log10NodeFactory.getInstance(), Log2NodeFactory.getInstance(), SinNodeFactory.getInstance(), SinHNodeFactory.getInstance(), TanNodeFactory.getInstance(), TanHNodeFactory.getInstance(), SqrtNodeFactory.getInstance(), SimpleMonadicMathNodeFactory.getInstance(), SimpleDyadicMathNodeFactory.getInstance());
    }

    @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
    protected static final class SimpleDyadicMathNodeFactory
    extends NodeFactoryBase<MathNodes.SimpleDyadicMathNode> {
        private static SimpleDyadicMathNodeFactory simpleDyadicMathNodeFactoryInstance;

        private SimpleDyadicMathNodeFactory() {
            super(MathNodes.SimpleDyadicMathNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.SimpleDyadicMathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SimpleDyadicMathNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        protected static NodeFactory<MathNodes.SimpleDyadicMathNode> getInstance() {
            if (simpleDyadicMathNodeFactoryInstance == null) {
                simpleDyadicMathNodeFactoryInstance = new SimpleDyadicMathNodeFactory();
            }
            return simpleDyadicMathNodeFactoryInstance;
        }

        public static MathNodes.SimpleDyadicMathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SimpleDyadicMathNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        protected static final class SimpleDyadicMathNodeGen
        extends MathNodes.SimpleDyadicMathNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SimpleDyadicMathNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SimpleDyadicMathNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function15Node_
            extends BaseNode_ {
                Function15Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 16);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function15Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, RubyBasicObject)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function14Node_
            extends BaseNode_ {
                Function14Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 15);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof RubyBasicObject) {
                        double arguments0Value_ = (Double)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function14Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function13Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function13Node_(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    super(root, 14);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function13Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = (Double)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    return new Function13Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function12Node_
            extends BaseNode_ {
                Function12Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Integer) {
                        double arguments0Value_ = (Double)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function12Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, double)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function11Node_
            extends BaseNode_ {
                Function11Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function11Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, RubyBasicObject)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function10Node_
            extends BaseNode_ {
                Function10Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 11);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function10Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, long)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function9Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function9Node_(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function9Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    return new Function9Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, int)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function8Node_
            extends BaseNode_ {
                Function8Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function8Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function7Node_(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function7Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    return new Function7Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, RubyBasicObject)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function6Node_(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    return new Function6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function5Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function5Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function5Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function4Node_(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    return new Function4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Double) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, RubyBasicObject)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function1Node_(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    return new Function1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SimpleDyadicMathNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SimpleDyadicMathNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SimpleDyadicMathNodeGen root;

                BaseNode_(SimpleDyadicMathNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Function0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Function2Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function3Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (arguments1Value instanceof Integer) {
                            return Function4Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function5Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function6Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function7Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (arguments1Value instanceof Integer && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function9Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_2 = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_2)) {
                                return Function10Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof Double && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function11Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof Double) {
                        if (arguments1Value instanceof Integer) {
                            return Function12Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function13Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Function14Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function15Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
    protected static final class SimpleMonadicMathNodeFactory
    extends NodeFactoryBase<MathNodes.SimpleMonadicMathNode> {
        private static SimpleMonadicMathNodeFactory simpleMonadicMathNodeFactoryInstance;

        private SimpleMonadicMathNodeFactory() {
            super(MathNodes.SimpleMonadicMathNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.SimpleMonadicMathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SimpleMonadicMathNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        protected static NodeFactory<MathNodes.SimpleMonadicMathNode> getInstance() {
            if (simpleMonadicMathNodeFactoryInstance == null) {
                simpleMonadicMathNodeFactoryInstance = new SimpleMonadicMathNodeFactory();
            }
            return simpleMonadicMathNodeFactoryInstance;
        }

        public static MathNodes.SimpleMonadicMathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SimpleMonadicMathNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        protected static final class SimpleMonadicMathNodeGen
        extends MathNodes.SimpleMonadicMathNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SimpleMonadicMathNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SimpleMonadicMathNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(SimpleMonadicMathNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SimpleMonadicMathNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(SimpleMonadicMathNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(SimpleMonadicMathNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SimpleMonadicMathNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SimpleMonadicMathNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SimpleMonadicMathNodeGen root;

                BaseNode_(SimpleMonadicMathNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.SqrtNode.class)
    public static final class SqrtNodeFactory
    extends NodeFactoryBase<MathNodes.SqrtNode> {
        private static SqrtNodeFactory sqrtNodeFactoryInstance;

        private SqrtNodeFactory() {
            super(MathNodes.SqrtNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.SqrtNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SqrtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.SqrtNode> getInstance() {
            if (sqrtNodeFactoryInstance == null) {
                sqrtNodeFactoryInstance = new SqrtNodeFactory();
            }
            return sqrtNodeFactoryInstance;
        }

        public static MathNodes.SqrtNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SqrtNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        public static final class SqrtNodeGen
        extends MathNodes.SqrtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SqrtNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.SqrtNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SqrtNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.SqrtNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(SqrtNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.SqrtNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SqrtNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.SqrtNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(SqrtNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.SqrtNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(SqrtNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SqrtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SqrtNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SqrtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SqrtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SqrtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SqrtNodeGen root;

                BaseNode_(SqrtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.TanHNode.class)
    public static final class TanHNodeFactory
    extends NodeFactoryBase<MathNodes.TanHNode> {
        private static TanHNodeFactory tanHNodeFactoryInstance;

        private TanHNodeFactory() {
            super(MathNodes.TanHNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.TanHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return TanHNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.TanHNode> getInstance() {
            if (tanHNodeFactoryInstance == null) {
                tanHNodeFactoryInstance = new TanHNodeFactory();
            }
            return tanHNodeFactoryInstance;
        }

        public static MathNodes.TanHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new TanHNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        public static final class TanHNodeGen
        extends MathNodes.TanHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private TanHNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.TanHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(TanHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.TanHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(TanHNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.TanHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(TanHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.TanHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(TanHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.TanHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(TanHNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(TanHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(TanHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final TanHNodeGen root;

                BaseNode_(TanHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.TanNode.class)
    public static final class TanNodeFactory
    extends NodeFactoryBase<MathNodes.TanNode> {
        private static TanNodeFactory tanNodeFactoryInstance;

        private TanNodeFactory() {
            super(MathNodes.TanNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.TanNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return TanNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.TanNode> getInstance() {
            if (tanNodeFactoryInstance == null) {
                tanNodeFactoryInstance = new TanNodeFactory();
            }
            return tanNodeFactoryInstance;
        }

        public static MathNodes.TanNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new TanNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        public static final class TanNodeGen
        extends MathNodes.TanNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private TanNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.TanNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(TanNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.TanNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(TanNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.TanNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(TanNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.TanNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(TanNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.TanNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(TanNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(TanNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(TanNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final TanNodeGen root;

                BaseNode_(TanNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.SinHNode.class)
    public static final class SinHNodeFactory
    extends NodeFactoryBase<MathNodes.SinHNode> {
        private static SinHNodeFactory sinHNodeFactoryInstance;

        private SinHNodeFactory() {
            super(MathNodes.SinHNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.SinHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SinHNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.SinHNode> getInstance() {
            if (sinHNodeFactoryInstance == null) {
                sinHNodeFactoryInstance = new SinHNodeFactory();
            }
            return sinHNodeFactoryInstance;
        }

        public static MathNodes.SinHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SinHNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        public static final class SinHNodeGen
        extends MathNodes.SinHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SinHNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.SinHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SinHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.SinHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(SinHNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.SinHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SinHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.SinHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(SinHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.SinHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(SinHNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SinHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SinHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SinHNodeGen root;

                BaseNode_(SinHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.SinNode.class)
    public static final class SinNodeFactory
    extends NodeFactoryBase<MathNodes.SinNode> {
        private static SinNodeFactory sinNodeFactoryInstance;

        private SinNodeFactory() {
            super(MathNodes.SinNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.SinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.SinNode> getInstance() {
            if (sinNodeFactoryInstance == null) {
                sinNodeFactoryInstance = new SinNodeFactory();
            }
            return sinNodeFactoryInstance;
        }

        public static MathNodes.SinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SinNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        public static final class SinNodeGen
        extends MathNodes.SinNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SinNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.SinNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SinNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.SinNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(SinNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.SinNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SinNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.SinNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(SinNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.SinNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(SinNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SinNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SinNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SinNodeGen root;

                BaseNode_(SinNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.Log2Node.class)
    public static final class Log2NodeFactory
    extends NodeFactoryBase<MathNodes.Log2Node> {
        private static Log2NodeFactory log2NodeFactoryInstance;

        private Log2NodeFactory() {
            super(MathNodes.Log2Node.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.Log2Node createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return Log2NodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.Log2Node> getInstance() {
            if (log2NodeFactoryInstance == null) {
                log2NodeFactoryInstance = new Log2NodeFactory();
            }
            return log2NodeFactoryInstance;
        }

        public static MathNodes.Log2Node create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new Log2NodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        public static final class Log2NodeGen
        extends MathNodes.Log2Node
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private Log2NodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.Log2Node.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(Log2NodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.Log2Node.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(Log2NodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.Log2Node.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(Log2NodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.Log2Node.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(Log2NodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.Log2Node.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(Log2NodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log2Node.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(Log2NodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log2Node.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(Log2NodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log2Node.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final Log2NodeGen root;

                BaseNode_(Log2NodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.Log10Node.class)
    public static final class Log10NodeFactory
    extends NodeFactoryBase<MathNodes.Log10Node> {
        private static Log10NodeFactory log10NodeFactoryInstance;

        private Log10NodeFactory() {
            super(MathNodes.Log10Node.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.Log10Node createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return Log10NodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.Log10Node> getInstance() {
            if (log10NodeFactoryInstance == null) {
                log10NodeFactoryInstance = new Log10NodeFactory();
            }
            return log10NodeFactoryInstance;
        }

        public static MathNodes.Log10Node create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new Log10NodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        public static final class Log10NodeGen
        extends MathNodes.Log10Node
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private Log10NodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.Log10Node.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(Log10NodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.Log10Node.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(Log10NodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.Log10Node.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(Log10NodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.Log10Node.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(Log10NodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.Log10Node.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(Log10NodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log10Node.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(Log10NodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log10Node.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(Log10NodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log10Node.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final Log10NodeGen root;

                BaseNode_(Log10NodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.LogNode.class)
    public static final class LogNodeFactory
    extends NodeFactoryBase<MathNodes.LogNode> {
        private static LogNodeFactory logNodeFactoryInstance;

        private LogNodeFactory() {
            super(MathNodes.LogNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.LogNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LogNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.LogNode> getInstance() {
            if (logNodeFactoryInstance == null) {
                logNodeFactoryInstance = new LogNodeFactory();
            }
            return logNodeFactoryInstance;
        }

        public static MathNodes.LogNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LogNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        public static final class LogNodeGen
        extends MathNodes.LogNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LogNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.LogNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(LogNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function20Node_
            extends BaseNode_ {
                Function20Node_(LogNodeGen root) {
                    super(root, 21);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.function(frameValue, arguments0Value, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function20Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function19Node_
            extends BaseNode_ {
                Function19Node_(LogNodeGen root) {
                    super(root, 20);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof NotProvided) {
                        double arguments0Value_ = (Double)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function19Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function18Node_
            extends BaseNode_ {
                Function18Node_(LogNodeGen root) {
                    super(root, 19);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function18Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function17Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function17Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 18);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function17Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof NotProvided) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function17Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function16Node_
            extends BaseNode_ {
                Function16Node_(LogNodeGen root) {
                    super(root, 17);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof NotProvided) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function16Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.LogNode.class)
            private static final class Function15Node_
            extends BaseNode_ {
                Function15Node_(LogNodeGen root) {
                    super(root, 16);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function15Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, RubyBasicObject)", value=MathNodes.LogNode.class)
            private static final class Function14Node_
            extends BaseNode_ {
                Function14Node_(LogNodeGen root) {
                    super(root, 15);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof RubyBasicObject) {
                        double arguments0Value_ = (Double)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function14Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.LogNode.class)
            private static final class Function13Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function13Node_(LogNodeGen root, Object arguments1Value) {
                    super(root, 14);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function13Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = (Double)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments1Value) {
                    return new Function13Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.LogNode.class)
            private static final class Function12Node_
            extends BaseNode_ {
                Function12Node_(LogNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Integer) {
                        double arguments0Value_ = (Double)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function12Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, double)", value=MathNodes.LogNode.class)
            private static final class Function11Node_
            extends BaseNode_ {
                Function11Node_(LogNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function11Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, RubyBasicObject)", value=MathNodes.LogNode.class)
            private static final class Function10Node_
            extends BaseNode_ {
                Function10Node_(LogNodeGen root) {
                    super(root, 11);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function10Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, long)", value=MathNodes.LogNode.class)
            private static final class Function9Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function9Node_(LogNodeGen root, Object arguments1Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function9Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments1Value) {
                    return new Function9Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, int)", value=MathNodes.LogNode.class)
            private static final class Function8Node_
            extends BaseNode_ {
                Function8Node_(LogNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function8Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.LogNode.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function7Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function7Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function7Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, RubyBasicObject)", value=MathNodes.LogNode.class)
            private static final class Function6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function6Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.LogNode.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function5Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function5Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function5Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.LogNode.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function4Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.LogNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(LogNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Double) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, RubyBasicObject)", value=MathNodes.LogNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(LogNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.LogNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function1Node_(LogNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments1Value) {
                    return new Function1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.LogNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(LogNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LogNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LogNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LogNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LogNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LogNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LogNodeGen root;

                BaseNode_(LogNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments0Value_;
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Function0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Function2Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function3Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_2 = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (arguments1Value instanceof Integer) {
                            return Function4Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function5Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_2)) {
                            return Function6Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function7Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (arguments0Value instanceof RubyBasicObject) {
                        arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (arguments1Value instanceof Integer && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function9Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_2 = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_2)) {
                                return Function10Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof Double && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function11Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof Double) {
                        if (arguments1Value instanceof Integer) {
                            return Function12Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function13Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Function14Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function15Node_.create(this.root);
                        }
                    }
                    if (arguments1Value instanceof NotProvided) {
                        if (arguments0Value instanceof Integer) {
                            return Function16Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                            return Function17Node_.create(this.root, arguments0Value);
                        }
                        if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                            return Function18Node_.create(this.root);
                        }
                        if (arguments0Value instanceof Double) {
                            return Function19Node_.create(this.root);
                        }
                        return Function20Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.LGammaNode.class)
    public static final class LGammaNodeFactory
    extends NodeFactoryBase<MathNodes.LGammaNode> {
        private static LGammaNodeFactory lGammaNodeFactoryInstance;

        private LGammaNodeFactory() {
            super(MathNodes.LGammaNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.LGammaNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LGammaNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.LGammaNode> getInstance() {
            if (lGammaNodeFactoryInstance == null) {
                lGammaNodeFactoryInstance = new LGammaNodeFactory();
            }
            return lGammaNodeFactoryInstance;
        }

        public static MathNodes.LGammaNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LGammaNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        public static final class LGammaNodeGen
        extends MathNodes.LGammaNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LGammaNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="lgamma(VirtualFrame, Object)", value=MathNodes.LGammaNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(LGammaNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.lgamma(frameValue, arguments0Value);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="lgamma(double)", value=MathNodes.LGammaNode.class)
            private static final class Lgamma3Node_
            extends BaseNode_ {
                Lgamma3Node_(LGammaNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                    }
                    return this.root.lgamma(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.lgamma(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new Lgamma3Node_(root);
                }
            }

            @GeneratedBy(methodName="lgamma(RubyBasicObject)", value=MathNodes.LGammaNode.class)
            private static final class Lgamma2Node_
            extends BaseNode_ {
                Lgamma2Node_(LGammaNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.lgamma(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new Lgamma2Node_(root);
                }
            }

            @GeneratedBy(methodName="lgamma(long)", value=MathNodes.LGammaNode.class)
            private static final class Lgamma1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Lgamma1Node_(LGammaNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Lgamma1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.lgamma(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.lgamma(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root, Object arguments0Value) {
                    return new Lgamma1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="lgamma(int)", value=MathNodes.LGammaNode.class)
            private static final class Lgamma0Node_
            extends BaseNode_ {
                Lgamma0Node_(LGammaNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                    }
                    return this.root.lgamma(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.lgamma(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new Lgamma0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LGammaNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LGammaNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LGammaNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LGammaNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LGammaNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LGammaNodeGen root;

                BaseNode_(LGammaNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Lgamma0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Lgamma1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Lgamma2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Lgamma3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.LdexpNode.class)
    public static final class LdexpNodeFactory
    extends NodeFactoryBase<MathNodes.LdexpNode> {
        private static LdexpNodeFactory ldexpNodeFactoryInstance;

        private LdexpNodeFactory() {
            super(MathNodes.LdexpNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.LdexpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LdexpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.LdexpNode> getInstance() {
            if (ldexpNodeFactoryInstance == null) {
                ldexpNodeFactoryInstance = new LdexpNodeFactory();
            }
            return ldexpNodeFactoryInstance;
        }

        public static MathNodes.LdexpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LdexpNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        public static final class LdexpNodeGen
        extends MathNodes.LdexpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LdexpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.LdexpNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(LdexpNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.LdexpNode.class)
            private static final class Function11Node_
            extends BaseNode_ {
                Function11Node_(LdexpNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new Function11Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.LdexpNode.class)
            private static final class Function10Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function10Node_(LdexpNodeGen root, Object arguments1Value) {
                    super(root, 11);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function10Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = (Double)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root, Object arguments1Value) {
                    return new Function10Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.LdexpNode.class)
            private static final class Function9Node_
            extends BaseNode_ {
                Function9Node_(LdexpNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Integer) {
                        double arguments0Value_ = (Double)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new Function9Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, double)", value=MathNodes.LdexpNode.class)
            private static final class Function8Node_
            extends BaseNode_ {
                Function8Node_(LdexpNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new Function8Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, long)", value=MathNodes.LdexpNode.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function7Node_(LdexpNodeGen root, Object arguments1Value) {
                    super(root, 8);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function7Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root, Object arguments1Value) {
                    return new Function7Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, int)", value=MathNodes.LdexpNode.class)
            private static final class Function6Node_
            extends BaseNode_ {
                Function6Node_(LdexpNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new Function6Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.LdexpNode.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function5Node_(LdexpNodeGen root, Object arguments0Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root, Object arguments0Value) {
                    return new Function5Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.LdexpNode.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function4Node_(LdexpNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function4Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function4Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.LdexpNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(LdexpNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.LdexpNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(LdexpNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Double) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.LdexpNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function1Node_(LdexpNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root, Object arguments1Value) {
                    return new Function1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.LdexpNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(LdexpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LdexpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LdexpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LdexpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LdexpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LdexpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LdexpNodeGen root;

                BaseNode_(LdexpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Function0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function2Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        if (arguments1Value instanceof Integer) {
                            return Function3Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function4Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function5Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (arguments1Value instanceof Integer && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function6Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function7Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof Double) {
                        if (arguments1Value instanceof Integer) {
                            return Function9Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function10Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function11Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.HypotNode.class)
    public static final class HypotNodeFactory
    extends NodeFactoryBase<MathNodes.HypotNode> {
        private static HypotNodeFactory hypotNodeFactoryInstance;

        private HypotNodeFactory() {
            super(MathNodes.HypotNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.HypotNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HypotNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.HypotNode> getInstance() {
            if (hypotNodeFactoryInstance == null) {
                hypotNodeFactoryInstance = new HypotNodeFactory();
            }
            return hypotNodeFactoryInstance;
        }

        public static MathNodes.HypotNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new HypotNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        public static final class HypotNodeGen
        extends MathNodes.HypotNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private HypotNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.HypotNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(HypotNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.HypotNode.class)
            private static final class Function15Node_
            extends BaseNode_ {
                Function15Node_(HypotNodeGen root) {
                    super(root, 16);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function15Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, RubyBasicObject)", value=MathNodes.HypotNode.class)
            private static final class Function14Node_
            extends BaseNode_ {
                Function14Node_(HypotNodeGen root) {
                    super(root, 15);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof RubyBasicObject) {
                        double arguments0Value_ = (Double)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function14Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.HypotNode.class)
            private static final class Function13Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function13Node_(HypotNodeGen root, Object arguments1Value) {
                    super(root, 14);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function13Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = (Double)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments1Value) {
                    return new Function13Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.HypotNode.class)
            private static final class Function12Node_
            extends BaseNode_ {
                Function12Node_(HypotNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Integer) {
                        double arguments0Value_ = (Double)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function12Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, double)", value=MathNodes.HypotNode.class)
            private static final class Function11Node_
            extends BaseNode_ {
                Function11Node_(HypotNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function11Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, RubyBasicObject)", value=MathNodes.HypotNode.class)
            private static final class Function10Node_
            extends BaseNode_ {
                Function10Node_(HypotNodeGen root) {
                    super(root, 11);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function10Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, long)", value=MathNodes.HypotNode.class)
            private static final class Function9Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function9Node_(HypotNodeGen root, Object arguments1Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function9Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments1Value) {
                    return new Function9Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, int)", value=MathNodes.HypotNode.class)
            private static final class Function8Node_
            extends BaseNode_ {
                Function8Node_(HypotNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function8Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.HypotNode.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function7Node_(HypotNodeGen root, Object arguments0Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function7Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value) {
                    return new Function7Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, RubyBasicObject)", value=MathNodes.HypotNode.class)
            private static final class Function6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function6Node_(HypotNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value) {
                    return new Function6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.HypotNode.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function5Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function5Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function5Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.HypotNode.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function4Node_(HypotNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value) {
                    return new Function4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.HypotNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(HypotNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Double) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, RubyBasicObject)", value=MathNodes.HypotNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(HypotNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.HypotNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function1Node_(HypotNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments1Value) {
                    return new Function1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.HypotNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(HypotNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.HypotNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(HypotNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.HypotNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(HypotNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.HypotNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final HypotNodeGen root;

                BaseNode_(HypotNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Function0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Function2Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function3Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (arguments1Value instanceof Integer) {
                            return Function4Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function5Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function6Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function7Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (arguments1Value instanceof Integer && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function9Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_2 = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_2)) {
                                return Function10Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof Double && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function11Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof Double) {
                        if (arguments1Value instanceof Integer) {
                            return Function12Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function13Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Function14Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function15Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.GammaNode.class)
    public static final class GammaNodeFactory
    extends NodeFactoryBase<MathNodes.GammaNode> {
        private static GammaNodeFactory gammaNodeFactoryInstance;

        private GammaNodeFactory() {
            super(MathNodes.GammaNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.GammaNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GammaNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.GammaNode> getInstance() {
            if (gammaNodeFactoryInstance == null) {
                gammaNodeFactoryInstance = new GammaNodeFactory();
            }
            return gammaNodeFactoryInstance;
        }

        public static MathNodes.GammaNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GammaNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        public static final class GammaNodeGen
        extends MathNodes.GammaNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GammaNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.GammaNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(GammaNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.GammaNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(GammaNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.GammaNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(GammaNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.GammaNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(GammaNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.GammaNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(GammaNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.GammaNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GammaNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.GammaNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GammaNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.GammaNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final GammaNodeGen root;

                BaseNode_(GammaNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.FrExpNode.class)
    public static final class FrExpNodeFactory
    extends NodeFactoryBase<MathNodes.FrExpNode> {
        private static FrExpNodeFactory frExpNodeFactoryInstance;

        private FrExpNodeFactory() {
            super(MathNodes.FrExpNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.FrExpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FrExpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.FrExpNode> getInstance() {
            if (frExpNodeFactoryInstance == null) {
                frExpNodeFactoryInstance = new FrExpNodeFactory();
            }
            return frExpNodeFactoryInstance;
        }

        public static MathNodes.FrExpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new FrExpNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        public static final class FrExpNodeGen
        extends MathNodes.FrExpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FrExpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="frexp(VirtualFrame, Object)", value=MathNodes.FrExpNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(FrExpNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.frexp(frameValue, arguments0Value);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="frexp(double)", value=MathNodes.FrExpNode.class)
            private static final class Frexp3Node_
            extends BaseNode_ {
                Frexp3Node_(FrExpNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                    }
                    return this.root.frexp(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.frexp(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new Frexp3Node_(root);
                }
            }

            @GeneratedBy(methodName="frexp(RubyBasicObject)", value=MathNodes.FrExpNode.class)
            private static final class Frexp2Node_
            extends BaseNode_ {
                Frexp2Node_(FrExpNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.frexp(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new Frexp2Node_(root);
                }
            }

            @GeneratedBy(methodName="frexp(long)", value=MathNodes.FrExpNode.class)
            private static final class Frexp1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Frexp1Node_(FrExpNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Frexp1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.frexp(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.frexp(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root, Object arguments0Value) {
                    return new Frexp1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="frexp(int)", value=MathNodes.FrExpNode.class)
            private static final class Frexp0Node_
            extends BaseNode_ {
                Frexp0Node_(FrExpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                    }
                    return this.root.frexp(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.frexp(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new Frexp0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.FrExpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FrExpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.FrExpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FrExpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.FrExpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final FrExpNodeGen root;

                BaseNode_(FrExpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Frexp0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Frexp1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Frexp2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Frexp3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ExpNode.class)
    public static final class ExpNodeFactory
    extends NodeFactoryBase<MathNodes.ExpNode> {
        private static ExpNodeFactory expNodeFactoryInstance;

        private ExpNodeFactory() {
            super(MathNodes.ExpNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ExpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ExpNode> getInstance() {
            if (expNodeFactoryInstance == null) {
                expNodeFactoryInstance = new ExpNodeFactory();
            }
            return expNodeFactoryInstance;
        }

        public static MathNodes.ExpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExpNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        public static final class ExpNodeGen
        extends MathNodes.ExpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ExpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ExpNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ExpNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ExpNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ExpNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ExpNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ExpNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ExpNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ExpNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ExpNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ExpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ExpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ExpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ExpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ExpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ExpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ExpNodeGen root;

                BaseNode_(ExpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ErfcNode.class)
    public static final class ErfcNodeFactory
    extends NodeFactoryBase<MathNodes.ErfcNode> {
        private static ErfcNodeFactory erfcNodeFactoryInstance;

        private ErfcNodeFactory() {
            super(MathNodes.ErfcNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ErfcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ErfcNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ErfcNode> getInstance() {
            if (erfcNodeFactoryInstance == null) {
                erfcNodeFactoryInstance = new ErfcNodeFactory();
            }
            return erfcNodeFactoryInstance;
        }

        public static MathNodes.ErfcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ErfcNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        public static final class ErfcNodeGen
        extends MathNodes.ErfcNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ErfcNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ErfcNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ErfcNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ErfcNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ErfcNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ErfcNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ErfcNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ErfcNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ErfcNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ErfcNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ErfcNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfcNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ErfcNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfcNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ErfcNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfcNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ErfcNodeGen root;

                BaseNode_(ErfcNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ErfNode.class)
    public static final class ErfNodeFactory
    extends NodeFactoryBase<MathNodes.ErfNode> {
        private static ErfNodeFactory erfNodeFactoryInstance;

        private ErfNodeFactory() {
            super(MathNodes.ErfNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ErfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ErfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ErfNode> getInstance() {
            if (erfNodeFactoryInstance == null) {
                erfNodeFactoryInstance = new ErfNodeFactory();
            }
            return erfNodeFactoryInstance;
        }

        public static MathNodes.ErfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ErfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        public static final class ErfNodeGen
        extends MathNodes.ErfNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ErfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ErfNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ErfNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ErfNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ErfNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ErfNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ErfNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ErfNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ErfNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ErfNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ErfNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ErfNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ErfNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ErfNodeGen root;

                BaseNode_(ErfNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.CosHNode.class)
    public static final class CosHNodeFactory
    extends NodeFactoryBase<MathNodes.CosHNode> {
        private static CosHNodeFactory cosHNodeFactoryInstance;

        private CosHNodeFactory() {
            super(MathNodes.CosHNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.CosHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CosHNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.CosHNode> getInstance() {
            if (cosHNodeFactoryInstance == null) {
                cosHNodeFactoryInstance = new CosHNodeFactory();
            }
            return cosHNodeFactoryInstance;
        }

        public static MathNodes.CosHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CosHNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        public static final class CosHNodeGen
        extends MathNodes.CosHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CosHNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.CosHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(CosHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.CosHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(CosHNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.CosHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(CosHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.CosHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(CosHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.CosHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(CosHNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CosHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CosHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CosHNodeGen root;

                BaseNode_(CosHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.CosNode.class)
    public static final class CosNodeFactory
    extends NodeFactoryBase<MathNodes.CosNode> {
        private static CosNodeFactory cosNodeFactoryInstance;

        private CosNodeFactory() {
            super(MathNodes.CosNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.CosNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CosNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.CosNode> getInstance() {
            if (cosNodeFactoryInstance == null) {
                cosNodeFactoryInstance = new CosNodeFactory();
            }
            return cosNodeFactoryInstance;
        }

        public static MathNodes.CosNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CosNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        public static final class CosNodeGen
        extends MathNodes.CosNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CosNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.CosNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(CosNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.CosNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(CosNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.CosNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(CosNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.CosNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(CosNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.CosNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(CosNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CosNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CosNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CosNodeGen root;

                BaseNode_(CosNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.CbRtNode.class)
    public static final class CbRtNodeFactory
    extends NodeFactoryBase<MathNodes.CbRtNode> {
        private static CbRtNodeFactory cbRtNodeFactoryInstance;

        private CbRtNodeFactory() {
            super(MathNodes.CbRtNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.CbRtNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CbRtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.CbRtNode> getInstance() {
            if (cbRtNodeFactoryInstance == null) {
                cbRtNodeFactoryInstance = new CbRtNodeFactory();
            }
            return cbRtNodeFactoryInstance;
        }

        public static MathNodes.CbRtNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CbRtNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        public static final class CbRtNodeGen
        extends MathNodes.CbRtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CbRtNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.CbRtNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(CbRtNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.CbRtNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(CbRtNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.CbRtNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(CbRtNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.CbRtNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(CbRtNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.CbRtNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(CbRtNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CbRtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CbRtNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CbRtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CbRtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CbRtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CbRtNodeGen root;

                BaseNode_(CbRtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATanHNode.class)
    public static final class ATanHNodeFactory
    extends NodeFactoryBase<MathNodes.ATanHNode> {
        private static ATanHNodeFactory aTanHNodeFactoryInstance;

        private ATanHNodeFactory() {
            super(MathNodes.ATanHNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ATanHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ATanHNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ATanHNode> getInstance() {
            if (aTanHNodeFactoryInstance == null) {
                aTanHNodeFactoryInstance = new ATanHNodeFactory();
            }
            return aTanHNodeFactoryInstance;
        }

        public static MathNodes.ATanHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ATanHNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        public static final class ATanHNodeGen
        extends MathNodes.ATanHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ATanHNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ATanHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ATanHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ATanHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ATanHNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ATanHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ATanHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ATanHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ATanHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ATanHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ATanHNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ATanHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ATanHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ATanHNodeGen root;

                BaseNode_(ATanHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATan2Node.class)
    public static final class ATan2NodeFactory
    extends NodeFactoryBase<MathNodes.ATan2Node> {
        private static ATan2NodeFactory aTan2NodeFactoryInstance;

        private ATan2NodeFactory() {
            super(MathNodes.ATan2Node.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ATan2Node createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ATan2NodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ATan2Node> getInstance() {
            if (aTan2NodeFactoryInstance == null) {
                aTan2NodeFactoryInstance = new ATan2NodeFactory();
            }
            return aTan2NodeFactoryInstance;
        }

        public static MathNodes.ATan2Node create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ATan2NodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        public static final class ATan2NodeGen
        extends MathNodes.ATan2Node
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ATan2NodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.ATan2Node.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ATan2NodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.ATan2Node.class)
            private static final class Function15Node_
            extends BaseNode_ {
                Function15Node_(ATan2NodeGen root) {
                    super(root, 16);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function15Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, RubyBasicObject)", value=MathNodes.ATan2Node.class)
            private static final class Function14Node_
            extends BaseNode_ {
                Function14Node_(ATan2NodeGen root) {
                    super(root, 15);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof RubyBasicObject) {
                        double arguments0Value_ = (Double)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function14Node_(root);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.ATan2Node.class)
            private static final class Function13Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function13Node_(ATan2NodeGen root, Object arguments1Value) {
                    super(root, 14);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function13Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = (Double)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments1Value) {
                    return new Function13Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.ATan2Node.class)
            private static final class Function12Node_
            extends BaseNode_ {
                Function12Node_(ATan2NodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Double && arguments1Value instanceof Integer) {
                        double arguments0Value_ = (Double)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function12Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, double)", value=MathNodes.ATan2Node.class)
            private static final class Function11Node_
            extends BaseNode_ {
                Function11Node_(ATan2NodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function11Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, RubyBasicObject)", value=MathNodes.ATan2Node.class)
            private static final class Function10Node_
            extends BaseNode_ {
                Function10Node_(ATan2NodeGen root) {
                    super(root, 11);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function10Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, long)", value=MathNodes.ATan2Node.class)
            private static final class Function9Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function9Node_(ATan2NodeGen root, Object arguments1Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function9Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments1Value) {
                    return new Function9Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject, int)", value=MathNodes.ATan2Node.class)
            private static final class Function8Node_
            extends BaseNode_ {
                Function8Node_(ATan2NodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function8Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.ATan2Node.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function7Node_(ATan2NodeGen root, Object arguments0Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function7Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Double) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value) {
                    return new Function7Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, RubyBasicObject)", value=MathNodes.ATan2Node.class)
            private static final class Function6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function6Node_(ATan2NodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof RubyBasicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value) {
                    return new Function6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.ATan2Node.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function5Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function5Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function5Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.ATan2Node.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function4Node_(ATan2NodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof Integer) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value) {
                    return new Function4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.ATan2Node.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ATan2NodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Double) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, RubyBasicObject)", value=MathNodes.ATan2Node.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ATan2NodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof RubyBasicObject) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.ATan2Node.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function1Node_(ATan2NodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments1Value) {
                    return new Function1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.ATan2Node.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ATan2NodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATan2Node.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ATan2NodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATan2Node.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ATan2NodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATan2Node.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ATan2NodeGen root;

                BaseNode_(ATan2NodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments0Value instanceof Integer) {
                        if (arguments1Value instanceof Integer) {
                            return Function0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Function2Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function3Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (arguments1Value instanceof Integer) {
                            return Function4Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function5Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function6Node_.create(this.root, arguments0Value);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function7Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (arguments1Value instanceof Integer && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function9Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_2 = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_2)) {
                                return Function10Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof Double && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function11Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof Double) {
                        if (arguments1Value instanceof Integer) {
                            return Function12Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function13Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Function14Node_.create(this.root);
                        }
                        if (arguments1Value instanceof Double) {
                            return Function15Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATanNode.class)
    public static final class ATanNodeFactory
    extends NodeFactoryBase<MathNodes.ATanNode> {
        private static ATanNodeFactory aTanNodeFactoryInstance;

        private ATanNodeFactory() {
            super(MathNodes.ATanNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ATanNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ATanNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ATanNode> getInstance() {
            if (aTanNodeFactoryInstance == null) {
                aTanNodeFactoryInstance = new ATanNodeFactory();
            }
            return aTanNodeFactoryInstance;
        }

        public static MathNodes.ATanNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ATanNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        public static final class ATanNodeGen
        extends MathNodes.ATanNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ATanNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ATanNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ATanNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ATanNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ATanNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ATanNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ATanNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ATanNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ATanNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ATanNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ATanNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ATanNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ATanNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ATanNodeGen root;

                BaseNode_(ATanNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ASinHNode.class)
    public static final class ASinHNodeFactory
    extends NodeFactoryBase<MathNodes.ASinHNode> {
        private static ASinHNodeFactory aSinHNodeFactoryInstance;

        private ASinHNodeFactory() {
            super(MathNodes.ASinHNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ASinHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ASinHNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ASinHNode> getInstance() {
            if (aSinHNodeFactoryInstance == null) {
                aSinHNodeFactoryInstance = new ASinHNodeFactory();
            }
            return aSinHNodeFactoryInstance;
        }

        public static MathNodes.ASinHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ASinHNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        public static final class ASinHNodeGen
        extends MathNodes.ASinHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ASinHNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ASinHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ASinHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ASinHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ASinHNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ASinHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ASinHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ASinHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ASinHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ASinHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ASinHNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ASinHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ASinHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ASinHNodeGen root;

                BaseNode_(ASinHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ASinNode.class)
    public static final class ASinNodeFactory
    extends NodeFactoryBase<MathNodes.ASinNode> {
        private static ASinNodeFactory aSinNodeFactoryInstance;

        private ASinNodeFactory() {
            super(MathNodes.ASinNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ASinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ASinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ASinNode> getInstance() {
            if (aSinNodeFactoryInstance == null) {
                aSinNodeFactoryInstance = new ASinNodeFactory();
            }
            return aSinNodeFactoryInstance;
        }

        public static MathNodes.ASinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ASinNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        public static final class ASinNodeGen
        extends MathNodes.ASinNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ASinNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ASinNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ASinNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ASinNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ASinNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ASinNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ASinNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ASinNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ASinNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ASinNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ASinNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ASinNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ASinNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ASinNodeGen root;

                BaseNode_(ASinNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ACosHNode.class)
    public static final class ACosHNodeFactory
    extends NodeFactoryBase<MathNodes.ACosHNode> {
        private static ACosHNodeFactory aCosHNodeFactoryInstance;

        private ACosHNodeFactory() {
            super(MathNodes.ACosHNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ACosHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ACosHNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ACosHNode> getInstance() {
            if (aCosHNodeFactoryInstance == null) {
                aCosHNodeFactoryInstance = new ACosHNodeFactory();
            }
            return aCosHNodeFactoryInstance;
        }

        public static MathNodes.ACosHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ACosHNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        public static final class ACosHNodeGen
        extends MathNodes.ACosHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ACosHNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ACosHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ACosHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ACosHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ACosHNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ACosHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ACosHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ACosHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ACosHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ACosHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ACosHNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ACosHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ACosHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ACosHNodeGen root;

                BaseNode_(ACosHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ACosNode.class)
    public static final class ACosNodeFactory
    extends NodeFactoryBase<MathNodes.ACosNode> {
        private static ACosNodeFactory aCosNodeFactoryInstance;

        private ACosNodeFactory() {
            super(MathNodes.ACosNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MathNodes.ACosNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ACosNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ACosNode> getInstance() {
            if (aCosNodeFactoryInstance == null) {
                aCosNodeFactoryInstance = new ACosNodeFactory();
            }
            return aCosNodeFactoryInstance;
        }

        public static MathNodes.ACosNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ACosNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        public static final class ACosNodeGen
        extends MathNodes.ACosNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ACosNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ACosNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ACosNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ACosNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                Function3Node_(ACosNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new Function3Node_(root);
                }
            }

            @GeneratedBy(methodName="function(RubyBasicObject)", value=MathNodes.ACosNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ACosNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ACosNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ACosNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeDouble_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ACosNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                Function0Node_(ACosNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new Function0Node_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ACosNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ACosNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ACosNodeGen root;

                BaseNode_(ACosNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return Function0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Double) {
                        return Function3Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }
}

