/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.ThreadLocalObject;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="Binding")
public abstract class BindingNodes {
    public static RubyBasicObject createRubyBinding(RubyClass bindingClass) {
        return BindingNodes.createRubyBinding(bindingClass, null, null);
    }

    public static RubyBasicObject createRubyBinding(RubyClass bindingClass, Object self, MaterializedFrame frame) {
        return new RubyBinding(bindingClass, self, frame);
    }

    public static void setSelfAndFrame(RubyBasicObject binding, Object self, MaterializedFrame frame) {
        ((RubyBinding)binding).self = self;
        ((RubyBinding)binding).frame = frame;
    }

    public static Object getSelf(RubyBasicObject binding) {
        return ((RubyBinding)binding).self;
    }

    public static MaterializedFrame getFrame(RubyBasicObject binding) {
        return ((RubyBinding)binding).frame;
    }

    @CoreMethod(names={"local_variables"})
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject localVariables(RubyBasicObject binding) {
            RubyBasicObject array = this.createEmptyArray();
            MaterializedFrame frame = BindingNodes.getFrame(binding);
            while (frame != null) {
                for (Object name : frame.getFrameDescriptor().getIdentifiers()) {
                    if (!(name instanceof String)) continue;
                    ArrayNodes.slowPush(array, this.getSymbol((String)name));
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return array;
        }
    }

    @CoreMethod(names={"local_variable_set"}, required=2)
    public static abstract class LocalVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        private final RubyBasicObject dollarUnderscore = this.getSymbol("$_");

        public LocalVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)", "getFrameDescriptor(binding) == cachedFrameDescriptor", "symbol == cachedSymbol"})
        public Object localVariableSetCached(RubyBasicObject binding, RubyBasicObject symbol, Object value, @Cached(value="symbol") RubyBasicObject cachedSymbol, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="createWriteNode(findFrameSlot(binding, symbol))") WriteFrameSlotNode writeLocalVariableNode) {
            return writeLocalVariableNode.executeWrite((Frame)BindingNodes.getFrame(binding), value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)"})
        public Object localVariableSetUncached(RubyBasicObject binding, RubyBasicObject symbol, Object value) {
            MaterializedFrame frame = BindingNodes.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)SymbolNodes.getString(symbol));
            frame.setObject(frameSlot, value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "isLastLine(symbol)"})
        public Object localVariableSetLastLine(RubyBasicObject binding, RubyBasicObject symbol, Object value) {
            MaterializedFrame frame = BindingNodes.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)SymbolNodes.getString(symbol));
            frame.setObject(frameSlot, (Object)ThreadLocalObject.wrap(this.getContext(), value));
            return value;
        }

        protected FrameDescriptor getFrameDescriptor(RubyBasicObject binding) {
            assert (RubyGuards.isRubyBinding(binding));
            return BindingNodes.getFrame(binding).getFrameDescriptor();
        }

        protected FrameSlot findFrameSlot(RubyBasicObject binding, RubyBasicObject symbol) {
            assert (RubyGuards.isRubyBinding(binding));
            assert (RubyGuards.isRubySymbol(symbol));
            String symbolString = SymbolNodes.getString(symbol);
            MaterializedFrame frame = BindingNodes.getFrame(binding);
            while (frame != null) {
                FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbolString);
                if (frameSlot != null) {
                    return frameSlot;
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return BindingNodes.getFrame(binding).getFrameDescriptor().addFrameSlot((Object)symbolString);
        }

        protected WriteFrameSlotNode createWriteNode(FrameSlot frameSlot) {
            return WriteFrameSlotNodeGen.create(frameSlot);
        }

        protected boolean isLastLine(RubyBasicObject symbol) {
            return symbol == this.dollarUnderscore;
        }
    }

    @CoreMethod(names={"local_variable_get"}, required=1)
    public static abstract class LocalVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        private final RubyBasicObject dollarUnderscore = this.getSymbol("$_");

        public LocalVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "symbol == cachedSymbol", "!isLastLine(cachedSymbol)", "getFrameDescriptor(binding) == cachedFrameDescriptor"})
        public Object localVariableGetCached(RubyBasicObject binding, RubyBasicObject symbol, @Cached(value="symbol") RubyBasicObject cachedSymbol, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="findFrameSlot(binding, symbol)") FrameSlot cachedFrameSlot, @Cached(value="createReadNode(cachedFrameSlot)") ReadFrameSlotNode readLocalVariableNode) {
            if (cachedFrameSlot == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(SymbolNodes.getString(symbol), binding, this));
            }
            return readLocalVariableNode.executeRead((Frame)BindingNodes.getFrame(binding));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)"})
        public Object localVariableGetUncached(RubyBasicObject binding, RubyBasicObject symbol) {
            MaterializedFrame frame = BindingNodes.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)SymbolNodes.getString(symbol));
            if (frameSlot == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(SymbolNodes.getString(symbol), binding, this));
            }
            return frame.getValue(frameSlot);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "isLastLine(symbol)"})
        public Object localVariableGetLastLine(RubyBasicObject binding, RubyBasicObject symbol) {
            MaterializedFrame frame = BindingNodes.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)SymbolNodes.getString(symbol));
            if (frameSlot == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(SymbolNodes.getString(symbol), binding, this));
            }
            Object value = frame.getValue(frameSlot);
            if (value instanceof ThreadLocalObject) {
                return ((ThreadLocalObject)value).get();
            }
            return value;
        }

        protected FrameDescriptor getFrameDescriptor(RubyBasicObject binding) {
            assert (RubyGuards.isRubyBinding(binding));
            return BindingNodes.getFrame(binding).getFrameDescriptor();
        }

        protected FrameSlot findFrameSlot(RubyBasicObject binding, RubyBasicObject symbol) {
            assert (RubyGuards.isRubyBinding(binding));
            assert (RubyGuards.isRubySymbol(symbol));
            String symbolString = SymbolNodes.getString(symbol);
            MaterializedFrame frame = BindingNodes.getFrame(binding);
            while (frame != null) {
                FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbolString);
                if (frameSlot != null) {
                    return frameSlot;
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return null;
        }

        protected ReadFrameSlotNode createReadNode(FrameSlot frameSlot) {
            if (frameSlot == null) {
                return null;
            }
            return ReadFrameSlotNodeGen.create(frameSlot);
        }

        protected boolean isLastLine(RubyBasicObject symbol) {
            return symbol == this.dollarUnderscore;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyBinding(from)"})
        public Object initializeCopy(RubyBasicObject self, RubyBasicObject from) {
            if (self == from) {
                return self;
            }
            Object[] arguments = BindingNodes.getFrame(from).getArguments();
            InternalMethod method = RubyArguments.getMethod(arguments);
            Object boundSelf = RubyArguments.getSelf(arguments);
            RubyBasicObject boundBlock = RubyArguments.getBlock(arguments);
            Object[] userArguments = RubyArguments.extractUserArguments(arguments);
            Object[] copiedArguments = RubyArguments.pack(method, BindingNodes.getFrame(from), boundSelf, boundBlock, userArguments);
            MaterializedFrame copiedFrame = Truffle.getRuntime().createMaterializedFrame(copiedArguments);
            BindingNodes.setSelfAndFrame(self, BindingNodes.getSelf(from), copiedFrame);
            return self;
        }
    }
}

