/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToStrNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toStrNode;

    public ToStrNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toStrNode = DispatchHeadNodeFactory.createMethodCall(context);
    }

    public abstract RubyBasicObject executeToStr(VirtualFrame var1, Object var2);

    @Specialization(guards={"isRubyString(string)"})
    public RubyBasicObject coerceRubyString(RubyBasicObject string) {
        return string;
    }

    @Specialization(guards={"!isRubyString(object)"})
    public RubyBasicObject coerceObject(VirtualFrame frame, Object object) {
        Object coerced;
        try {
            coerced = this.toStrNode.call(frame, object, "to_str", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (e.getRubyException().getLogicalClass() == this.getContext().getCoreLibrary().getNoMethodErrorClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(object, "String", this));
            }
            throw e;
        }
        if (RubyGuards.isRubyString(coerced)) {
            return (RubyBasicObject)coerced;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorBadCoercion(object, "String", "to_str", coerced, this));
    }
}

