/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;
import org.jruby.Ruby;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RegexpSupport;
import org.jruby.util.StringSupport;

public class RubyRegexp
extends RubyBasicObject {
    @CompilerDirectives.CompilationFinal
    private Regex regex;
    @CompilerDirectives.CompilationFinal
    private ByteList source;
    @CompilerDirectives.CompilationFinal
    private RegexpOptions options = RegexpOptions.NULL_OPTIONS;
    private Object cachedNames;

    public RubyRegexp(RubyClass regexpClass) {
        super(regexpClass);
    }

    public RubyRegexp(Node currentNode, RubyClass regexpClass, ByteList regex, RegexpOptions options) {
        this(regexpClass);
        this.options = options;
        this.initialize(RubyRegexp.compile(currentNode, this.getContext(), regex, options), regex);
    }

    public RubyRegexp(Node currentNode, RubyClass regexpClass, ByteList regex, int options) {
        this(regexpClass);
        this.options = RegexpOptions.fromEmbeddedOptions((int)options);
        this.initialize(RubyRegexp.compile(currentNode, this.getContext(), regex, this.options), regex);
    }

    public RubyRegexp(RubyClass regexpClass, Regex regex, ByteList source, RegexpOptions options) {
        this(regexpClass);
        this.options = options;
        this.initialize(regex, source);
    }

    public RubyRegexp(RubyClass regexpClass, Regex regex, ByteList source) {
        this(regexpClass);
        this.initialize(regex, source);
    }

    public void initialize(Node currentNode, ByteList setSource, int options) {
        this.source = setSource;
        this.options = RegexpOptions.fromEmbeddedOptions((int)options);
        this.regex = RubyRegexp.compile(currentNode, this.getContext(), setSource, this.options);
    }

    public void initialize(Regex setRegex, ByteList setSource) {
        this.regex = setRegex;
        this.source = setSource;
    }

    public Regex getRegex() {
        return this.regex;
    }

    public ByteList getSource() {
        return this.source;
    }

    public RegexpOptions getOptions() {
        return this.options;
    }

    @CompilerDirectives.TruffleBoundary
    public Object matchCommon(RubyString source, boolean operator, boolean setNamedCaptures) {
        return this.matchCommon(source, operator, setNamedCaptures, 0);
    }

    @CompilerDirectives.TruffleBoundary
    public Object matchCommon(RubyString source, boolean operator, boolean setNamedCaptures, int startPos) {
        byte[] stringBytes = StringNodes.getByteList(source).bytes();
        ByteList bl = this.getSource();
        Encoding enc = this.checkEncoding(StringNodes.getCodeRangeable(source), true);
        ByteList preprocessed = RegexpSupport.preprocess((Ruby)this.getContext().getRuntime(), (ByteList)bl, (Encoding)enc, (Encoding[])new Encoding[]{null}, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
        Regex r = new Regex(preprocessed.getUnsafeBytes(), preprocessed.getBegin(), preprocessed.getBegin() + preprocessed.getRealSize(), this.options.toJoniOptions(), this.checkEncoding(StringNodes.getCodeRangeable(source), true));
        Matcher matcher = r.matcher(stringBytes);
        int range = stringBytes.length;
        return this.matchCommon(source, operator, setNamedCaptures, matcher, startPos, range);
    }

    @CompilerDirectives.TruffleBoundary
    public Object matchCommon(RubyString source, boolean operator, boolean setNamedCaptures, Matcher matcher, int startPos, int range) {
        ByteList bytes = StringNodes.getByteList(source);
        RubyContext context = this.getContext();
        Frame frame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
        int match = matcher.search(startPos, range, 0);
        RubyBasicObject nil = this.getContext().getCoreLibrary().getNilObject();
        if (match == -1) {
            this.setThread("$~", nil);
            if (setNamedCaptures && this.regex.numberOfNames() > 0) {
                Iterator i = this.regex.namedBackrefIterator();
                while (i.hasNext()) {
                    NameEntry e = (NameEntry)i.next();
                    String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                    this.setFrame(frame, name, this.getContext().getCoreLibrary().getNilObject());
                }
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
        Region region = matcher.getEagerRegion();
        Object[] values = new Object[region.numRegs];
        for (int n = 0; n < region.numRegs; ++n) {
            int start = region.beg[n];
            int end = region.end[n];
            if (operator) {
                RubyBasicObject groupString = start > -1 && end > -1 ? this.makeString(source, start, end - start) : this.getContext().getCoreLibrary().getNilObject();
                values[n] = groupString;
                continue;
            }
            values[n] = start == -1 || end == -1 ? this.getContext().getCoreLibrary().getNilObject() : this.makeString(source, start, end - start);
        }
        RubyBasicObject pre = this.makeString(source, 0, region.beg[0]);
        RubyBasicObject post = this.makeString(source, region.end[0], bytes.length() - region.end[0]);
        RubyBasicObject global = this.makeString(source, region.beg[0], region.end[0] - region.beg[0]);
        RubyMatchData matchObject = new RubyMatchData(context.getCoreLibrary().getMatchDataClass(), source, this, region, values, pre, post, global, matcher.getBegin(), matcher.getEnd());
        if (operator && values.length > 0) {
            int nonNil = values.length - 1;
            while (values[nonNil] == this.getContext().getCoreLibrary().getNilObject()) {
                --nonNil;
            }
        }
        this.setThread("$~", matchObject);
        if (setNamedCaptures && this.regex.numberOfNames() > 0) {
            Iterator i = this.regex.namedBackrefIterator();
            while (i.hasNext()) {
                RubyBasicObject value;
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                int nth = this.regex.nameToBackrefNumber(e.name, e.nameP, e.nameEnd, region);
                if (nth >= region.numRegs || nth < 0 && (nth += region.numRegs) <= 0) {
                    value = this.getContext().getCoreLibrary().getNilObject();
                } else {
                    int start = region.beg[nth];
                    int end = region.end[nth];
                    value = start != -1 ? this.makeString(source, start, end - start) : this.getContext().getCoreLibrary().getNilObject();
                }
                this.setFrame(frame, name, value);
            }
        }
        if (operator) {
            return matcher.getBegin();
        }
        return matchObject;
    }

    private RubyBasicObject makeString(RubyString source, int start, int length) {
        ByteList bytes = new ByteList(StringNodes.getByteList(source), start, length);
        RubyBasicObject ret = StringNodes.createString(source.getLogicalClass(), bytes);
        StringNodes.setCodeRange(ret, StringNodes.getCodeRange(source));
        return ret;
    }

    private void setFrame(Frame frame, String name, Object value) {
        assert (value != null);
        while (frame != null) {
            FrameSlot slot = frame.getFrameDescriptor().findFrameSlot((Object)name);
            if (slot != null) {
                frame.setObject(slot, value);
                break;
            }
            frame = RubyArguments.getDeclarationFrame(frame.getArguments());
        }
    }

    public void setThread(String name, Object value) {
        assert (value != null);
        RubyRegexp.setInstanceVariable(this.getContext().getThreadManager().getCurrentThread().getThreadLocals(), name, value);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBasicObject gsub(RubyString string, String replacement) {
        RubyContext context = this.getContext();
        byte[] stringBytes = StringNodes.getByteList(string).bytes();
        Encoding encoding = StringNodes.getByteList(string).getEncoding();
        Matcher matcher = this.regex.matcher(stringBytes);
        int p = StringNodes.getByteList(string).getBegin();
        int end = 0;
        int range = p + StringNodes.getByteList(string).getRealSize();
        int lastMatchEnd = 0;
        int matchedStringIndex = 0;
        StringBuilder builder = new StringBuilder();
        while (true) {
            Object matchData;
            if ((matchData = this.matchCommon(string, false, false, matcher, p + end, range)) == context.getCoreLibrary().getNilObject()) break;
            Region region = matcher.getEagerRegion();
            int regionStart = region.beg[matchedStringIndex];
            int regionEnd = region.end[matchedStringIndex];
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, regionStart - lastMatchEnd)));
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(replacement.getBytes(StandardCharsets.UTF_8))));
            lastMatchEnd = regionEnd;
            end = StringSupport.positionEndForScan((ByteList)StringNodes.getByteList(string), (Matcher)matcher, (Encoding)encoding, (int)p, (int)range);
        }
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, range - lastMatchEnd)));
        return StringNodes.createString(context.getCoreLibrary().getStringClass(), builder.toString());
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBasicObject sub(String string, String replacement) {
        RubyContext context = this.getContext();
        byte[] stringBytes = string.getBytes(StandardCharsets.UTF_8);
        Matcher matcher = this.regex.matcher(stringBytes);
        int match = matcher.search(0, stringBytes.length, 0);
        if (match == -1) {
            return StringNodes.createString(context.getCoreLibrary().getStringClass(), string);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, 0, matcher.getBegin())));
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(replacement.getBytes(StandardCharsets.UTF_8))));
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, matcher.getEnd(), stringBytes.length - matcher.getEnd())));
        return StringNodes.createString(context.getCoreLibrary().getStringClass(), builder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    @CompilerDirectives.TruffleBoundary
    public RubyBasicObject[] split(RubyString string, boolean useLimit, int limit) {
        RubyContext context = this.getContext();
        ByteList bytes = StringNodes.getByteList(string);
        byte[] byteArray = bytes.bytes();
        int begin = bytes.getBegin();
        int len = bytes.getRealSize();
        int range = begin + len;
        Encoding encoding = StringNodes.getByteList(string).getEncoding();
        Matcher matcher = this.regex.matcher(byteArray);
        ArrayList<RubyBasicObject> strings = new ArrayList<RubyBasicObject>();
        int beg = 0;
        int i = 1;
        boolean lastNull = false;
        int start = begin;
        if (useLimit && limit == 1) {
            strings.add(string);
        } else {
            int end;
            while ((end = matcher.search(start, range, 0)) >= 0) {
                block10: {
                    if (start == end + begin && matcher.getBegin() == matcher.getEnd()) {
                        if (len == 0) {
                            strings.add(StringNodes.createString(context.getCoreLibrary().getStringClass(), ""));
                            break;
                        }
                        if (lastNull) {
                            int substringLength = StringSupport.length((Encoding)encoding, (byte[])byteArray, (int)(begin + beg), (int)range);
                            strings.add(StringNodes.createString(context.getCoreLibrary().getStringClass(), bytes.makeShared(beg, substringLength).dup()));
                            beg = start - begin;
                            break block10;
                        } else {
                            start += start == range ? 1 : StringSupport.length((Encoding)encoding, (byte[])byteArray, (int)start, (int)range);
                            lastNull = true;
                            continue;
                        }
                    }
                    strings.add(StringNodes.createString(context.getCoreLibrary().getStringClass(), bytes.makeShared(beg, end - beg).dup()));
                    beg = matcher.getEnd();
                    start = begin + beg;
                }
                lastNull = false;
                if (!useLimit || limit > ++i) continue;
            }
            if (len > 0 && (useLimit || len > beg || limit < 0)) {
                strings.add(StringNodes.createString(context.getCoreLibrary().getStringClass(), bytes.makeShared(beg, len - beg).dup()));
            }
        }
        if (!useLimit && limit == 0) {
            while (!strings.isEmpty() && StringNodes.length((RubyBasicObject)strings.get(strings.size() - 1)) == 0) {
                strings.remove(strings.size() - 1);
            }
        }
        return strings.toArray(new RubyString[strings.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    public Object scan(RubyString string) {
        Object matchData;
        RubyContext context = this.getContext();
        byte[] stringBytes = StringNodes.getByteList(string).bytes();
        Encoding encoding = StringNodes.getByteList(string).getEncoding();
        Matcher matcher = this.regex.matcher(stringBytes);
        int p = StringNodes.getByteList(string).getBegin();
        int end = 0;
        int range = p + StringNodes.getByteList(string).getRealSize();
        Object lastGoodMatchData = this.getContext().getCoreLibrary().getNilObject();
        if (this.regex.numberOfCaptures() == 0) {
            Object matchData2;
            ArrayList<RubyString> strings = new ArrayList<RubyString>();
            while ((matchData2 = this.matchCommon(string, false, true, matcher, p + end, range)) != context.getCoreLibrary().getNilObject()) {
                RubyMatchData md = (RubyMatchData)matchData2;
                Object[] values = md.getValues();
                assert (values.length == 1);
                strings.add((RubyString)values[0]);
                lastGoodMatchData = matchData2;
                end = StringSupport.positionEndForScan((ByteList)StringNodes.getByteList(string), (Matcher)matcher, (Encoding)encoding, (int)p, (int)range);
            }
            this.setThread("$~", lastGoodMatchData);
            return strings.toArray(new RubyString[strings.size()]);
        }
        ArrayList<RubyBasicObject> allMatches = new ArrayList<RubyBasicObject>();
        while ((matchData = this.matchCommon(string, false, true, matcher, p + end, stringBytes.length)) != context.getCoreLibrary().getNilObject()) {
            Object[] captures = ((RubyMatchData)matchData).getCaptures();
            allMatches.add(ArrayNodes.createArray(context.getCoreLibrary().getArrayClass(), captures, captures.length));
            lastGoodMatchData = matchData;
            end = StringSupport.positionEndForScan((ByteList)StringNodes.getByteList(string), (Matcher)matcher, (Encoding)encoding, (int)p, (int)range);
        }
        this.setThread("$~", lastGoodMatchData);
        return allMatches.toArray(new Object[allMatches.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    public static Regex compile(Node currentNode, RubyContext context, ByteList bytes, RegexpOptions options) {
        try {
            Encoding enc = bytes.getEncoding();
            Encoding[] fixedEnc = new Encoding[]{null};
            ByteList unescaped = RegexpSupport.preprocess((Ruby)context.getRuntime(), (ByteList)bytes, (Encoding)enc, (Encoding[])fixedEnc, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            if (fixedEnc[0] != null) {
                if (fixedEnc[0] != enc && options.isFixed() || fixedEnc[0] != ASCIIEncoding.INSTANCE && options.isEncodingNone()) {
                    RegexpSupport.raiseRegexpError19((Ruby)context.getRuntime(), (ByteList)bytes, (Encoding)enc, (RegexpOptions)options, (String)"incompatible character encoding");
                }
                if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                    options.setFixed(true);
                    enc = fixedEnc[0];
                }
            } else if (!options.isFixed()) {
                enc = USASCIIEncoding.INSTANCE;
            }
            if (fixedEnc[0] != null) {
                options.setFixed(true);
            }
            bytes.setEncoding(enc);
            Regex ret = new Regex(unescaped.getUnsafeBytes(), unescaped.getBegin(), unescaped.getBegin() + unescaped.getRealSize(), options.toJoniOptions(), enc, Syntax.RUBY);
            ret.setUserObject((Object)bytes);
            return ret;
        }
        catch (ValueException e) {
            throw new RaiseException(context.getCoreLibrary().runtimeError("error compiling regex", currentNode));
        }
        catch (SyntaxException e) {
            throw new RaiseException(context.getCoreLibrary().regexpError(e.getMessage(), currentNode));
        }
    }

    public Object getCachedNames() {
        return this.cachedNames;
    }

    public void setCachedNames(Object cachedNames) {
        this.cachedNames = cachedNames;
    }

    public Encoding checkEncoding(CodeRangeable str, boolean warn) {
        Regex pattern = this.regex;
        Encoding enc = str.getByteList().getEncoding();
        if (!enc.isAsciiCompatible()) {
            if (enc != pattern.getEncoding()) {
                // empty if block
            }
        } else if (this.options.isFixed()) {
            enc = pattern.getEncoding();
        }
        return enc;
    }

    public static class RegexpAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyRegexp(rubyClass);
        }
    }
}

