/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.joni.Region;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.StringCodeRangeableWrapper;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;

public class RubyMatchData
extends RubyBasicObject {
    private final RubyBasicObject source;
    private final RubyRegexp regexp;
    private final Region region;
    private final Object[] values;
    private final RubyBasicObject pre;
    private final RubyBasicObject post;
    private final RubyBasicObject global;
    boolean charOffsetUpdated;
    Region charOffsets;
    private final int begin;
    private final int end;
    private Object fullTuple;

    public RubyMatchData(RubyClass rubyClass, RubyBasicObject source, RubyRegexp regexp, Region region, Object[] values, RubyBasicObject pre, RubyBasicObject post, RubyBasicObject global, int begin, int end) {
        super(rubyClass);
        this.source = source;
        this.regexp = regexp;
        this.region = region;
        this.values = values;
        this.pre = pre;
        this.post = post;
        this.global = global;
        this.begin = begin;
        this.end = end;
    }

    public Object[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public Object[] getCaptures() {
        return ArrayUtils.extractRange(this.values, 1, this.values.length);
    }

    public Object begin(int index) {
        int b;
        int n = b = this.region == null ? this.begin : this.region.beg[index];
        if (b < 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        this.updateCharOffset();
        return this.charOffsets.beg[index];
    }

    public Object end(int index) {
        int e;
        int n = e = this.region == null ? this.end : this.region.end[index];
        if (e < 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        StringCodeRangeableWrapper sourceWrapped = StringNodes.getCodeRangeable(this.source);
        if (!StringSupport.isSingleByteOptimizable((CodeRangeable)sourceWrapped, (Encoding)sourceWrapped.getByteList().getEncoding())) {
            this.updateCharOffset();
            e = this.charOffsets.end[index];
        }
        return e;
    }

    public int getNumberOfRegions() {
        return this.region.numRegs;
    }

    public int getBackrefNumber(ByteList value) {
        return this.regexp.getRegex().nameToBackrefNumber(value.getUnsafeBytes(), value.getBegin(), value.getBegin() + value.getRealSize(), this.region);
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (Object object : this.values) {
            if (!(object instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)object).visitObjectGraph(visitor);
        }
    }

    public RubyBasicObject getPre() {
        return this.pre;
    }

    public RubyBasicObject getPost() {
        return this.post;
    }

    public RubyBasicObject getGlobal() {
        return this.global;
    }

    public Region getRegion() {
        return this.region;
    }

    public RubyBasicObject getSource() {
        return this.source;
    }

    public RubyBasicObject getRegexp() {
        return this.regexp;
    }

    public Object getFullTuple() {
        return this.fullTuple;
    }

    public void setFullTuple(Object fullTuple) {
        this.fullTuple = fullTuple;
    }

    public int getFullBegin() {
        return this.begin;
    }

    public int getFullEnd() {
        return this.end;
    }

    private void updatePairs(ByteList value, Encoding encoding, Pair[] pairs) {
        int p;
        Arrays.sort(pairs);
        int length = pairs.length;
        byte[] bytes = value.getUnsafeBytes();
        int s = p = value.getBegin();
        int c = 0;
        for (int i = 0; i < length; ++i) {
            int q = s + pairs[i].bytePos;
            pairs[i].charPos = c += StringSupport.strLength((Encoding)encoding, (byte[])bytes, (int)p, (int)q);
            p = q;
        }
    }

    private void updateCharOffsetOnlyOneReg(ByteList value, Encoding encoding) {
        if (this.charOffsetUpdated) {
            return;
        }
        if (this.charOffsets == null || this.charOffsets.numRegs < 1) {
            this.charOffsets = new Region(1);
        }
        if (encoding.maxLength() == 1) {
            this.charOffsets.beg[0] = this.begin;
            this.charOffsets.end[0] = this.end;
            this.charOffsetUpdated = true;
            return;
        }
        Object[] pairs = new Pair[2];
        if (this.begin >= 0) {
            pairs[0] = new Pair();
            pairs[0].bytePos = this.begin;
            pairs[1] = new Pair();
            pairs[1].bytePos = this.end;
        }
        this.updatePairs(value, encoding, (Pair[])pairs);
        if (this.begin < 0) {
            this.charOffsets.end[0] = -1;
            this.charOffsets.beg[0] = -1;
            return;
        }
        Pair key = new Pair();
        key.bytePos = this.begin;
        this.charOffsets.beg[0] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos;
        key.bytePos = this.end;
        this.charOffsets.end[0] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos;
        this.charOffsetUpdated = true;
    }

    private void updateCharOffsetManyRegs(ByteList value, Encoding encoding) {
        if (this.charOffsetUpdated) {
            return;
        }
        Region regs = this.region;
        int numRegs = regs.numRegs;
        if (this.charOffsets == null || this.charOffsets.numRegs < numRegs) {
            this.charOffsets = new Region(numRegs);
        }
        if (encoding.maxLength() == 1) {
            for (int i = 0; i < numRegs; ++i) {
                this.charOffsets.beg[i] = regs.beg[i];
                this.charOffsets.end[i] = regs.end[i];
            }
            this.charOffsetUpdated = true;
            return;
        }
        Object[] pairs = new Pair[numRegs * 2];
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i] = new Pair();
        }
        int numPos = 0;
        for (int i = 0; i < numRegs; ++i) {
            if (regs.beg[i] < 0) continue;
            pairs[numPos++].bytePos = regs.beg[i];
            pairs[numPos++].bytePos = regs.end[i];
        }
        this.updatePairs(value, encoding, (Pair[])pairs);
        Pair key = new Pair();
        for (int i = 0; i < regs.numRegs; ++i) {
            if (regs.beg[i] < 0) {
                this.charOffsets.end[i] = -1;
                this.charOffsets.beg[i] = -1;
                continue;
            }
            key.bytePos = regs.beg[i];
            this.charOffsets.beg[i] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos;
            key.bytePos = regs.end[i];
            this.charOffsets.end[i] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos;
        }
        this.charOffsetUpdated = true;
    }

    private void updateCharOffset() {
        if (this.charOffsetUpdated) {
            return;
        }
        ByteList value = StringNodes.getByteList(this.source);
        Encoding enc = value.getEncoding();
        if (this.region == null) {
            this.updateCharOffsetOnlyOneReg(value, enc);
        } else {
            this.updateCharOffsetManyRegs(value, enc);
        }
        this.charOffsetUpdated = true;
    }

    private static final class Pair
    implements Comparable<Pair> {
        int bytePos;
        int charPos;

        private Pair() {
        }

        @Override
        public int compareTo(Pair pair) {
            return this.bytePos - pair.bytePos;
        }
    }
}

