/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccessFactory;
import com.oracle.truffle.api.interop.InteropPredicate;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.exception.UnsupportedMessageException;
import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.interop.messages.Argument;
import com.oracle.truffle.interop.messages.Execute;
import com.oracle.truffle.interop.messages.GetSize;
import com.oracle.truffle.interop.messages.HasSize;
import com.oracle.truffle.interop.messages.IsBoxed;
import com.oracle.truffle.interop.messages.IsExecutable;
import com.oracle.truffle.interop.messages.IsNull;
import com.oracle.truffle.interop.messages.Read;
import com.oracle.truffle.interop.messages.Receiver;
import com.oracle.truffle.interop.messages.Write;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.interop.InteropNode;
import org.jruby.truffle.runtime.RubyContext;

public class HashForeignAccessFactory
implements ForeignAccessFactory {
    private final RubyContext context;

    public HashForeignAccessFactory(RubyContext context) {
        this.context = context;
    }

    public InteropPredicate getLanguageCheck() {
        return new InteropPredicate(){

            public boolean test(TruffleObject o) {
                return RubyGuards.isRubyHash(o);
            }
        };
    }

    public CallTarget getAccess(Message tree) {
        if (Read.create((Receiver)Receiver.create(), (Argument)Argument.create()).matchStructure((Object)tree)) {
            return Truffle.getRuntime().createCallTarget((RootNode)new RubyInteropRootNode(InteropNode.createRead(this.context, (SourceSection)new NullSourceSection("", ""), (Read)tree)));
        }
        if (Execute.create((Message)Read.create((Receiver)Receiver.create(), (Argument)Argument.create()), (int)0).matchStructure((Object)tree)) {
            return Truffle.getRuntime().createCallTarget((RootNode)new RubyInteropRootNode(InteropNode.createExecuteAfterRead(this.context, (SourceSection)new NullSourceSection("", ""), (Execute)tree)));
        }
        if (Write.create((Receiver)Receiver.create(), (Argument)Argument.create(), (Argument)Argument.create()).matchStructure((Object)tree)) {
            return Truffle.getRuntime().createCallTarget((RootNode)new RubyInteropRootNode(InteropNode.createWrite(this.context, (SourceSection)new NullSourceSection("", ""), (Write)tree)));
        }
        if (IsExecutable.create((Receiver)Receiver.create()).matchStructure((Object)tree)) {
            return Truffle.getRuntime().createCallTarget((RootNode)new RubyInteropRootNode(InteropNode.createIsExecutable(this.context, (SourceSection)new NullSourceSection("", ""))));
        }
        if (IsBoxed.create((Receiver)Receiver.create()).matchStructure((Object)tree)) {
            return Truffle.getRuntime().createCallTarget((RootNode)new RubyInteropRootNode(InteropNode.createIsBoxedPrimitive(this.context, (SourceSection)new NullSourceSection("", ""))));
        }
        if (IsNull.create((Receiver)Receiver.create()).matchStructure((Object)tree)) {
            return Truffle.getRuntime().createCallTarget((RootNode)new RubyInteropRootNode(InteropNode.createIsNull(this.context, (SourceSection)new NullSourceSection("", ""))));
        }
        if (HasSize.create((Receiver)Receiver.create()).matchStructure((Object)tree)) {
            return Truffle.getRuntime().createCallTarget((RootNode)new RubyInteropRootNode(InteropNode.createHasSizePropertyTrue(this.context, (SourceSection)new NullSourceSection("", ""))));
        }
        if (GetSize.create((Receiver)Receiver.create()).matchStructure((Object)tree)) {
            return Truffle.getRuntime().createCallTarget((RootNode)new RubyInteropRootNode(InteropNode.createGetSize(this.context, (SourceSection)new NullSourceSection("", ""))));
        }
        throw new UnsupportedMessageException("Message not supported: " + tree.toString());
    }

    protected static final class RubyInteropRootNode
    extends RootNode {
        @Node.Child
        private RubyNode node;

        public RubyInteropRootNode(RubyNode node) {
            this.node = node;
        }

        public Object execute(VirtualFrame virtualFrame) {
            return this.node.execute(virtualFrame);
        }

        public String toString() {
            return "Root of: " + this.node.toString();
        }
    }
}

