/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import org.jruby.truffle.nodes.yield.YieldDispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.util.cli.Options;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class CachedYieldDispatchNode
extends YieldDispatchNode {
    private static final boolean INLINER_ALWAYS_CLONE_YIELD = (Boolean)Options.TRUFFLE_INLINER_ALWAYS_CLONE_YIELD.load();
    private static final boolean INLINER_ALWAYS_INLINE_YIELD = (Boolean)Options.TRUFFLE_INLINER_ALWAYS_INLINE_YIELD.load();
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private YieldDispatchNode next;

    public CachedYieldDispatchNode(RubyContext context, RubyProc block, YieldDispatchNode next) {
        super(context);
        this.callNode = Truffle.getRuntime().createDirectCallNode(block.getCallTargetForBlocks());
        this.insert((Node)this.callNode);
        if (INLINER_ALWAYS_CLONE_YIELD && this.callNode.isCallTargetCloningAllowed()) {
            this.callNode.cloneCallTarget();
        }
        if (INLINER_ALWAYS_INLINE_YIELD && this.callNode.isInlinable()) {
            this.callNode.forceInlining();
        }
        this.next = next;
    }

    @Override
    protected boolean guard(RubyProc block) {
        return block.getCallTargetForBlocks() == this.callNode.getCallTarget();
    }

    @Override
    protected YieldDispatchNode getNext() {
        return this.next;
    }

    @Override
    public Object dispatchWithSelfAndBlock(VirtualFrame frame, RubyProc block, Object self, RubyProc modifiedBlock, Object ... argumentsObjects) {
        if (this.guard(block)) {
            return this.callNode.call(frame, RubyArguments.pack(block.getMethod(), block.getDeclarationFrame(), self, modifiedBlock, argumentsObjects));
        }
        return this.next.dispatchWithSelfAndBlock(frame, block, self, modifiedBlock, argumentsObjects);
    }

    public String toString() {
        return String.format("CachedYieldDispatchNode(%s)", this.callNode.getCallTarget());
    }
}

