/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.interop.messages.Argument;
import com.oracle.truffle.interop.messages.Execute;
import com.oracle.truffle.interop.messages.Read;
import com.oracle.truffle.interop.messages.Receiver;
import com.oracle.truffle.interop.messages.Write;
import com.oracle.truffle.interop.node.ForeignObjectAccessNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.interop.RubyToIndexLabelNode;
import org.jruby.truffle.nodes.interop.RubyToIndexLabelNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;

public final class CachedForeignDispatchNode
extends CachedDispatchNode {
    private final String name;
    private final String nameForMessage;
    private final int arity;
    @Node.Child
    private ForeignObjectAccessNode directAccess;
    @Node.Child
    private ForeignObjectAccessNode directWrite;
    @Node.Child
    private ForeignObjectAccessNode access;
    @Node.Child
    private PrepareArguments prepareArguments;

    public CachedForeignDispatchNode(RubyContext context, DispatchNode next, Object cachedName, int arity) {
        super(context, cachedName, next, false, DispatchAction.CALL_METHOD);
        this.name = cachedName.toString();
        this.arity = arity;
        this.nameForMessage = this.name.endsWith("=") && arity == 1 ? this.name.substring(0, this.name.length() - 1) : this.name;
        this.initializeNodes(context, arity);
    }

    private void initializeNodes(RubyContext context, int arity) {
        if (this.name.equals("[]")) {
            this.directAccess = ForeignObjectAccessNode.getAccess((Message)Read.create((Receiver)Receiver.create(), (Argument)Argument.create()));
        } else if (this.name.equals("[]=")) {
            this.directAccess = ForeignObjectAccessNode.getAccess((Message)Write.create((Receiver)Receiver.create(), (Argument)Argument.create(), (Argument)Argument.create()));
        } else if (this.name.endsWith("=") && arity == 1) {
            this.directWrite = ForeignObjectAccessNode.getAccess((Message)Write.create((Receiver)Receiver.create(), (Argument)Argument.create(), (Argument)Argument.create()));
        } else {
            this.access = ForeignObjectAccessNode.getAccess((Message)Execute.create((Message)Read.create((Receiver)Receiver.create(), (Argument)Argument.create()), (int)(arity + 1)));
        }
        this.prepareArguments = new PrepareArguments(context, this.getSourceSection(), arity);
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return true;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (receiverObject instanceof TruffleObject) {
            return this.doDispatch(frame, (TruffleObject)receiverObject, argumentsObjects);
        }
        return this.next.executeDispatch(frame, receiverObject, methodName, (RubyProc)blockObject, argumentsObjects);
    }

    private Object doDispatch(VirtualFrame frame, TruffleObject receiverObject, Object argumentsObjects) {
        Object[] arguments = (Object[])argumentsObjects;
        if (arguments.length != this.arity) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException();
        }
        if (this.directAccess != null) {
            Object[] args = this.prepareArguments.convertArguments(frame, arguments, 0);
            return this.directAccess.executeForeign(frame, receiverObject, args);
        }
        if (this.directWrite != null) {
            Object[] args = this.prepareArguments.convertArguments(frame, arguments, 1);
            args[0] = this.nameForMessage;
            return this.directWrite.executeForeign(frame, receiverObject, args);
        }
        if (this.access != null) {
            Object[] args = this.prepareArguments.convertArguments(frame, arguments, 2);
            args[0] = this.name;
            args[1] = receiverObject;
            return this.access.executeForeign(frame, receiverObject, args);
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException();
    }

    private static class PrepareArguments
    extends RubyNode {
        @Node.Children
        private final RubyToIndexLabelNode[] converters;
        private final int arity;

        public PrepareArguments(RubyContext context, SourceSection sourceSection, int arity) {
            super(context, sourceSection);
            this.converters = new RubyToIndexLabelNode[arity];
            this.arity = arity;
            for (int i = 0; i < arity; ++i) {
                this.converters[i] = RubyToIndexLabelNodeGen.create(context, sourceSection, null);
            }
        }

        @ExplodeLoop
        public Object[] convertArguments(VirtualFrame frame, Object[] arguments, int offset) {
            Object[] result = new Object[this.arity + offset];
            for (int i = 0; i < this.arity; ++i) {
                result[i + offset] = this.converters[i].executeWithTarget(frame, arguments[i]);
            }
            return result;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException();
        }
    }
}

