/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jruby.RubyEncoding;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;

@CoreClass(name="Encoding")
public abstract class EncodingNodes {

    @CoreMethod(names={"name", "to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject toS(org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            ByteList name = encoding.getName().dup();
            name.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return this.createString(name);
        }
    }

    @CoreMethod(names={"encoding_map"}, onSingleton=true)
    public static abstract class EncodingMapNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode upcaseNode;
        @Node.Child
        private CallDispatchHeadNode toSymNode;
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;
        @Node.Child
        private CallDispatchHeadNode newTupleNode;

        public EncodingMapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.upcaseNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.toSymNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newTupleNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object encodingMap(VirtualFrame frame) {
            Object ret = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            org.jruby.truffle.runtime.core.RubyEncoding[] encodings = org.jruby.truffle.runtime.core.RubyEncoding.cloneEncodingList();
            for (int i = 0; i < encodings.length; ++i) {
                Object upcased = this.upcaseNode.call(frame, this.createString(encodings[i].getName()), "upcase", null, new Object[0]);
                Object key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                Object value = this.newTupleNode.call(frame, this.getContext().getCoreLibrary().getTupleClass(), "create", null, this.nil(), i);
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i = this.getContext().getRuntime().getEncodingService().getAliases().entryIterator();
            while (i.hasNext()) {
                CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i.next();
                Object upcased = this.upcaseNode.call(frame, this.createString(new ByteList(e.bytes, e.p, e.end - e.p)), "upcase", null, new Object[0]);
                Object key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                RubyBasicObject alias = this.createString(new ByteList(e.bytes, e.p, e.end - e.p));
                int index = ((EncodingDB.Entry)e.value).getIndex();
                Object value = this.newTupleNode.call(frame, this.getContext().getCoreLibrary().getTupleClass(), "create", null, alias, index);
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            Encoding defaultInternalEncoding = this.getContext().getRuntime().getDefaultInternalEncoding();
            Object internalTuple = this.getContext().makeTuple(frame, this.newTupleNode, this.createString("internal"), this.indexLookup(encodings, defaultInternalEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("INTERNAL"), internalTuple);
            Encoding defaultExternalEncoding = this.getContext().getRuntime().getDefaultExternalEncoding();
            Object externalTuple = this.getContext().makeTuple(frame, this.newTupleNode, this.createString("external"), this.indexLookup(encodings, defaultExternalEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("EXTERNAL"), externalTuple);
            Encoding localeEncoding = this.getContext().getRuntime().getEncodingService().getLocaleEncoding();
            Object localeTuple = this.getContext().makeTuple(frame, this.newTupleNode, this.createString("locale"), this.indexLookup(encodings, localeEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("LOCALE"), localeTuple);
            Encoding filesystemEncoding = this.getContext().getRuntime().getEncodingService().getLocaleEncoding();
            Object filesystemTuple = this.getContext().makeTuple(frame, this.newTupleNode, this.createString("filesystem"), this.indexLookup(encodings, filesystemEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("FILESYSTEM"), filesystemTuple);
            return ret;
        }

        @CompilerDirectives.TruffleBoundary
        public Object indexLookup(org.jruby.truffle.runtime.core.RubyEncoding[] encodings, Encoding encoding) {
            if (encoding == null) {
                return this.nil();
            }
            for (int i = 0; i < encodings.length; ++i) {
                if (encodings[i].getEncoding() != encoding) continue;
                return i;
            }
            throw new UnsupportedOperationException(String.format("Could not find encoding %s in the registered encoding list", encoding.toString()));
        }
    }

    @CoreMethod(names={"dummy?"})
    public static abstract class DummyNode
    extends CoreMethodArrayArgumentsNode {
        public DummyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isDummy(org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            CompilerDirectives.transferToInterpreter();
            return encoding.isDummy();
        }
    }

    @CoreMethod(names={"locale_charmap"}, onSingleton=true)
    public static abstract class LocaleCharacterMapNode
    extends CoreMethodArrayArgumentsNode {
        public LocaleCharacterMapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject localeCharacterMap() {
            CompilerDirectives.transferToInterpreter();
            ByteList name = new ByteList(this.getContext().getRuntime().getEncodingService().getLocaleEncoding().getName());
            return this.createString(name);
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        public ListNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject list() {
            CompilerDirectives.transferToInterpreter();
            Object[] encodings = org.jruby.truffle.runtime.core.RubyEncoding.cloneEncodingList();
            return this.createArray(encodings, encodings.length);
        }
    }

    @CoreMethod(names={"default_internal_jruby="}, onSingleton=true, required=1)
    public static abstract class SetDefaultInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        public SetDefaultInternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyEncoding defaultInternal(org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getRuntime().setDefaultInternalEncoding(encoding.getEncoding());
            return encoding;
        }

        @Specialization(guards={"isNil(encoding)"})
        public RubyBasicObject defaultInternal(Object encoding) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getRuntime().setDefaultInternalEncoding(null);
            return this.nil();
        }

        @Specialization(guards={"!isRubyEncoding(encoding)", "!isNil(encoding)"})
        public RubyBasicObject defaultInternal(VirtualFrame frame, Object encoding) {
            CompilerDirectives.transferToInterpreter();
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            RubyString encodingName = this.toStrNode.executeRubyString(frame, encoding);
            this.getContext().getRuntime().setDefaultInternalEncoding(org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(encodingName.toString()).getEncoding());
            return encodingName;
        }
    }

    @CoreMethod(names={"default_external_jruby="}, onSingleton=true, required=1)
    public static abstract class SetDefaultExternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        public SetDefaultExternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyEncoding defaultExternal(org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getRuntime().setDefaultExternalEncoding(encoding.getEncoding());
            return encoding;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyEncoding defaultExternal(RubyString encodingString) {
            CompilerDirectives.transferToInterpreter();
            org.jruby.truffle.runtime.core.RubyEncoding rubyEncoding = org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(encodingString.toString());
            this.getContext().getRuntime().setDefaultExternalEncoding(rubyEncoding.getEncoding());
            return rubyEncoding;
        }

        @Specialization(guards={"isNil(nil)"})
        public org.jruby.truffle.runtime.core.RubyEncoding defaultExternal(Object nil) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("default external can not be nil", this));
        }

        @Specialization(guards={"!isRubyEncoding(encoding)", "!isRubyString(encoding)", "!isNil(encoding)"})
        public org.jruby.truffle.runtime.core.RubyEncoding defaultExternal(VirtualFrame frame, Object encoding) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.defaultExternal(this.toStrNode.executeRubyString(frame, encoding));
        }
    }

    @CoreMethod(names={"compatible?"}, needsSelf=false, onSingleton=true, required=2)
    public static abstract class CompatibleQueryNode
    extends CoreMethodArrayArgumentsNode {
        public CompatibleQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object isCompatible(RubyString first, RubyString second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((CodeRangeable)StringNodes.getCodeRangeable(first), (CodeRangeable)StringNodes.getCodeRangeable(second));
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object isCompatible(org.jruby.truffle.runtime.core.RubyEncoding first, org.jruby.truffle.runtime.core.RubyEncoding second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)first.getEncoding(), (Encoding)second.getEncoding());
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object isCompatible(RubyString first, RubyRegexp second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)StringNodes.getByteList(first).getEncoding(), (Encoding)second.getRegex().getEncoding());
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object isCompatible(RubyRegexp first, RubyString second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)first.getRegex().getEncoding(), (Encoding)StringNodes.getByteList(second).getEncoding());
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object isCompatible(RubyRegexp first, RubyRegexp second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)first.getRegex().getEncoding(), (Encoding)second.getRegex().getEncoding());
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(second)"})
        public Object isCompatible(RubyRegexp first, RubyBasicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)first.getRegex().getEncoding(), (Encoding)SymbolNodes.getByteList(second).getEncoding());
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(first)"})
        public Object isCompatible(RubyBasicObject first, RubyRegexp second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)SymbolNodes.getByteList(first).getEncoding(), (Encoding)second.getRegex().getEncoding());
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(second)"})
        public Object isCompatible(RubyString first, RubyBasicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((CodeRangeable)StringNodes.getCodeRangeable(first), (CodeRangeable)SymbolNodes.getCodeRangeable(second));
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(first)", "isRubySymbol(second)"})
        public Object isCompatible(RubyBasicObject first, RubyBasicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((CodeRangeable)SymbolNodes.getCodeRangeable(first), (CodeRangeable)SymbolNodes.getCodeRangeable(second));
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object isCompatible(RubyString first, org.jruby.truffle.runtime.core.RubyEncoding second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)StringNodes.getByteList(first).getEncoding(), (Encoding)second.getEncoding());
            if (compatibleEncoding != null) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"ascii_compatible?"})
    public static abstract class AsciiCompatibleNode
    extends CoreMethodArrayArgumentsNode {
        public AsciiCompatibleNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object isCompatible(org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            CompilerDirectives.transferToInterpreter();
            return encoding.getEncoding().isAsciiCompatible();
        }
    }
}

