/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.arguments.CheckArityNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadAllArgumentsNode;
import org.jruby.truffle.nodes.arguments.ReadBlockNode;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.RaiseIfFrozenNode;
import org.jruby.truffle.nodes.core.ReturnEnumeratorIfNoBlockNode;
import org.jruby.truffle.nodes.core.fixnum.FixnumLowerNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class CoreMethodNodeManager {
    private final RubyClass objectClass;
    private final SingletonClassNode singletonClassNode;

    public CoreMethodNodeManager(RubyClass objectClass, SingletonClassNode singletonClassNode) {
        this.objectClass = objectClass;
        this.singletonClassNode = singletonClassNode;
    }

    public void addCoreMethodNodes(List<? extends NodeFactory<? extends RubyNode>> nodeFactories) {
        for (NodeFactory<? extends RubyNode> nodeFactory : nodeFactories) {
            GeneratedBy generatedBy = nodeFactory.getClass().getAnnotation(GeneratedBy.class);
            Class nodeClass = generatedBy.value();
            CoreClass classAnnotation = nodeClass.getEnclosingClass().getAnnotation(CoreClass.class);
            CoreMethod methodAnnotation = nodeClass.getAnnotation(CoreMethod.class);
            if (methodAnnotation == null) continue;
            this.addCoreMethod(new MethodDetails(classAnnotation, methodAnnotation, nodeFactory));
        }
    }

    private RubyClass getSingletonClass(Object object) {
        return this.singletonClassNode.executeSingletonClass(null, object);
    }

    private void addCoreMethod(MethodDetails methodDetails) {
        RubyModule module;
        RubyContext context = this.objectClass.getContext();
        String fullName = methodDetails.getClassAnnotation().name();
        if (fullName.equals("main")) {
            module = this.getSingletonClass(context.getCoreLibrary().getMainObject());
        } else {
            module = this.objectClass;
            for (String moduleName : fullName.split("::")) {
                RubyConstant constant = ModuleOperations.lookupConstant(context, LexicalScope.NONE, module, moduleName);
                if (constant == null) {
                    throw new RuntimeException(String.format("Module %s not found when adding core library", moduleName));
                }
                module = (RubyModule)constant.getValue();
            }
        }
        assert (module != null) : fullName;
        CoreMethod method = methodDetails.getMethodAnnotation();
        List<String> names = Arrays.asList(method.names());
        assert (names.size() >= 1);
        Visibility visibility = method.visibility();
        if (method.isModuleFunction()) {
            if (visibility != Visibility.PUBLIC) {
                System.err.println("WARNING: visibility ignored when isModuleFunction in " + methodDetails.getIndicativeName());
            }
            if (method.onSingleton()) {
                System.err.println("WARNING: Either onSingleton or isModuleFunction for " + methodDetails.getIndicativeName());
            }
            if (method.constructor()) {
                System.err.println("WARNING: Either constructor or isModuleFunction for " + methodDetails.getIndicativeName());
            }
            if (!module.isOnlyAModule()) {
                System.err.println("WARNING: Using isModuleFunction on a Class for " + methodDetails.getIndicativeName());
            }
        }
        if (method.onSingleton() && method.constructor()) {
            System.err.println("WARNING: Either onSingleton or isModuleFunction for " + methodDetails.getIndicativeName());
        }
        RubyRootNode rootNode = CoreMethodNodeManager.makeGenericMethod(context, methodDetails);
        if (method.isModuleFunction()) {
            CoreMethodNodeManager.addMethod(module, rootNode, names, Visibility.PRIVATE);
            CoreMethodNodeManager.addMethod(this.getSingletonClass(module), rootNode, names, Visibility.PUBLIC);
        } else if (method.onSingleton() || method.constructor()) {
            CoreMethodNodeManager.addMethod(this.getSingletonClass(module), rootNode, names, visibility);
        } else {
            CoreMethodNodeManager.addMethod(module, rootNode, names, visibility);
        }
    }

    private static void addMethod(RubyModule module, RubyRootNode rootNode, List<String> names, Visibility originalVisibility) {
        for (String name : names) {
            RubyRootNode rootNodeCopy = (RubyRootNode)NodeUtil.cloneNode((Node)rootNode);
            Visibility visibility = originalVisibility;
            if (ModuleOperations.isMethodPrivateFromName(name)) {
                visibility = Visibility.PRIVATE;
            }
            InternalMethod method = new InternalMethod(rootNodeCopy.getSharedMethodInfo(), name, module, visibility, false, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNodeCopy), null);
            module.addMethod(null, method.withVisibility(visibility).withName(name));
        }
    }

    private static RubyRootNode makeGenericMethod(RubyContext context, MethodDetails methodDetails) {
        RubyNode methodNode;
        Object[] args;
        boolean needsSelf;
        CoreMethod method = methodDetails.getMethodAnnotation();
        CoreSourceSection sourceSection = new CoreSourceSection(methodDetails.getClassAnnotation().name(), method.names()[0]);
        int required = method.required();
        int optional = method.argumentsAsArray() ? 0 : method.optional();
        Arity arity = new Arity(required, optional, method.argumentsAsArray(), false, false, 0);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, LexicalScope.NONE, arity, methodDetails.getIndicativeName(), false, null, true);
        ArrayList<RubyNode> argumentsNodes = new ArrayList<RubyNode>();
        boolean bl = needsSelf = method.constructor() || !method.isModuleFunction() && !method.onSingleton() && method.needsSelf();
        if (needsSelf) {
            RubyNode readSelfNode = new SelfNode(context, (SourceSection)sourceSection);
            if (method.lowerFixnumSelf()) {
                readSelfNode = new FixnumLowerNode(readSelfNode);
            }
            if (method.raiseIfFrozenSelf()) {
                readSelfNode = new RaiseIfFrozenNode(readSelfNode);
            }
            argumentsNodes.add(readSelfNode);
        }
        if (method.argumentsAsArray()) {
            argumentsNodes.add(new ReadAllArgumentsNode(context, (SourceSection)sourceSection));
        } else {
            for (int n = 0; n < arity.getRequired() + arity.getOptional(); ++n) {
                RubyNode readArgumentNode = new ReadPreArgumentNode(context, (SourceSection)sourceSection, n, MissingArgumentBehaviour.UNDEFINED);
                if (ArrayUtils.contains(method.lowerFixnumParameters(), n)) {
                    readArgumentNode = new FixnumLowerNode(readArgumentNode);
                }
                if (ArrayUtils.contains(method.raiseIfFrozenParameters(), n)) {
                    readArgumentNode = new RaiseIfFrozenNode(readArgumentNode);
                }
                argumentsNodes.add(readArgumentNode);
            }
        }
        if (method.needsBlock()) {
            argumentsNodes.add(new ReadBlockNode(context, (SourceSection)sourceSection, NotProvided.INSTANCE));
        }
        NodeFactory<? extends RubyNode> nodeFactory = methodDetails.getNodeFactory();
        List signatures = nodeFactory.getNodeSignatures();
        assert (signatures.size() == 1);
        List signature = (List)signatures.get(0);
        if (signature.size() >= 3 && signature.get(2) == RubyNode[].class) {
            args = argumentsNodes.toArray(new RubyNode[argumentsNodes.size()]);
            methodNode = (RubyNode)((Object)nodeFactory.createNode(new Object[]{context, sourceSection, args}));
        } else {
            args = new Object[2 + argumentsNodes.size()];
            args[0] = context;
            args[1] = sourceSection;
            System.arraycopy(argumentsNodes.toArray(new RubyNode[argumentsNodes.size()]), 0, args, 2, argumentsNodes.size());
            methodNode = (RubyNode)((Object)nodeFactory.createNode(args));
        }
        if (System.getenv("TRUFFLE_CHECK_AMBIGUOUS_OPTIONAL_ARGS") != null) {
            AmbiguousOptionalArgumentChecker.verifyNoAmbiguousOptionalArguments(methodDetails);
        }
        CheckArityNode checkArity = new CheckArityNode(context, (SourceSection)sourceSection, arity);
        RubyNode sequence = SequenceNode.sequence(context, (SourceSection)sourceSection, checkArity, methodNode);
        if (method.returnsEnumeratorIfNoBlock()) {
            sequence = new ReturnEnumeratorIfNoBlockNode(method.names()[0], sequence);
        }
        if (method.taintFromSelf() || method.taintFromParameter() != -1) {
            sequence = new TaintResultNode(method.taintFromSelf(), method.taintFromParameter(), sequence);
        }
        ExceptionTranslatingNode exceptionTranslatingNode = new ExceptionTranslatingNode(context, (SourceSection)sourceSection, sequence, method.unsupportedOperationBehavior());
        return new RubyRootNode(context, (SourceSection)sourceSection, null, sharedMethodInfo, exceptionTranslatingNode);
    }

    private static class AmbiguousOptionalArgumentChecker {
        private static final Method GET_PARAMETERS = AmbiguousOptionalArgumentChecker.checkParametersNamesAvailable();

        private AmbiguousOptionalArgumentChecker() {
        }

        private static Method checkParametersNamesAvailable() {
            try {
                return Method.class.getMethod("getParameters", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                System.err.println("Could not find method Method.getParameters()");
                return null;
            }
        }

        private static void verifyNoAmbiguousOptionalArguments(MethodDetails methodDetails) {
            if (GET_PARAMETERS == null) {
                System.exit(1);
            }
            try {
                AmbiguousOptionalArgumentChecker.verifyNoAmbiguousOptionalArgumentsWithReflection(methodDetails);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }

        private static void verifyNoAmbiguousOptionalArgumentsWithReflection(MethodDetails methodDetails) throws ReflectiveOperationException {
            boolean success = true;
            if (methodDetails.getMethodAnnotation().optional() > 0) {
                int opt = methodDetails.getMethodAnnotation().optional();
                if (methodDetails.getMethodAnnotation().needsBlock()) {
                    ++opt;
                }
                Class node = methodDetails.getNodeFactory().getNodeClass();
                for (int i = 1; i <= opt; ++i) {
                    boolean unguardedObjectArgument = false;
                    StringBuilder errors = new StringBuilder();
                    for (Method method : node.getDeclaredMethods()) {
                        String[] guards;
                        if (!method.isAnnotationPresent(Specialization.class)) continue;
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        int n = parameterTypes.length - i;
                        Class<?> parameterType = parameterTypes[n];
                        Object[] parameters = (Object[])GET_PARAMETERS.invoke((Object)method, new Object[0]);
                        Object parameter = parameters[n];
                        boolean isNamePresent = (Boolean)parameter.getClass().getMethod("isNamePresent", new Class[0]).invoke(parameter, new Object[0]);
                        if (!isNamePresent) {
                            System.err.println("Method parameters names are not available for " + method);
                            System.exit(1);
                        }
                        String name = (String)parameter.getClass().getMethod("getName", new Class[0]).invoke(parameter, new Object[0]);
                        if (parameterType != Object.class || name.startsWith("unused") || AmbiguousOptionalArgumentChecker.isGuarded(name, guards = method.getAnnotation(Specialization.class).guards())) continue;
                        unguardedObjectArgument = true;
                        errors.append("\"").append(name).append("\" in ").append(AmbiguousOptionalArgumentChecker.methodToString(method, parameterTypes, parameters)).append("\n");
                    }
                    if (!unguardedObjectArgument) continue;
                    success = false;
                    System.err.println("Ambiguous optional argument in " + node.getCanonicalName() + ":");
                    System.err.println(errors);
                }
            }
            if (!success) {
                System.exit(1);
            }
        }

        private static boolean isGuarded(String name, String[] guards) {
            for (String guard : guards) {
                if (!guard.equals("wasProvided(" + name + ")") && !guard.equals("wasNotProvided(" + name + ")") && !guard.equals("wasNotProvided(" + name + ") || isRubiniusUndefined(" + name + ")") && !guard.equals("isNil(" + name + ")")) continue;
                return true;
            }
            return false;
        }

        private static String methodToString(Method method, Class<?>[] parameterTypes, Object[] parameters) throws ReflectiveOperationException {
            StringBuilder str = new StringBuilder();
            str.append(method.getName()).append("(");
            for (int i = 0; i < parameters.length; ++i) {
                Object parameter = parameters[i];
                String name = (String)parameter.getClass().getMethod("getName", new Class[0]).invoke(parameter, new Object[0]);
                str.append(parameterTypes[i].getSimpleName()).append(" ").append(name);
                if (i >= parameters.length - 1) continue;
                str.append(", ");
            }
            str.append(")");
            return str.toString();
        }
    }

    public static class MethodDetails {
        private final CoreClass classAnnotation;
        private final CoreMethod methodAnnotation;
        private final NodeFactory<? extends RubyNode> nodeFactory;

        public MethodDetails(CoreClass classAnnotation, CoreMethod methodAnnotation, NodeFactory<? extends RubyNode> nodeFactory) {
            assert (classAnnotation != null);
            assert (methodAnnotation != null);
            assert (nodeFactory != null);
            this.classAnnotation = classAnnotation;
            this.methodAnnotation = methodAnnotation;
            this.nodeFactory = nodeFactory;
        }

        public CoreClass getClassAnnotation() {
            return this.classAnnotation;
        }

        public CoreMethod getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public NodeFactory<? extends RubyNode> getNodeFactory() {
            return this.nodeFactory;
        }

        public String getIndicativeName() {
            return this.classAnnotation.name() + "#" + this.methodAnnotation.names()[0] + "(core)";
        }
    }
}

