/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import jnr.constants.platform.Errno;
import jnr.posix.POSIXHandler;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyException;

public class TrufflePOSIXHandler
implements POSIXHandler {
    private RubyContext context;

    public TrufflePOSIXHandler(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public void error(Errno errno, String methodName) {
        throw new RaiseException(new RubyException(this.context.getCoreLibrary().getErrnoClass(errno)));
    }

    public void error(Errno errno, String methodName, String extraData) {
        this.error(errno, methodName);
    }

    public void unimplementedError(String s) {
        throw new UnsupportedOperationException();
    }

    public void warn(POSIXHandler.WARNING_ID warning_id, String s, Object ... objects) {
        throw new UnsupportedOperationException();
    }

    public boolean isVerbose() {
        return false;
    }

    public File getCurrentWorkingDirectory() {
        return new File(this.context.getRuntime().getCurrentDirectory());
    }

    public String[] getEnv() {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public PrintStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    public int getPID() {
        throw new UnsupportedOperationException();
    }

    public PrintStream getErrorStream() {
        throw new UnsupportedOperationException();
    }
}

