/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes.write;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.pack.runtime.Endianness;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class WriteHexStringNode
extends PackNode {
    private final Endianness endianness;
    private final int length;

    public WriteHexStringNode(RubyContext context, Endianness endianness, int length) {
        super(context);
        this.endianness = endianness;
        this.length = length;
    }

    @Specialization
    public Object write(VirtualFrame frame, ByteList bytes) {
        byte[] b = bytes.unsafeBytes();
        int begin = bytes.begin();
        int currentByte = 0;
        int lengthToUse = this.length == -1 ? bytes.length() : this.length;
        for (int n = 0; n < lengthToUse; ++n) {
            int currentChar = n < bytes.length() ? b[begin + n] : 0;
            if (Character.isJavaIdentifierStart(currentChar)) {
                switch (this.endianness) {
                    case LITTLE: {
                        currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4;
                        break;
                    }
                    case BIG: {
                        currentByte |= (currentChar & 0xF) + 9 & 0xF;
                    }
                }
            } else {
                switch (this.endianness) {
                    case LITTLE: {
                        currentByte |= (currentChar & 0xF) << 4;
                        break;
                    }
                    case BIG: {
                        currentByte |= currentChar & 0xF;
                    }
                }
            }
            if ((n - 1 & 1) != 0) {
                switch (this.endianness) {
                    case LITTLE: {
                        currentByte >>= 4;
                        break;
                    }
                    case BIG: {
                        currentByte <<= 4;
                    }
                }
                continue;
            }
            this.writeBytes(frame, (byte)currentByte);
            currentByte = 0;
        }
        if ((lengthToUse & 1) != 0) {
            this.writeBytes(frame, (byte)(currentByte & 0xFF));
        }
        return null;
    }
}

