/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.fixnum;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyRange;

public class FixnumLowerNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenInteger = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenLong = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenIntegerRange = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenLongRange = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasSeenUndefined = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasNeededToLowerLongFixnum = false;
    @CompilerDirectives.CompilationFinal
    private boolean hasNeededToLowerLongFixnumRange = false;

    public FixnumLowerNode(RubyNode child) {
        super(child.getContext(), child.getEncapsulatingSourceSection());
        this.child = child;
    }

    @Override
    public RubyBasicObject executeRubyBasicObject(VirtualFrame frame) throws UnexpectedResultException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.child.execute(frame);
        if (this.hasSeenInteger && value instanceof Integer) {
            return value;
        }
        if (this.hasSeenLong && value instanceof Long) {
            if (FixnumLowerNode.canLower((Long)value)) {
                return FixnumLowerNode.lower((Long)value);
            }
            return value;
        }
        if (this.hasSeenIntegerRange && value instanceof RubyRange.IntegerFixnumRange) {
            return value;
        }
        if (this.hasSeenLongRange && value instanceof RubyRange.LongFixnumRange) {
            if (FixnumLowerNode.canLower((RubyRange.LongFixnumRange)value)) {
                return FixnumLowerNode.lower((RubyRange.LongFixnumRange)value);
            }
            return value;
        }
        if (this.hasSeenUndefined && value instanceof NotProvided) {
            return value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (value instanceof Integer) {
            this.hasSeenInteger = true;
            return value;
        }
        if (value instanceof Long) {
            this.hasSeenLong = true;
            if (FixnumLowerNode.canLower((Long)value)) {
                return FixnumLowerNode.lower((Long)value);
            }
            return value;
        }
        if (value instanceof RubyRange.IntegerFixnumRange) {
            this.hasSeenIntegerRange = true;
            return value;
        }
        if (value instanceof RubyRange.LongFixnumRange) {
            this.hasSeenLongRange = true;
            if (FixnumLowerNode.canLower((RubyRange.LongFixnumRange)value)) {
                return FixnumLowerNode.lower((RubyRange.LongFixnumRange)value);
            }
            return value;
        }
        if (value instanceof NotProvided) {
            this.hasSeenUndefined = true;
            return value;
        }
        return value;
    }

    @Override
    public int executeInteger(VirtualFrame frame) throws UnexpectedResultException {
        try {
            if (this.hasNeededToLowerLongFixnum) {
                long value = super.executeLong(frame);
                if (FixnumLowerNode.canLower(value)) {
                    return FixnumLowerNode.lower(value);
                }
                throw new UnexpectedResultException((Object)value);
            }
            return super.executeInteger(frame);
        }
        catch (UnexpectedResultException e) {
            if (e.getResult() instanceof Long && FixnumLowerNode.canLower((Long)e.getResult())) {
                this.hasNeededToLowerLongFixnum = true;
                return FixnumLowerNode.lower((Long)e.getResult());
            }
            if (e.getResult() instanceof RubyRange.LongFixnumRange && FixnumLowerNode.canLower((RubyRange.LongFixnumRange)e.getResult())) {
                this.hasNeededToLowerLongFixnumRange = true;
                throw new UnexpectedResultException((Object)FixnumLowerNode.lower((RubyRange.LongFixnumRange)e.getResult()));
            }
            throw e;
        }
    }

    @Override
    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        throw new RuntimeException();
    }

    @Override
    public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        try {
            if (this.hasNeededToLowerLongFixnumRange) {
                RubyRange.LongFixnumRange range = super.executeLongFixnumRange(frame);
                if (FixnumLowerNode.canLower(range)) {
                    return FixnumLowerNode.lower(range);
                }
                throw new UnexpectedResultException((Object)range);
            }
            return super.executeIntegerFixnumRange(frame);
        }
        catch (UnexpectedResultException e) {
            if (e.getResult() instanceof Long && FixnumLowerNode.canLower((Long)e.getResult())) {
                this.hasNeededToLowerLongFixnum = true;
                throw new UnexpectedResultException((Object)FixnumLowerNode.lower((Long)e.getResult()));
            }
            if (e.getResult() instanceof RubyRange.LongFixnumRange && FixnumLowerNode.canLower((RubyRange.LongFixnumRange)e.getResult())) {
                this.hasNeededToLowerLongFixnumRange = true;
                return FixnumLowerNode.lower((RubyRange.LongFixnumRange)e.getResult());
            }
            throw e;
        }
    }

    @Override
    public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        throw new RuntimeException();
    }

    @Override
    public NotProvided executeNotProvided(VirtualFrame frame) throws UnexpectedResultException {
        try {
            return super.executeNotProvided(frame);
        }
        catch (UnexpectedResultException e) {
            if (e.getResult() instanceof Long && FixnumLowerNode.canLower((Long)e.getResult())) {
                this.hasNeededToLowerLongFixnum = true;
                throw new UnexpectedResultException((Object)FixnumLowerNode.lower((Long)e.getResult()));
            }
            if (e.getResult() instanceof RubyRange.LongFixnumRange && FixnumLowerNode.canLower((RubyRange.LongFixnumRange)e.getResult())) {
                this.hasNeededToLowerLongFixnumRange = true;
                throw new UnexpectedResultException(e.getResult());
            }
            throw e;
        }
    }

    private static boolean canLower(long value) {
        return CoreLibrary.fitsIntoInteger(value);
    }

    private static int lower(long value) {
        assert (FixnumLowerNode.canLower(value));
        return (int)value;
    }

    private static boolean canLower(RubyRange.LongFixnumRange range) {
        return FixnumLowerNode.canLower(range.getBegin()) && FixnumLowerNode.canLower(range.getEnd());
    }

    private static RubyRange.IntegerFixnumRange lower(RubyRange.LongFixnumRange range) {
        assert (FixnumLowerNode.canLower(range));
        return new RubyRange.IntegerFixnumRange(range.getContext().getCoreLibrary().getRangeClass(), FixnumLowerNode.lower(range.getBegin()), FixnumLowerNode.lower(range.getEnd()), range.doesExcludeEnd());
    }
}

