/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArraySliceNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=ArraySliceNode.class)
public final class ArraySliceNodeGen
extends ArraySliceNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArraySliceNodeGen(RubyContext context, SourceSection sourceSection, int from, int to, RubyNode array) {
        super(context, sourceSection, from, to);
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ArraySliceNode create(RubyContext context, SourceSection sourceSection, int from, int to, RubyNode array) {
        return new ArraySliceNodeGen(context, sourceSection, from, to, array);
    }

    @GeneratedBy(methodName="sliceObject(RubyArray)", value=ArraySliceNode.class)
    private static final class SliceObjectNode_
    extends BaseNode_ {
        SliceObjectNode_(ArraySliceNodeGen root) {
            super(root, 5);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && ArrayGuards.isObjectArray(arrayValue_ = (RubyArray)arrayValue)) {
                return this.root.sliceObject(arrayValue_);
            }
            return this.getNext().executeRubyBasicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new SliceObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="sliceFloat(RubyArray)", value=ArraySliceNode.class)
    private static final class SliceFloatNode_
    extends BaseNode_ {
        SliceFloatNode_(ArraySliceNodeGen root) {
            super(root, 4);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && ArrayGuards.isDoubleArray(arrayValue_ = (RubyArray)arrayValue)) {
                return this.root.sliceFloat(arrayValue_);
            }
            return this.getNext().executeRubyBasicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new SliceFloatNode_(root);
        }
    }

    @GeneratedBy(methodName="sliceLongFixnum(RubyArray)", value=ArraySliceNode.class)
    private static final class SliceLongFixnumNode_
    extends BaseNode_ {
        SliceLongFixnumNode_(ArraySliceNodeGen root) {
            super(root, 3);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && ArrayGuards.isLongArray(arrayValue_ = (RubyArray)arrayValue)) {
                return this.root.sliceLongFixnum(arrayValue_);
            }
            return this.getNext().executeRubyBasicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new SliceLongFixnumNode_(root);
        }
    }

    @GeneratedBy(methodName="sliceIntegerFixnum(RubyArray)", value=ArraySliceNode.class)
    private static final class SliceIntegerFixnumNode_
    extends BaseNode_ {
        SliceIntegerFixnumNode_(ArraySliceNodeGen root) {
            super(root, 2);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && ArrayGuards.isIntArray(arrayValue_ = (RubyArray)arrayValue)) {
                return this.root.sliceIntegerFixnum(arrayValue_);
            }
            return this.getNext().executeRubyBasicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new SliceIntegerFixnumNode_(root);
        }
    }

    @GeneratedBy(methodName="sliceNull(RubyArray)", value=ArraySliceNode.class)
    private static final class SliceNullNode_
    extends BaseNode_ {
        SliceNullNode_(ArraySliceNodeGen root) {
            super(root, 1);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && ArrayGuards.isNullArray(arrayValue_ = (RubyArray)arrayValue)) {
                return this.root.sliceNull(arrayValue_);
            }
            return this.getNext().executeRubyBasicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new SliceNullNode_(root);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArraySliceNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arrayValue) {
            return this.getNext().executeRubyBasicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArraySliceNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arrayValue) {
            return (RubyBasicObject)this.uninitialized((Frame)frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final ArraySliceNodeGen root;

        BaseNode_(ArraySliceNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.executeRubyBasicObject_((VirtualFrame)frameValue, arrayValue);
        }

        public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.executeRubyBasicObject_(frameValue, arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof RubyArray) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return SliceNullNode_.create(this.root);
                }
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return SliceIntegerFixnumNode_.create(this.root);
                }
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return SliceLongFixnumNode_.create(this.root);
                }
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return SliceFloatNode_.create(this.root);
                }
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return SliceObjectNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

