/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayReadNormalizedNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=ArrayReadNormalizedNode.class)
public final class ArrayReadNormalizedNodeGen
extends ArrayReadNormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayReadNormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeRead(VirtualFrame frameValue, RubyArray arrayValue, int indexValue) {
        return this.specialization_.execute1(frameValue, arrayValue, indexValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeRubyBasicObject(frameValue);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeDouble(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeInt(frameValue);
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeLong(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static RubyBasicObject expectRubyBasicObject(Object value) throws UnexpectedResultException {
        if (value instanceof RubyBasicObject) {
            return (RubyBasicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ArrayReadNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
        return new ArrayReadNormalizedNodeGen(context, sourceSection, array, index);
    }

    @GeneratedBy(methodName="readOutOfBounds(RubyArray, int)", value=ArrayReadNormalizedNode.class)
    private static final class ReadOutOfBoundsNode_
    extends BaseNode_ {
        ReadOutOfBoundsNode_(ArrayReadNormalizedNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                return ArrayReadNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult(), indexValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayReadNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, ex.getResult()));
            }
            if (!ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.readOutOfBounds(arrayValue_, indexValue_);
            }
            return ArrayReadNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, indexValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyArray arrayValue, int indexValue) {
            if (!ArrayReadNormalizedNode.isInBounds(arrayValue, indexValue)) {
                return this.root.readOutOfBounds(arrayValue, indexValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValue_;
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && indexValue instanceof Integer && !ArrayReadNormalizedNode.isInBounds(arrayValue_ = (RubyArray)arrayValue, indexValue_ = ((Integer)indexValue).intValue())) {
                return this.root.readOutOfBounds(arrayValue_, indexValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new ReadOutOfBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readObjectInBounds(RubyArray, int)", value=ArrayReadNormalizedNode.class)
    private static final class ReadObjectInBoundsNode_
    extends BaseNode_ {
        ReadObjectInBoundsNode_(ArrayReadNormalizedNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
            }
            if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.readObjectInBounds(arrayValue_, indexValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyArray arrayValue, int indexValue) {
            if (ArrayReadNormalizedNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return this.root.readObjectInBounds(arrayValue, indexValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValue_;
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && indexValue instanceof Integer && ArrayReadNormalizedNode.isInBounds(arrayValue_ = (RubyArray)arrayValue, indexValue_ = ((Integer)indexValue).intValue()) && ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.readObjectInBounds(arrayValue_, indexValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new ReadObjectInBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readDoubleInBounds(RubyArray, int)", value=ArrayReadNormalizedNode.class)
    private static final class ReadDoubleInBoundsNode_
    extends BaseNode_ {
        ReadDoubleInBoundsNode_(ArrayReadNormalizedNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                return ArrayReadNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), indexValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayReadNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, ex.getResult()));
            }
            if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.readDoubleInBounds(arrayValue_, indexValue_);
            }
            return ArrayReadNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, indexValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyArray arrayValue, int indexValue) {
            if (ArrayReadNormalizedNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.readDoubleInBounds(arrayValue, indexValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValue_;
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && indexValue instanceof Integer && ArrayReadNormalizedNode.isInBounds(arrayValue_ = (RubyArray)arrayValue, indexValue_ = ((Integer)indexValue).intValue()) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.readDoubleInBounds(arrayValue_, indexValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new ReadDoubleInBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readLongInBounds(RubyArray, int)", value=ArrayReadNormalizedNode.class)
    private static final class ReadLongInBoundsNode_
    extends BaseNode_ {
        ReadLongInBoundsNode_(ArrayReadNormalizedNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                return ArrayReadNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), indexValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayReadNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, ex.getResult()));
            }
            if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.readLongInBounds(arrayValue_, indexValue_);
            }
            return ArrayReadNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyArray arrayValue, int indexValue) {
            if (ArrayReadNormalizedNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isLongArray(arrayValue)) {
                return this.root.readLongInBounds(arrayValue, indexValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValue_;
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && indexValue instanceof Integer && ArrayReadNormalizedNode.isInBounds(arrayValue_ = (RubyArray)arrayValue, indexValue_ = ((Integer)indexValue).intValue()) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.readLongInBounds(arrayValue_, indexValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new ReadLongInBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readIntInBounds(RubyArray, int)", value=ArrayReadNormalizedNode.class)
    private static final class ReadIntInBoundsNode_
    extends BaseNode_ {
        ReadIntInBoundsNode_(ArrayReadNormalizedNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                return ArrayReadNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), indexValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayReadNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, ex.getResult()));
            }
            if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.readIntInBounds(arrayValue_, indexValue_);
            }
            return ArrayReadNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyArray arrayValue, int indexValue) {
            if (ArrayReadNormalizedNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isIntArray(arrayValue)) {
                return this.root.readIntInBounds(arrayValue, indexValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValue_;
            RubyArray arrayValue_;
            if (arrayValue instanceof RubyArray && indexValue instanceof Integer && ArrayReadNormalizedNode.isInBounds(arrayValue_ = (RubyArray)arrayValue, indexValue_ = ((Integer)indexValue).intValue()) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.readIntInBounds(arrayValue_, indexValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new ReadIntInBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readNull(RubyArray, int)", value=ArrayReadNormalizedNode.class)
    private static final class ReadNullNode_
    extends BaseNode_ {
        ReadNullNode_(ArrayReadNormalizedNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                return ArrayReadNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult(), indexValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayReadNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, ex.getResult()));
            }
            if (ArrayGuards.isNullArray(arrayValue_)) {
                return this.root.readNull(arrayValue_, indexValue_);
            }
            return ArrayReadNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, indexValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyArray arrayValue, int indexValue) {
            if (ArrayGuards.isNullArray(arrayValue)) {
                return this.root.readNull(arrayValue, indexValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            if (arrayValue instanceof RubyArray && indexValue instanceof Integer) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return this.root.readNull(arrayValue_, indexValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new ReadNullNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayReadNormalizedNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            return this.getNext().execute_(frameValue, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayReadNormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            return this.uninitialized((Frame)frameValue, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final ArrayReadNormalizedNodeGen root;

        BaseNode_(ArrayReadNormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue) {
            return this.execute_((VirtualFrame)frameValue, arrayValue, indexValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

        public Object execute1(VirtualFrame frameValue, RubyArray arrayValue, int indexValue) {
            return this.execute_(frameValue, arrayValue, indexValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_((Frame)frameValue);
            return this.execute_(frameValue, arrayValue_, indexValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayReadNormalizedNodeGen.expectRubyBasicObject(this.execute0(frameValue));
        }

        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayReadNormalizedNodeGen.expectDouble(this.execute0(frameValue));
        }

        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayReadNormalizedNodeGen.expectInteger(this.execute0(frameValue));
        }

        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayReadNormalizedNodeGen.expectLong(this.execute0(frameValue));
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue) {
            if (arrayValue instanceof RubyArray && indexValue instanceof Integer) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return ReadNullNode_.create(this.root);
                }
                if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return ReadIntInBoundsNode_.create(this.root);
                }
                if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return ReadLongInBoundsNode_.create(this.root);
                }
                if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return ReadDoubleInBoundsNode_.create(this.root);
                }
                if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return ReadObjectInBoundsNode_.create(this.root);
                }
                if (!ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return ReadOutOfBoundsNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }
    }
}

