/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Iterator;
import org.joni.NameEntry;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.util.ByteList;

@CoreClass(name="Regexp")
public abstract class RegexpNodes {

    @NodeChild(value="self")
    public static abstract class RubiniusNamesNode
    extends RubyNode {
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;

        public RubiniusNamesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!anyNames(regexp)"})
        public RubyBasicObject rubiniusNamesNoCaptures(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            return this.nil();
        }

        @Specialization(guards={"anyNames(regexp)"})
        public Object rubiniusNames(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            if (regexp.getCachedNames() != null) {
                return regexp.getCachedNames();
            }
            if (this.newLookupTableNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.newLookupTableNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (this.lookupTableWriteNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.lookupTableWriteNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object namesLookupTable = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            Iterator i = regexp.getRegex().namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                RubySymbol name = this.getContext().getSymbol(new ByteList(e.name, e.nameP, e.nameEnd - e.nameP, false));
                int[] backrefs = e.getBackRefs();
                RubyBasicObject backrefsRubyArray = ArrayNodes.createArray(this.getContext().getCoreLibrary().getArrayClass(), backrefs, backrefs.length);
                this.lookupTableWriteNode.call(frame, namesLookupTable, "[]=", null, name, backrefsRubyArray);
            }
            regexp.setCachedNames(namesLookupTable);
            return namesLookupTable;
        }

        public static boolean anyNames(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            return regexp.getRegex().numberOfNames() > 0;
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toS(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            return this.createString(((RubyString)RubyRegexp.newRegexp((Ruby)this.getContext().getRuntime(), (ByteList)regexp.getSource(), (int)regexp.getRegex().getOptions()).to_s()).getByteList());
        }
    }

    @CoreMethod(names={"source"})
    public static abstract class SourceNode
    extends CoreMethodArrayArgumentsNode {
        public SourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject source(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            return this.createString(regexp.getSource().dup());
        }
    }

    @CoreMethod(names={"search_from"}, required=2)
    public static abstract class SearchFromNode
    extends CoreMethodArrayArgumentsNode {
        public SearchFromNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object searchFrom(org.jruby.truffle.runtime.core.RubyRegexp regexp, org.jruby.truffle.runtime.core.RubyString string, int startPos) {
            return regexp.matchCommon(string, false, false, startPos);
        }
    }

    @CoreMethod(names={"quote", "escape"}, needsSelf=false, onSingleton=true, required=1)
    public static abstract class QuoteNode
    extends CoreMethodArrayArgumentsNode {
        public QuoteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(raw)"})
        public RubyBasicObject quote(RubyBasicObject raw) {
            boolean isAsciiOnly = StringNodes.getByteList(raw).getEncoding().isAsciiCompatible() && StringNodes.scanForCodeRange(raw) == 16;
            return this.createString(RubyRegexp.quote19((ByteList)StringNodes.getByteList(raw), (boolean)isAsciiOnly));
        }

        @Specialization
        public RubyBasicObject quote(RubySymbol raw) {
            return this.quote(raw.toRubyString());
        }
    }

    @CoreMethod(names={"match_start"}, required=2)
    public static abstract class MatchStartNode
    extends CoreMethodArrayArgumentsNode {
        public MatchStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object matchStart(org.jruby.truffle.runtime.core.RubyRegexp regexp, org.jruby.truffle.runtime.core.RubyString string, int startPos) {
            Object matchResult = regexp.matchCommon(string, false, false, startPos);
            if (matchResult instanceof RubyMatchData && ((RubyMatchData)matchResult).getNumberOfRegions() > 0 && ((RubyMatchData)matchResult).getRegion().beg[0] == startPos) {
                return matchResult;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(org.jruby.truffle.runtime.core.RubyRegexp regexp) {
            int options = regexp.getRegex().getOptions() & 0xFFFFFFDF;
            return options ^ regexp.getSource().hashCode();
        }
    }

    @CoreMethod(names={"escape"}, onSingleton=true, required=1)
    public static abstract class EscapeNode
    extends CoreMethodArrayArgumentsNode {
        public EscapeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract RubyBasicObject executeEscape(VirtualFrame var1, org.jruby.truffle.runtime.core.RubyString var2);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject escape(org.jruby.truffle.runtime.core.RubyString pattern) {
            return this.createString(RubyRegexp.quote19((ByteList)new ByteList(StringNodes.getByteList(pattern)), (boolean)true).toString());
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toSNode;
        @Node.Child
        private ToStrNode toStrNode;

        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp, org.jruby.truffle.runtime.core.RubyString string) {
            return regexp.matchCommon(string, true, true);
        }

        @Specialization
        public Object match(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyRegexp regexp, RubySymbol symbol) {
            if (this.toSNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toSNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.match(regexp, (org.jruby.truffle.runtime.core.RubyString)this.toSNode.call(frame, symbol, "to_s", null, new Object[0]));
        }

        @Specialization(guards={"isNil(nil)"})
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp, Object nil) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyString(other)", "!isRubySymbol(other)", "!isNil(other)"})
        public Object matchGeneric(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyRegexp regexp, RubyBasicObject other) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.match(regexp, this.toStrNode.executeRubyString(frame, other));
        }
    }
}

