/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.array;

import java.util.Arrays;
import org.jruby.truffle.runtime.array.ArrayUtils;

public abstract class ArrayMirror {
    public static IntegerArrayMirror reflect(int[] array) {
        return new IntegerArrayMirror(array);
    }

    public static LongArrayMirror reflect(long[] array) {
        return new LongArrayMirror(array);
    }

    public static DoubleArrayMirror reflect(double[] array) {
        return new DoubleArrayMirror(array);
    }

    public static ObjectArrayMirror reflect(Object[] array) {
        return new ObjectArrayMirror(array);
    }

    public abstract int getLength();

    public abstract Object get(int var1);

    public abstract void set(int var1, Object var2);

    public abstract ArrayMirror copyArrayAndMirror(int var1);

    public abstract void copyTo(ArrayMirror var1, int var2, int var3, int var4);

    public abstract void copyTo(Object[] var1, int var2, int var3, int var4);

    public abstract Object getArray();

    public Object copyArrayAndMirror() {
        return this.copyArrayAndMirror(this.getLength());
    }

    public Object[] getBoxedCopy() {
        return this.getBoxedCopy(this.getLength());
    }

    public Object[] getBoxedCopy(int newLength) {
        Object[] boxed = new Object[newLength];
        this.copyTo(boxed, 0, 0, Math.min(this.getLength(), newLength));
        return boxed;
    }

    private static class ObjectArrayMirror
    extends ArrayMirror {
        private final Object[] array;

        public ObjectArrayMirror(Object[] array) {
            this.array = array;
        }

        @Override
        public int getLength() {
            return this.array.length;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        @Override
        public void set(int index, Object value) {
            this.array[index] = value;
        }

        @Override
        public ArrayMirror copyArrayAndMirror(int newLength) {
            return new ObjectArrayMirror(ArrayUtils.copyOf(this.array, newLength));
        }

        @Override
        public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
            System.arraycopy(this.array, sourceStart, destination.getArray(), destinationStart, count);
        }

        @Override
        public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
            System.arraycopy(this.array, sourceStart, destination, destinationStart, count);
        }

        @Override
        public Object getArray() {
            return this.array;
        }
    }

    private static class DoubleArrayMirror
    extends ArrayMirror {
        private final double[] array;

        public DoubleArrayMirror(double[] array) {
            this.array = array;
        }

        @Override
        public int getLength() {
            return this.array.length;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        @Override
        public void set(int index, Object value) {
            this.array[index] = (Double)value;
        }

        @Override
        public ArrayMirror copyArrayAndMirror(int newLength) {
            return new DoubleArrayMirror(Arrays.copyOf(this.array, newLength));
        }

        @Override
        public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
            System.arraycopy(this.array, sourceStart, destination.getArray(), destinationStart, count);
        }

        @Override
        public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
            for (int n = 0; n < count; ++n) {
                destination[destinationStart + n] = this.array[sourceStart + n];
            }
        }

        @Override
        public Object getArray() {
            return this.array;
        }
    }

    private static class LongArrayMirror
    extends ArrayMirror {
        private final long[] array;

        public LongArrayMirror(long[] array) {
            this.array = array;
        }

        @Override
        public int getLength() {
            return this.array.length;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        @Override
        public void set(int index, Object value) {
            this.array[index] = (Long)value;
        }

        @Override
        public ArrayMirror copyArrayAndMirror(int newLength) {
            return new LongArrayMirror(Arrays.copyOf(this.array, newLength));
        }

        @Override
        public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
            System.arraycopy(this.array, sourceStart, destination.getArray(), destinationStart, count);
        }

        @Override
        public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
            for (int n = 0; n < count; ++n) {
                destination[destinationStart + n] = this.array[sourceStart + n];
            }
        }

        @Override
        public Object getArray() {
            return this.array;
        }
    }

    private static class IntegerArrayMirror
    extends ArrayMirror {
        private final int[] array;

        public IntegerArrayMirror(int[] array) {
            this.array = array;
        }

        @Override
        public int getLength() {
            return this.array.length;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        @Override
        public void set(int index, Object value) {
            this.array[index] = (Integer)value;
        }

        @Override
        public ArrayMirror copyArrayAndMirror(int newLength) {
            return new IntegerArrayMirror(Arrays.copyOf(this.array, newLength));
        }

        @Override
        public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
            System.arraycopy(this.array, sourceStart, destination.getArray(), destinationStart, count);
        }

        @Override
        public Object[] getBoxedCopy(int newLength) {
            return ArrayUtils.box(this.array, newLength);
        }

        @Override
        public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
            for (int n = 0; n < count; ++n) {
                destination[destinationStart + n] = this.array[sourceStart + n];
            }
        }

        @Override
        public Object getArray() {
            return this.array;
        }
    }
}

