/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.kenai.jffi.MemoryIO;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.rubinius.RubiniusTypes;
import org.jruby.util.ByteList;
import org.jruby.util.unsafe.UnsafeHolder;

public abstract class PointerPrimitiveNodes {
    public static final Pointer NULL_POINTER = Runtime.getSystemRuntime().getMemoryManager().newOpaquePointer(0L);
    private static final HiddenKey POINTER_IDENTIFIER = new HiddenKey("pointer");
    private static final Property POINTER_PROPERTY;
    private static final DynamicObjectFactory POINTER_FACTORY;

    public static RubyBasicObject createPointer(RubyClass rubyClass, Pointer pointer) {
        if (pointer == null) {
            pointer = NULL_POINTER;
        }
        return new RubyBasicObject(rubyClass, POINTER_FACTORY.newInstance(new Object[]{pointer}));
    }

    public static void setPointer(RubyBasicObject pointer, Pointer newPointer) {
        assert (newPointer != null);
        assert (pointer.getDynamicObject().getShape().hasProperty((Object)POINTER_IDENTIFIER));
        try {
            POINTER_PROPERTY.set(pointer.getDynamicObject(), (Object)newPointer, pointer.getDynamicObject().getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static Pointer getPointer(RubyBasicObject pointer) {
        assert (pointer.getDynamicObject().getShape().hasProperty((Object)POINTER_IDENTIFIER));
        return (Pointer)POINTER_PROPERTY.get(pointer.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        POINTER_PROPERTY = Property.create((Object)POINTER_IDENTIFIER, (Location)allocator.locationForType(Pointer.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
        POINTER_FACTORY = RubyBasicObject.EMPTY_SHAPE.addProperty(POINTER_PROPERTY).createFactory();
    }

    @RubiniusPrimitive(name="pointer_write_int")
    public static abstract class PointerWriteIntPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerWriteIntPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject address(RubyBasicObject pointer, int value) {
            PointerPrimitiveNodes.getPointer(pointer).putInt(0L, value);
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_read_string_to_null")
    public static abstract class PointerReadStringToNullPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerReadStringToNullPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject readStringToNull(RubyBasicObject pointer) {
            return this.createString(MemoryIO.getInstance().getZeroTerminatedByteArray(PointerPrimitiveNodes.getPointer(pointer).address()));
        }
    }

    @RubiniusPrimitive(name="pointer_write_string")
    public static abstract class PointerWriteStringPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerWriteStringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject address(RubyBasicObject pointer, RubyString string, int maxLength) {
            ByteList bytes = StringNodes.getByteList(string);
            int length = Math.min(bytes.length(), maxLength);
            PointerPrimitiveNodes.getPointer(pointer).put(0L, bytes.unsafeBytes(), bytes.begin(), length);
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_get_at_offset")
    @ImportStatic(value={RubiniusTypes.class})
    public static abstract class PointerGetAtOffsetPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerGetAtOffsetPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"type == TYPE_CHAR"})
        public int getAtOffsetChar(RubyBasicObject pointer, int offset, int type) {
            return PointerPrimitiveNodes.getPointer(pointer).getByte((long)offset);
        }

        @Specialization(guards={"type == TYPE_UCHAR"})
        public int getAtOffsetUChar(RubyBasicObject pointer, int offset, int type) {
            return PointerPrimitiveNodes.getPointer(pointer).getByte((long)offset);
        }

        @Specialization(guards={"type == TYPE_INT"})
        public int getAtOffsetInt(RubyBasicObject pointer, int offset, int type) {
            return PointerPrimitiveNodes.getPointer(pointer).getInt((long)offset);
        }

        @Specialization(guards={"type == TYPE_SHORT"})
        public int getAtOffsetShort(RubyBasicObject pointer, int offset, int type) {
            return PointerPrimitiveNodes.getPointer(pointer).getShort((long)offset);
        }

        @Specialization(guards={"type == TYPE_USHORT"})
        public int getAtOffsetUShort(RubyBasicObject pointer, int offset, int type) {
            return PointerPrimitiveNodes.getPointer(pointer).getShort((long)offset);
        }

        @Specialization(guards={"type == TYPE_LONG"})
        public long getAtOffsetLong(RubyBasicObject pointer, int offset, int type) {
            return PointerPrimitiveNodes.getPointer(pointer).getLong((long)offset);
        }

        @Specialization(guards={"type == TYPE_ULONG"})
        public long getAtOffsetULong(RubyBasicObject pointer, int offset, int type) {
            return PointerPrimitiveNodes.getPointer(pointer).getLong((long)offset);
        }

        @Specialization(guards={"type == TYPE_ULL"})
        public long getAtOffsetULL(RubyBasicObject pointer, int offset, int type) {
            return PointerPrimitiveNodes.getPointer(pointer).getLongLong((long)offset);
        }

        @Specialization(guards={"type == TYPE_STRING"})
        public RubyBasicObject getAtOffsetString(RubyBasicObject pointer, int offset, int type) {
            return this.createString(PointerPrimitiveNodes.getPointer(pointer).getString((long)offset));
        }

        @Specialization(guards={"type == TYPE_PTR"})
        public RubyBasicObject getAtOffsetPointer(RubyBasicObject pointer, int offset, int type) {
            Pointer readPointer = PointerPrimitiveNodes.getPointer(pointer).getPointer((long)offset);
            if (readPointer == null) {
                return this.nil();
            }
            return PointerPrimitiveNodes.createPointer(pointer.getLogicalClass(), readPointer);
        }
    }

    @RubiniusPrimitive(name="pointer_address")
    public static abstract class PointerAddressPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerAddressPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long address(RubyBasicObject pointer) {
            return PointerPrimitiveNodes.getPointer(pointer).address();
        }
    }

    @RubiniusPrimitive(name="pointer_read_pointer")
    public static abstract class PointerReadPointerPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerReadPointerPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject readPointer(RubyBasicObject pointer) {
            return PointerPrimitiveNodes.createPointer(pointer.getLogicalClass(), PointerPrimitiveNodes.getPointer(pointer).getPointer(0L));
        }
    }

    @RubiniusPrimitive(name="pointer_set_at_offset", lowerFixnumParameters={0, 1})
    @ImportStatic(value={RubiniusTypes.class})
    public static abstract class PointerSetAtOffsetPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerSetAtOffsetPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"type == TYPE_INT"})
        public int setAtOffsetInt(RubyBasicObject pointer, int offset, int type, int value) {
            PointerPrimitiveNodes.getPointer(pointer).putInt((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_LONG"})
        public long setAtOffsetLong(RubyBasicObject pointer, int offset, int type, long value) {
            PointerPrimitiveNodes.getPointer(pointer).putLong((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_ULONG"})
        public long setAtOffsetULong(RubyBasicObject pointer, int offset, int type, long value) {
            PointerPrimitiveNodes.getPointer(pointer).putLong((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_ULL"})
        public long setAtOffsetULL(RubyBasicObject pointer, int offset, int type, long value) {
            PointerPrimitiveNodes.getPointer(pointer).putLongLong((long)offset, value);
            return value;
        }
    }

    @RubiniusPrimitive(name="pointer_set_autorelease")
    public static abstract class PointerSetAutoreleasePrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerSetAutoreleasePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean setAutorelease(RubyBasicObject pointer, boolean autorelease) {
            return autorelease;
        }
    }

    @RubiniusPrimitive(name="pointer_read_string", lowerFixnumParameters={0})
    public static abstract class PointerReadStringPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerReadStringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject readString(RubyBasicObject pointer, int length) {
            byte[] bytes = new byte[length];
            PointerPrimitiveNodes.getPointer(pointer).get(0L, bytes, 0, length);
            return this.createString(bytes);
        }
    }

    @RubiniusPrimitive(name="pointer_read_int")
    public static abstract class PointerReadIntPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerReadIntPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSigned(signed)"})
        public int readInt(RubyBasicObject pointer, boolean signed) {
            return PointerPrimitiveNodes.getPointer(pointer).getInt(0L);
        }

        protected boolean isSigned(boolean signed) {
            return signed;
        }
    }

    @RubiniusPrimitive(name="pointer_add")
    public static abstract class PointerAddPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerAddPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject add(RubyBasicObject a, int b) {
            return this.add(a, (long)b);
        }

        @Specialization
        public RubyBasicObject add(RubyBasicObject a, long b) {
            return PointerPrimitiveNodes.createPointer(a.getLogicalClass(), this.getMemoryManager().newPointer(PointerPrimitiveNodes.getPointer(a).address() + b));
        }
    }

    @RubiniusPrimitive(name="pointer_set_address")
    public static abstract class PointerSetAddressPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerSetAddressPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long setAddress(RubyBasicObject pointer, int address) {
            return this.setAddress(pointer, (long)address);
        }

        @Specialization
        public long setAddress(RubyBasicObject pointer, long address) {
            PointerPrimitiveNodes.setPointer(pointer, this.getMemoryManager().newPointer(address));
            return address;
        }
    }

    @RubiniusPrimitive(name="pointer_free")
    public static abstract class PointerFreePrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerFreePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject free(RubyBasicObject pointer) {
            UnsafeHolder.U.freeMemory(PointerPrimitiveNodes.getPointer(pointer).address());
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_malloc")
    public static abstract class PointerMallocPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerMallocPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject malloc(RubyClass pointerClass, int size) {
            return this.malloc(pointerClass, (long)size);
        }

        @Specialization
        public RubyBasicObject malloc(RubyClass pointerClass, long size) {
            return PointerPrimitiveNodes.createPointer(pointerClass, this.getMemoryManager().newPointer(UnsafeHolder.U.allocateMemory(size)));
        }
    }

    public static class PointerAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return PointerPrimitiveNodes.createPointer(rubyClass, NULL_POINTER);
        }
    }
}

