/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.rubinius.RubiniusByteArray;
import org.jruby.util.ByteList;

@CoreClass(name="Rubinius::ByteArray")
public abstract class ByteArrayNodes {

    @CoreMethod(names={"locate"}, required=3, lowerFixnumParameters={1, 2})
    public static abstract class LocateNode
    extends CoreMethodArrayArgumentsNode {
        public LocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getByte(RubiniusByteArray bytes, RubyString pattern, int start, int length) {
            int index = new ByteList(bytes.getBytes().unsafeBytes(), start, length).indexOf(StringNodes.getByteList(pattern));
            if (index == -1) {
                return this.nil();
            }
            return start + index + StringNodes.length(pattern);
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(RubiniusByteArray bytes) {
            return bytes.getBytes().getRealSize();
        }
    }

    @CoreMethod(names={"set_byte"}, required=2, lowerFixnumParameters={0, 1})
    public static abstract class SetByteNode
    extends CoreMethodArrayArgumentsNode {
        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setByte(RubiniusByteArray bytes, int index, int value) {
            if (index < 0 || index >= bytes.getBytes().getRealSize()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError("index out of bounds", this));
            }
            bytes.getBytes().set(index, value);
            return bytes.getBytes().get(index);
        }
    }

    @CoreMethod(names={"prepend"}, required=1)
    public static abstract class PrependNode
    extends CoreMethodArrayArgumentsNode {
        public PrependNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubiniusByteArray prepend(RubiniusByteArray bytes, RubyString string) {
            int prependLength = StringNodes.getByteList(string).getUnsafeBytes().length;
            int originalLength = bytes.getBytes().getUnsafeBytes().length;
            int newLength = prependLength + originalLength;
            byte[] prependedBytes = new byte[newLength];
            System.arraycopy(StringNodes.getByteList(string).getUnsafeBytes(), 0, prependedBytes, 0, prependLength);
            System.arraycopy(bytes.getBytes().getUnsafeBytes(), 0, prependedBytes, prependLength, originalLength);
            return new RubiniusByteArray(this.getContext().getCoreLibrary().getByteArrayClass(), new ByteList(prependedBytes));
        }
    }

    @CoreMethod(names={"get_byte"}, required=1, lowerFixnumParameters={0})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getByte(RubiniusByteArray bytes, int index) {
            return bytes.getBytes().get(index);
        }
    }
}

