/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayGetTailNode
extends RubyNode {
    final int index;

    public ArrayGetTailNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    @Specialization(guards={"isNullArray(array)"})
    public RubyBasicObject getTailNull(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        return this.createEmptyArray();
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject getTailIntegerFixnum(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((int[])ArrayNodes.getStore(array), this.index, ArrayNodes.getSize(array)), ArrayNodes.getSize(array) - this.index);
    }

    @Specialization(guards={"isLongArray(array)"})
    public RubyBasicObject getTailLongFixnum(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((long[])ArrayNodes.getStore(array), this.index, ArrayNodes.getSize(array)), ArrayNodes.getSize(array) - this.index);
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject getTailFloat(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((double[])ArrayNodes.getStore(array), this.index, ArrayNodes.getSize(array)), ArrayNodes.getSize(array) - this.index);
    }

    @Specialization(guards={"isObjectArray(array)"})
    public RubyBasicObject getTailObject(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((Object[])ArrayNodes.getStore(array), this.index, ArrayNodes.getSize(array)), ArrayNodes.getSize(array) - this.index);
    }
}

