/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.prism.parser;

import org.prism.AbstractNodeVisitor;
import org.prism.Nodes;

public class CoverageLineVisitor
extends AbstractNodeVisitor<Void> {
    private final Nodes.Source source;
    private int[] newlineMarked;

    CoverageLineVisitor(Nodes.Source source, int[] newlineMarked) {
        this.source = source;
        this.newlineMarked = newlineMarked;
    }

    @Override
    public Void visitCallNode(Nodes.CallNode node) {
        this.mark(node);
        return (Void)super.visitCallNode(node);
    }

    @Override
    public Void visitClassNode(Nodes.ClassNode node) {
        this.mark(node);
        return (Void)super.visitClassNode(node);
    }

    @Override
    public Void visitIfNode(Nodes.IfNode node) {
        this.mark(node);
        return (Void)super.visitIfNode(node);
    }

    @Override
    public Void visitDefNode(Nodes.DefNode node) {
        this.mark(node);
        return (Void)super.visitDefNode(node);
    }

    @Override
    public Void visitModuleNode(Nodes.ModuleNode node) {
        this.mark(node);
        return (Void)super.visitModuleNode(node);
    }

    @Override
    public Void visitUnlessNode(Nodes.UnlessNode node) {
        this.mark(node);
        return (Void)super.visitUnlessNode(node);
    }

    @Override
    public Void visitStatementsNode(Nodes.StatementsNode node) {
        for (Nodes.Node child : node.body) {
            this.mark(child);
        }
        return (Void)super.visitStatementsNode(node);
    }

    @Override
    protected Void defaultVisit(Nodes.Node node) {
        node.visitChildNodes(this);
        return null;
    }

    private Nodes.Node mark(Nodes.Node node) {
        int line = this.source.line(node.startOffset);
        if (line == 0) {
            System.out.println("node: " + node);
        }
        if (line > 0) {
            this.newlineMarked[line - 1] = 0;
        }
        return node;
    }
}

