/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.prism.builder;

import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.builder.LazyMethodDefinition;
import org.jruby.prism.builder.IRBuilderPrism;
import org.prism.AbstractNodeVisitor;
import org.prism.Nodes;

public class LazyMethodDefinitionPrism
implements LazyMethodDefinition<Nodes.Node, Nodes.DefNode, Nodes.WhenNode, Nodes.RescueNode, Nodes.ConstantPathNode, Nodes.HashPatternNode> {
    private final Nodes.Source nodeSource;
    private Nodes.DefNode node;
    private byte[] source;
    private final Encoding encoding;

    public LazyMethodDefinitionPrism(byte[] source, Nodes.Source nodeSource, Encoding encoding, Nodes.DefNode node) {
        this.source = source;
        this.node = node;
        this.nodeSource = nodeSource;
        this.encoding = encoding;
    }

    public int getEndLine() {
        return this.nodeSource.line(this.node.endOffset()) - 1;
    }

    public List<String> getMethodData() {
        final ArrayList<String> ivarNames = new ArrayList<String>();
        if (this.node.body != null) {
            this.node.body.accept(new AbstractNodeVisitor<Object>(){

                @Override
                protected Object defaultVisit(Nodes.Node node) {
                    if (node == null) {
                        return null;
                    }
                    if (node instanceof Nodes.InstanceVariableReadNode) {
                        ivarNames.add(((Nodes.InstanceVariableReadNode)node).name.idString());
                    } else if (node instanceof Nodes.InstanceVariableWriteNode) {
                        ivarNames.add(((Nodes.InstanceVariableWriteNode)node).name.idString());
                    }
                    Nodes.Node[] children = node.childNodes();
                    for (int i = 0; i < children.length; ++i) {
                        this.defaultVisit(children[i]);
                    }
                    return null;
                }
            });
        }
        return ivarNames;
    }

    public Nodes.DefNode getMethod() {
        return this.node;
    }

    public Nodes.Node getMethodBody() {
        return this.node.body;
    }

    public IRBuilder<Nodes.Node, Nodes.DefNode, Nodes.WhenNode, Nodes.RescueNode, Nodes.ConstantPathNode, Nodes.HashPatternNode> getBuilder(IRManager manager, IRMethod methodScope) {
        IRBuilder builder = manager.getBuilderFactory().newIRBuilder(manager, (IRScope)methodScope, null, this.encoding);
        ((IRBuilderPrism)builder).setSourceFrom(this.nodeSource, this.source);
        return builder;
    }
}

